/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.SingleItem;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.GlobalVariable;
import com.qizx.xquery.op.LeafExpression;
import com.qizx.xquery.op.LocalVariable;

public class VarReference
extends LeafExpression {
    public QName name;

    public VarReference(QName qName) {
        this.name = qName;
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header("var");
        exprDisplay.property("name", this.name);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        Local local = moduleContext.lookforClosureVariable(this.name);
        if (local != null) {
            return local.atSamePlaceAs(this);
        }
        GlobalVariable globalVariable = moduleContext.lookforGlobalVariable(this.name);
        if (globalVariable != null) {
            return new Global(globalVariable).atSamePlaceAs(this);
        }
        moduleContext.error("XPST0008", (Expression)this, "variable " + moduleContext.prefixedName(this.name) + " not declared");
        return this;
    }

    public static class Local
    extends VarReference {
        public LocalVariable decl;
        public int upLevel;

        public Local(LocalVariable localVariable) {
            super(localVariable.name);
            this.decl = localVariable;
            this.type = localVariable.type;
            localVariable.use();
        }

        Local(QName qName) {
            super(qName);
        }

        public boolean equals(Object object) {
            if (object instanceof Local) {
                return this.decl.equals(((Local)object).decl);
            }
            return false;
        }

        public int hashCode() {
            return this.decl.hashCode();
        }

        public void dump(ExprDisplay exprDisplay) {
            exprDisplay.header("local");
            exprDisplay.property("name", this.name);
            if (this.upLevel > 0) {
                exprDisplay.property("up", this.upLevel);
            }
            if (this.decl != null) {
                exprDisplay.property("address", this.decl.address);
            }
            exprDisplay.headerInfo(this);
        }

        public int getFlags() {
            return XQType.isRepeatable(this.type.getOccurrence()) ? 0 : 12;
        }

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            if (this.decl == null) {
                this.checkFocus(focus, evalContext);
                return new SingleItem(focus.currentItem());
            }
            return evalContext.loadLocal(this.decl.address);
        }

        public XQItem evalAsItem(Focus focus, EvalContext evalContext) throws EvaluationException {
            if (this.decl == null) {
                return focus.currentItem();
            }
            EvalContext evalContext2 = this.upLevel == 0 ? evalContext : evalContext.closure(this.upLevel);
            return evalContext2.loadLocalItem(this.decl.address);
        }

        public XQItem evalAsOptItem(Focus focus, EvalContext evalContext) throws EvaluationException {
            if (this.decl == null) {
                return focus.currentItem();
            }
            EvalContext evalContext2 = this.upLevel == 0 ? evalContext : evalContext.closure(this.upLevel);
            return evalContext2.loadLocalItem(this.decl.address);
        }

        public long evalAsInteger(Focus focus, EvalContext evalContext) throws EvaluationException {
            if (this.decl == null) {
                return focus.currentItemAsInteger();
            }
            EvalContext evalContext2 = this.upLevel == 0 ? evalContext : evalContext.closure(this.upLevel);
            return evalContext2.loadLocalInteger(this.decl.address);
        }

        public long evalAsOptInteger(Focus focus, EvalContext evalContext) throws EvaluationException {
            if (this.decl == null) {
                return focus.currentItemAsInteger();
            }
            EvalContext evalContext2 = this.upLevel == 0 ? evalContext : evalContext.closure(this.upLevel);
            return evalContext2.loadLocalInteger(this.decl.address);
        }

        public double evalAsDouble(Focus focus, EvalContext evalContext) throws EvaluationException {
            if (this.decl == null) {
                return focus.currentItemAsDouble();
            }
            EvalContext evalContext2 = this.upLevel == 0 ? evalContext : evalContext.closure(this.upLevel);
            return evalContext2.loadLocalDouble(this.decl.address);
        }

        public double evalAsOptDouble(Focus focus, EvalContext evalContext) throws EvaluationException {
            if (this.decl == null) {
                return focus.currentItemAsDouble();
            }
            EvalContext evalContext2 = this.upLevel == 0 ? evalContext : evalContext.closure(this.upLevel);
            return evalContext2.loadLocalDouble(this.decl.address);
        }

        public String evalAsString(Focus focus, EvalContext evalContext) throws EvaluationException {
            if (this.decl == null) {
                return focus.currentItemAsString();
            }
            EvalContext evalContext2 = this.upLevel == 0 ? evalContext : evalContext.closure(this.upLevel);
            return evalContext2.loadLocalString(this.decl.address);
        }

        public String evalAsOptString(Focus focus, EvalContext evalContext) throws EvaluationException {
            if (this.decl == null) {
                return focus.currentItemAsString();
            }
            EvalContext evalContext2 = this.upLevel == 0 ? evalContext : evalContext.closure(this.upLevel);
            return evalContext2.loadLocalString(this.decl.address);
        }
    }

    static class Global
    extends VarReference {
        GlobalVariable address;

        Global(GlobalVariable globalVariable) {
            super(globalVariable.name);
            this.address = globalVariable;
            this.type = globalVariable.getType();
        }

        public boolean equals(Object object) {
            if (object instanceof Global) {
                return this.address.name.equals(((Global)object).address.name);
            }
            return false;
        }

        public int hashCode() {
            return this.address.name.hashCode();
        }

        public void dump(ExprDisplay exprDisplay) {
            exprDisplay.header("global");
            exprDisplay.property("name", this.address.name);
            exprDisplay.property("declaredType", this.address.declaredType);
            exprDisplay.headerInfo(this);
        }

        public int getFlags() {
            return this.address.getFlags();
        }

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            return evalContext.loadGlobal(this.address);
        }
    }
}

