/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.ArraySequence;
import com.qizx.xquery.dt.SingleInteger;
import com.qizx.xquery.dt.SingleItem;
import com.qizx.xquery.fn.True;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.LocalVariable;
import com.qizx.xquery.op.VarClause;
import java.util.ArrayList;

public class WindowClause
extends VarClause {
    public Condition startCond;
    public Condition endCond;
    public boolean sliding;
    public boolean onlyEnd;

    public WindowClause(QName qName, boolean bl) {
        super(qName);
        this.sliding = bl;
        this.startCond = new Condition();
        this.endCond = new Condition();
    }

    public void dump(ExprDisplay exprDisplay) {
        exprDisplay.header(this);
        exprDisplay.property("variable", this.variable);
        exprDisplay.property("varAddress", this.varDecl.address);
        exprDisplay.property("declType", this.declaredType);
        this.startCond.dump(exprDisplay, true);
        if (this.endCond != null) {
            this.endCond.dump(exprDisplay, false);
        }
        exprDisplay.child("expr", this.expr);
    }

    public Expression staticCheck(ModuleContext moduleContext, int n) {
        if (this.checked) {
            return this;
        }
        this.checked = true;
        this.expr = moduleContext.staticCheck(this.expr, 0);
        this.type = this.declaredType;
        if (this.type == null) {
            this.type = this.expr.getType();
        }
        this.startCond.staticCheck(moduleContext, this);
        if (this.endCond != null) {
            this.endCond.staticCheck(moduleContext, this);
        }
        this.varDecl = moduleContext.defineLocalVariable(this.variable, this.declaredType, this);
        this.varDecl.offset = this.offset;
        if (this.declaredType != null) {
            this.varDecl.address = -1;
        } else {
            this.varDecl.storageType(this.type, moduleContext);
        }
        return this;
    }

    public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
        return new Sequence(focus, evalContext);
    }

    public class Sequence
    extends VarClause.SingleDummy {
        private ArrayList window;
        private XQValue input;
        protected int position;
        protected XQItem previous;
        protected XQItem current;
        protected XQItem next;
        private ArrayList backInput;

        Sequence(Focus focus, EvalContext evalContext) {
            super(focus, evalContext);
        }

        public XQValue bornAgain() {
            Sequence sequence = new Sequence(this.focus, this.context);
            sequence.setSource(this.source.bornAgain());
            return sequence;
        }

        public boolean next() throws EvaluationException {
            while (!this.nextWindow(false)) {
                if (!this.source.next()) {
                    return false;
                }
                this.resetInput();
            }
            return true;
        }

        public boolean nextCollection() throws EvaluationException {
            while (!this.nextWindow(true)) {
                if (!this.source.next()) {
                    return false;
                }
                this.input = WindowClause.this.expr.eval(this.focus, this.context);
                this.resetInput();
            }
            return true;
        }

        private boolean nextWindow(boolean bl) throws EvaluationException {
            Object object;
            if (this.input == null) {
                return false;
            }
            this.window = new ArrayList();
            do {
                if (this.moveToNextItem()) continue;
                return false;
            } while (!WindowClause.this.startCond.bindEval(this, this.focus, this.context));
            this.window.add(this.current);
            boolean bl2 = WindowClause.this.endCond == null;
            while (true) {
                Object object2 = object = WindowClause.this.endCond == null ? WindowClause.this.startCond : WindowClause.this.endCond;
                if (!bl2 && ((Condition)object).bindEval(this, this.focus, this.context)) break;
                bl2 = false;
                if (!this.moveToNextItem()) {
                    if (!WindowClause.this.onlyEnd) break;
                    return false;
                }
                this.window.add(this.current);
            }
            object = null;
            if (WindowClause.this.endCond == null && this.current != null) {
                object = this.current;
                this.window.remove(this.window.size() - 1);
            }
            try {
                ArraySequence arraySequence = new ArraySequence(this.window.size(), this.window.toArray(), this);
                this.context.storeLocal(WindowClause.this.varDecl.address, arraySequence, false, WindowClause.this.declaredType);
            }
            catch (XQTypeException xQTypeException) {
                this.context.error("XPTY0004", (Expression)WindowClause.this, "dynamic type mismatch on window variable $" + WindowClause.this.varDecl.name + ": expecting " + WindowClause.this.declaredType);
            }
            if (WindowClause.this.sliding) {
                int n = this.window.size() - 1;
                this.current = (XQItem)this.window.get(n);
                while (--n >= 0) {
                    this.putBack((XQItem)this.window.get(n));
                }
            } else if (WindowClause.this.endCond == null) {
                this.putBack((XQItem)object);
            }
            return true;
        }

        private void resetInput() throws EvaluationException {
            this.input = WindowClause.this.expr.eval(this.focus, this.context);
            this.position = 0;
            this.current = null;
            this.previous = null;
            this.next = this.input.next() ? this.input.getItem() : null;
        }

        private boolean moveToNextItem() throws EvaluationException {
            this.previous = this.current;
            this.current = this.next;
            if (this.backInput != null) {
                this.next = (XQItem)this.backInput.remove(this.backInput.size() - 1);
                if (this.backInput.size() == 0) {
                    this.backInput = null;
                }
            } else {
                if (this.next == null) {
                    return false;
                }
                this.next = !this.input.next() ? null : this.input.getItem();
            }
            ++this.position;
            return true;
        }

        private void putBack(XQItem xQItem) {
            if (this.next != null) {
                if (this.backInput == null) {
                    this.backInput = new ArrayList();
                }
                this.backInput.add(this.next);
            }
            --this.position;
            this.next = this.current;
            this.current = xQItem;
        }
    }

    public static class Condition {
        public Expression cond;
        public QName itemVarName;
        public LocalVariable itemVar;
        public QName atVarName;
        public LocalVariable atVar;
        public QName previousVarName;
        public LocalVariable previousVar;
        public QName nextVarName;
        public LocalVariable nextVar;

        public void staticCheck(ModuleContext moduleContext, WindowClause windowClause) {
            if (this.itemVarName != null) {
                this.itemVar = moduleContext.defineLocalVariable(this.itemVarName, XQType.ITEM.opt, windowClause);
            }
            if (this.atVarName != null) {
                this.atVar = moduleContext.defineLocalVariable(this.atVarName, XQType.INTEGER, windowClause);
            }
            if (this.previousVarName != null) {
                this.previousVar = moduleContext.defineLocalVariable(this.previousVarName, XQType.ITEM.opt, windowClause);
            }
            if (this.nextVarName != null) {
                this.nextVar = moduleContext.defineLocalVariable(this.nextVarName, XQType.ITEM.opt, windowClause);
            }
            this.cond = this.cond.staticCheck(moduleContext, 0);
            if (this.cond instanceof True.Exec) {
                this.cond = null;
            }
        }

        boolean bindEval(Sequence sequence, Focus focus, EvalContext evalContext) throws EvaluationException {
            this.bindVar(this.itemVar, sequence.current, evalContext);
            this.bindVar(this.previousVar, sequence.previous, evalContext);
            this.bindVar(this.nextVar, sequence.next, evalContext);
            if (this.atVar != null) {
                evalContext.storeLocal(this.atVar.address, new SingleInteger(sequence.position), false, null);
            }
            if (this.cond == null) {
                return true;
            }
            return this.cond.evalEffectiveBooleanValue(focus, evalContext);
        }

        private void bindVar(LocalVariable localVariable, XQItem xQItem, EvalContext evalContext) throws EvaluationException {
            if (localVariable != null) {
                evalContext.storeLocal(localVariable.address, xQItem == null ? XQValue.empty : new SingleItem(xQItem), false, null);
            }
        }

        public void dump(ExprDisplay exprDisplay, boolean bl) {
            exprDisplay.header(bl ? "start" : "end");
            if (this.itemVar != null) {
                exprDisplay.child("current", "" + this.itemVar);
            }
            if (this.atVar != null) {
                exprDisplay.child("at", "" + this.atVar);
            }
            if (this.previousVar != null) {
                exprDisplay.child("previous", "" + this.previousVar);
            }
            if (this.nextVar != null) {
                exprDisplay.child("next", "" + this.nextVar);
            }
            exprDisplay.child(this.cond);
            exprDisplay.end();
        }
    }
}

