/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.netutil;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;

public class Request {
    public static final String DEFAULT_CHAR_ENCODING = "UTF-8";
    private static final String QIZX_ERROR = "text/x-qizx-error";
    public static final String CONTENT_TYPE = "Content-Type";
    protected HashMap<String, String[]> headers;
    protected String charEncoding;
    protected HttpURLConnection connection;

    public void setCharacterEncoding(String string) {
        if (string == null) {
            string = DEFAULT_CHAR_ENCODING;
        }
        this.charEncoding = string;
    }

    public String getCharacterEncoding() {
        return this.charEncoding;
    }

    public void setHeader(String string, String string2) {
        this.headers.put(string, new String[]{string2});
    }

    public void addHeader(String string, String string2) {
        String[] stringArray = this.headers.get(string);
        if (stringArray == null) {
            stringArray = new String[]{string2};
        } else {
            int n = stringArray.length;
            String[] stringArray2 = new String[n + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray2[n] = string2;
            stringArray = stringArray2;
        }
        this.headers.put(string, stringArray);
    }

    public String[] getHeader(String string) {
        return this.headers.get(string);
    }

    public String[] getHeaderNames() {
        String[] stringArray = new String[this.headers.size()];
        return this.headers.keySet().toArray(stringArray);
    }

    public String getResultMimeType() {
        Request.checkState(this.connection);
        return this.connection.getContentType();
    }

    public void checkError() throws IOException {
        Request.checkResponse(this.connection);
        String string = this.connection.getContentType();
        if (string != null && string.startsWith(QIZX_ERROR)) {
            throw new IOException(this.getStringResponse());
        }
    }

    public boolean isError() throws IOException {
        Request.checkState(this.connection);
        int n = this.connection.getResponseCode();
        if (n >= 400) {
            return true;
        }
        String string = this.connection.getContentType();
        return string != null && string.startsWith(QIZX_ERROR);
    }

    public String getErrorString() throws IOException {
        Request.checkState(this.connection);
        if (this.connection.getResponseCode() >= 400) {
            return this.connection.getResponseMessage();
        }
        return this.getStringResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringResponse() throws IOException {
        Request.checkState(this.connection);
        InputStream inputStream = this.connection.getInputStream();
        try {
            String string = FileUtil.loadString(inputStream, DEFAULT_CHAR_ENCODING);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public InputStream getStreamResponse() throws IOException {
        return Request.getResponseStream(this.connection);
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public static HttpURLConnection openConnection(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setConnectTimeout(10000);
        httpURLConnection.setRequestMethod("GET");
        return httpURLConnection;
    }

    static int checkResponse(HttpURLConnection httpURLConnection) throws IOException {
        Request.checkState(httpURLConnection);
        int n = httpURLConnection.getResponseCode();
        if (n >= 300) {
            StringBuilder stringBuilder = new StringBuilder("failed request on ");
            stringBuilder.append(httpURLConnection.getURL());
            stringBuilder.append(": error ");
            stringBuilder.append(n);
            String string = httpURLConnection.getResponseMessage();
            if (string != null) {
                stringBuilder.append(": ");
                stringBuilder.append(string);
            }
            throw new IOException(stringBuilder.toString());
        }
        return n;
    }

    private static void checkState(HttpURLConnection httpURLConnection) {
        if (httpURLConnection == null) {
            throw new IllegalStateException("not connected");
        }
    }

    public static InputStream getResponseStream(HttpURLConnection httpURLConnection) throws IOException {
        return httpURLConnection.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResponseText(HttpURLConnection httpURLConnection, String string) throws IOException {
        if (httpURLConnection == null) {
            throw new IllegalArgumentException("null connection");
        }
        String string2 = httpURLConnection.getContentType();
        if (string2 == null || !string2.toLowerCase().startsWith("text/")) {
            return null;
        }
        String string3 = URLUtil.contentTypeToCharset(string2);
        if (string3 == null) {
            string3 = string;
        }
        String string4 = null;
        InputStream inputStream = httpURLConnection.getInputStream();
        try {
            string4 = FileUtil.loadString(inputStream, string3);
        }
        finally {
            inputStream.close();
        }
        return string4;
    }
}

