/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public final class Base64 {
    private static final String digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private static final char[] toDigit;
    private static byte[] toDigit2;
    private static byte[] fromDigit;
    private static final int SPACE_OR_DIGIT1 = 0;
    private static final int DIGIT1 = 1;
    private static final int DIGIT2 = 2;
    private static final int DIGIT3_OR_EQUAL = 3;
    private static final int EQUAL = 4;
    private static final int DIGIT4_OR_EQUAL = 5;
    private static final int END_OR_SPACE = 6;

    private Base64() {
    }

    public static byte[] decode(String string) {
        return Base64.decode(string, Integer.MAX_VALUE);
    }

    public static byte[] decode(String string, int n) {
        int n2 = string.length();
        byte[] byArray = new byte[3 * (n2 / 4) + 2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        block12: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            byte by = 0;
            switch (n4) {
                case 0: {
                    if (Character.isWhitespace(c)) continue block12;
                    if (c > '\u00ff' || (by = fromDigit[c]) < 0) {
                        return null;
                    }
                    n4 = 2;
                    break;
                }
                case 1: {
                    if (c > '\u00ff' || (by = fromDigit[c]) < 0) {
                        return null;
                    }
                    n4 = 2;
                    break;
                }
                case 2: {
                    if (c > '\u00ff' || (by = fromDigit[c]) < 0) {
                        return null;
                    }
                    n4 = 3;
                    break;
                }
                case 3: {
                    if (c == '=') {
                        n4 = 4;
                        continue block12;
                    }
                    if (c > '\u00ff' || (by = fromDigit[c]) < 0) {
                        return null;
                    }
                    n4 = 5;
                    break;
                }
                case 4: {
                    if (c == '=') {
                        n4 = 6;
                        continue block12;
                    }
                    return null;
                }
                case 5: {
                    if (c == '=') {
                        n4 = 6;
                        continue block12;
                    }
                    if (c > '\u00ff' || (by = fromDigit[c]) < 0) {
                        return null;
                    }
                    n4 = 0;
                    break;
                }
                case 6: {
                    if (Character.isWhitespace(c)) continue block12;
                    return null;
                }
                default: {
                    throw new RuntimeException("unknown state " + n4);
                }
            }
            n5 <<= 6;
            n5 |= by;
            if ((n6 += 6) < 8) continue;
            byArray[n3++] = (byte)(n5 >> (n6 -= 8) & 0xFF);
            if (n3 < n) continue;
            n4 = 6;
            break;
        }
        switch (n4) {
            case 0: 
            case 1: 
            case 6: {
                break;
            }
            default: {
                return null;
            }
        }
        if (n3 != byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            byArray = byArray2;
        }
        return byArray;
    }

    public static String encode(byte[] byArray) {
        int n = byArray.length;
        int n2 = (n + 2) / 3 * 4;
        char[] cArray = new char[n2 + (n2 + 75) / 76];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; i += 3) {
            boolean bl = false;
            boolean bl2 = false;
            int n5 = byArray[i] & 0xFF;
            n5 <<= 8;
            if (i + 1 < n) {
                n5 |= byArray[i + 1] & 0xFF;
                bl2 = true;
            }
            n5 <<= 8;
            if (i + 2 < n) {
                n5 |= byArray[i + 2] & 0xFF;
                bl = true;
            }
            cArray[n3 + 3] = toDigit[bl ? n5 & 0x3F : 64];
            cArray[n3 + 2] = toDigit[bl2 ? (n5 >>>= 6) & 0x3F : 64];
            cArray[n3 + 1] = toDigit[(n5 >>>= 6) & 0x3F];
            cArray[n3] = toDigit[(n5 >>>= 6) & 0x3F];
            n3 += 4;
            if ((n4 += 4) != 76) continue;
            cArray[n3++] = 10;
            n4 = 0;
        }
        if (n4 > 0) {
            cArray[n3] = 10;
        }
        return new String(cArray);
    }

    static {
        int n;
        toDigit = digits.toCharArray();
        try {
            toDigit2 = digits.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        fromDigit = new byte[256];
        for (n = 0; n < 256; ++n) {
            Base64.fromDigit[n] = -1;
        }
        for (n = 65; n <= 90; ++n) {
            Base64.fromDigit[n] = (byte)(n - 65);
        }
        for (n = 97; n <= 122; ++n) {
            Base64.fromDigit[n] = (byte)(26 + n - 97);
        }
        for (n = 48; n <= 57; ++n) {
            Base64.fromDigit[n] = (byte)(52 + n - 48);
        }
        Base64.fromDigit[43] = 62;
        Base64.fromDigit[47] = 63;
    }

    public static final class OutputStream
    extends FilterOutputStream {
        private byte[] bytes = new byte[3];
        private int byteCount = 0;
        private byte[] encoded;
        private int encodedSize;
        private int lineLength;

        public OutputStream(java.io.OutputStream outputStream) {
            this(outputStream, 4096);
        }

        public OutputStream(java.io.OutputStream outputStream, int n) {
            super(outputStream);
            this.encoded = new byte[n];
            this.lineLength = 0;
            this.encodedSize = 0;
        }

        public void write(int n) throws IOException {
            if (this.byteCount == 3) {
                this.encode();
            }
            this.bytes[this.byteCount++] = (byte)n;
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                if (this.byteCount == 3) {
                    this.encode();
                }
                this.bytes[this.byteCount++] = byArray[n + i];
            }
        }

        public void flush() throws IOException {
            if (this.encodedSize > 0) {
                this.out.write(this.encoded, 0, this.encodedSize);
                this.encodedSize = 0;
            }
            this.out.flush();
        }

        public void close() throws IOException {
            this.encode();
            if (this.lineLength > 0) {
                this.encoded[this.encodedSize++] = 10;
            }
            this.flush();
            this.out.close();
        }

        private void encode() throws IOException {
            if (this.byteCount > 0) {
                if (this.encodedSize + 5 >= this.encoded.length) {
                    this.out.write(this.encoded, 0, this.encodedSize);
                    this.encodedSize = 0;
                }
                boolean bl = false;
                boolean bl2 = false;
                int n = this.bytes[0] & 0xFF;
                n <<= 8;
                if (this.byteCount > 1) {
                    n |= this.bytes[1] & 0xFF;
                    bl2 = true;
                }
                n <<= 8;
                if (this.byteCount > 2) {
                    n |= this.bytes[2] & 0xFF;
                    bl = true;
                }
                this.encoded[this.encodedSize + 3] = toDigit2[bl ? n & 0x3F : 64];
                this.encoded[this.encodedSize + 2] = toDigit2[bl2 ? (n >>>= 6) & 0x3F : 64];
                this.encoded[this.encodedSize + 1] = toDigit2[(n >>>= 6) & 0x3F];
                this.encoded[this.encodedSize] = toDigit2[(n >>>= 6) & 0x3F];
                this.encodedSize += 4;
                this.lineLength += 4;
                if (this.lineLength == 76) {
                    this.encoded[this.encodedSize++] = 10;
                    this.lineLength = 0;
                }
                this.byteCount = 0;
            }
        }
    }

    public static final class InputStream
    extends FilterInputStream {
        private byte[] decoded;
        private int decodedSize;
        private int decodedPos;

        public InputStream(java.io.InputStream inputStream) {
            this(inputStream, 4096);
        }

        public InputStream(java.io.InputStream inputStream, int n) {
            super(inputStream);
            n = 3 * (n / 4);
            if (n <= 0) {
                n = 3072;
            }
            this.decoded = new byte[n];
            this.decodedPos = 0;
            this.decodedSize = 0;
        }

        public int read() throws IOException {
            if (this.decodedPos == this.decodedSize) {
                this.decode();
            }
            if (this.decodedSize == 0) {
                return -1;
            }
            return this.decoded[this.decodedPos++] & 0xFF;
        }

        private void decode() throws IOException {
            this.decodedPos = 0;
            this.decodedSize = 0;
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            block12: while (true) {
                int n4;
                if ((n4 = this.in.read()) < 0) {
                    bl = true;
                    break;
                }
                char c = (char)(n4 & 0xFF);
                byte by = 0;
                switch (n) {
                    case 0: {
                        if (Character.isWhitespace(c)) continue block12;
                        if (c > '\u00ff' || (by = fromDigit[c]) < 0) {
                            throw new IOException("invalid base 64 data");
                        }
                        n = 2;
                        break;
                    }
                    case 1: {
                        if (c > '\u00ff' || (by = fromDigit[c]) < 0) {
                            throw new IOException("invalid base 64 data");
                        }
                        n = 2;
                        break;
                    }
                    case 2: {
                        if (c > '\u00ff' || (by = fromDigit[c]) < 0) {
                            throw new IOException("invalid base 64 data");
                        }
                        n = 3;
                        break;
                    }
                    case 3: {
                        if (c == '=') {
                            n = 4;
                            continue block12;
                        }
                        if (c > '\u00ff' || (by = fromDigit[c]) < 0) {
                            throw new IOException("invalid base 64 data");
                        }
                        n = 5;
                        break;
                    }
                    case 4: {
                        if (c == '=') {
                            n = 6;
                            continue block12;
                        }
                        throw new IOException("invalid base 64 data");
                    }
                    case 5: {
                        if (c == '=') {
                            n = 6;
                            continue block12;
                        }
                        if (c > '\u00ff' || (by = fromDigit[c]) < 0) {
                            throw new IOException("invalid base 64 data");
                        }
                        n = 0;
                        break;
                    }
                    case 6: {
                        if (Character.isWhitespace(c)) continue block12;
                        throw new IOException("invalid base 64 data");
                    }
                    default: {
                        throw new RuntimeException("unknown state " + n);
                    }
                }
                n2 <<= 6;
                n2 |= by;
                if ((n3 += 6) < 8) continue;
                this.decoded[this.decodedSize++] = (byte)(n2 >> (n3 -= 8) & 0xFF);
                if (this.decodedSize == this.decoded.length) break;
            }
            if (bl) {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 6: {
                        break;
                    }
                    default: {
                        throw new IOException("truncated base 64 data (state=" + n + ")");
                    }
                }
            }
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = this.read();
                if (n4 < 0) {
                    return n3 > 0 ? n3 : -1;
                }
                byArray[n + n3] = (byte)n4;
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            long l2;
            for (l2 = 0L; l2 < l && this.read() >= 0; ++l2) {
            }
            return l2;
        }

        public int available() throws IOException {
            return this.decodedSize - this.decodedPos;
        }

        public void close() throws IOException {
            this.in.close();
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int n) {
        }

        public void reset() throws IOException {
            throw new IOException("mark not supported");
        }
    }
}

