/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import java.util.ArrayList;
import java.util.StringTokenizer;

public final class StringUtil {
    public static final String[] EMPTY_LIST = new String[0];

    private StringUtil() {
    }

    public static String[] split(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String[] split(String string, char c) {
        int n;
        if (string.length() == 0) {
            return EMPTY_LIST;
        }
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(c, n3)) >= 0) {
            ++n2;
            ++n3;
        }
        String[] stringArray = new String[++n2];
        n2 = 0;
        n3 = 0;
        while ((n = string.indexOf(c, n3)) >= 0) {
            stringArray[n2++] = n3 == n ? "" : string.substring(n3, n);
            n3 = n + 1;
        }
        stringArray[n2++] = string.substring(n3);
        return stringArray;
    }

    public static String join(char c, String ... stringArray) {
        return StringUtil.join(Character.toString(c), stringArray);
    }

    public static String join(String string, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = stringArray.length;
        if (n > 0) {
            stringBuilder.append(stringArray[0]);
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(string);
                stringBuilder.append(stringArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    public static final String[] wordWrap(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = StringUtil.split(string, '\n');
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if ((string2 = string2.trim()).length() == 0) {
                arrayList.add("");
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n2 = stringBuilder.length();
                if (n2 > 0 && n2 + string3.length() > n) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    n2 = 0;
                }
                if (n2 > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(string3);
            }
            if (stringBuilder.length() <= 0) continue;
            arrayList.add(stringBuilder.toString());
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    public static String[] splitArguments(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        char c = '\u0000';
        StringBuilder stringBuilder = null;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (Character.isWhitespace(c2)) {
                if (c != '\u0000') {
                    stringBuilder.append(c2);
                    continue;
                }
                if (stringBuilder == null) continue;
                arrayList.add(stringBuilder.toString());
                stringBuilder = null;
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
                switch (c2) {
                    case '\"': 
                    case '\'': {
                        c = c2;
                        break;
                    }
                    default: {
                        stringBuilder.append(c2);
                        break;
                    }
                }
                continue;
            }
            if (c2 == c) {
                int n2 = stringBuilder.length() - 1;
                if (n2 >= 0 && stringBuilder.charAt(n2) == '\\') {
                    stringBuilder.setCharAt(n2, c);
                    continue;
                }
                arrayList.add(stringBuilder.toString());
                stringBuilder = null;
                c = '\u0000';
                continue;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder != null) {
            arrayList.add(stringBuilder.toString());
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public static String joinArguments(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(StringUtil.quoteArgument(stringArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String quoteArgument(String string) {
        boolean bl;
        int n = string.length();
        if (n == 0) {
            bl = true;
        } else {
            block0 : switch (string.charAt(0)) {
                case '\"': 
                case '\'': {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    for (int i = 0; i < n; ++i) {
                        if (!Character.isWhitespace(string.charAt(i))) continue;
                        bl = true;
                        break block0;
                    }
                }
            }
        }
        if (!bl) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public static String substituteVars(String string, String[] stringArray) {
        return StringUtil.substituteVars(string, stringArray, null, null);
    }

    public static String substituteVars(String string, char[] cArray, Object[] objectArray) {
        return StringUtil.substituteVars(string, null, cArray, objectArray);
    }

    public static String substituteVars(String string, String[] stringArray, char[] cArray, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = string.length();
        block17: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (n) {
                case 1: {
                    int n3;
                    Object object;
                    switch (c) {
                        case '%': {
                            stringBuilder.append('%');
                            n = 0;
                            continue block17;
                        }
                        case '{': {
                            n = 2;
                            continue block17;
                        }
                        case '*': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (stringArray == null) {
                                stringBuilder.append('%');
                                stringBuilder.append(c);
                            } else if (c == '*') {
                                stringBuilder.append(StringUtil.joinArguments(stringArray));
                            } else if (c - 48 < stringArray.length) {
                                stringBuilder.append(stringArray[c - 48]);
                            }
                            n = 0;
                            continue block17;
                        }
                    }
                    if (cArray == null) {
                        stringBuilder.append('%');
                        stringBuilder.append(c);
                    } else {
                        object = null;
                        for (n3 = 0; n3 < cArray.length; ++n3) {
                            if (c != cArray[n3]) continue;
                            object = objectArray[n3];
                            break;
                        }
                        if (object == null) {
                            stringBuilder.append('%');
                            stringBuilder.append(c);
                        } else {
                            stringBuilder.append(object.toString());
                        }
                    }
                    n = 0;
                    continue block17;
                }
                case 2: {
                    int n3;
                    switch (c) {
                        case '*': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (stringArray == null) {
                                stringBuilder.append("%{");
                                stringBuilder.append(c);
                                n = 0;
                                continue block17;
                            }
                            if (c == '*') {
                                stringBuilder.append(StringUtil.joinArguments(stringArray));
                            } else if (c - 48 < stringArray.length) {
                                stringBuilder.append(stringArray[c - 48]);
                            }
                            n = 3;
                            continue block17;
                        }
                    }
                    if (cArray == null) {
                        stringBuilder.append("%{");
                        stringBuilder.append(c);
                        n = 0;
                        continue block17;
                    }
                    Object object = null;
                    for (n3 = 0; n3 < cArray.length; ++n3) {
                        if (c != cArray[n3]) continue;
                        object = objectArray[n3];
                        break;
                    }
                    if (object == null) {
                        stringBuilder.append("%{");
                        stringBuilder.append(c);
                        n = 0;
                        continue block17;
                    }
                    stringBuilder.append(object.toString());
                    n = 3;
                    continue block17;
                }
                case 3: {
                    if (c != '}') {
                        stringBuilder.append(c);
                    }
                    n = 0;
                    continue block17;
                }
                default: {
                    if (c == '%') {
                        n = 1;
                        continue block17;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        switch (n) {
            case 1: {
                stringBuilder.append('%');
                break;
            }
            case 2: {
                stringBuilder.append("%{");
            }
        }
        return stringBuilder.toString();
    }

    public static String replaceAll(String string, String string2, String string3) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string2.length();
        int n3 = 0;
        while ((n = string.indexOf(string2, n3)) >= 0) {
            if (n > n3) {
                stringBuilder.append(string.substring(n3, n));
            }
            stringBuilder.append(string3);
            n3 = n + n2;
        }
        if (n3 < string.length()) {
            stringBuilder.append(string.substring(n3));
        }
        return stringBuilder.toString();
    }

    public static String capitalize(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        if (n == 1) {
            return string.toUpperCase();
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String uncapitalize(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        if (n == 1) {
            return string.toLowerCase();
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    public static String quote(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        StringUtil.escape(string, stringBuilder);
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringUtil.escape(string, stringBuilder);
        return stringBuilder.toString();
    }

    public static void escape(String string, StringBuilder stringBuilder) {
        int n = string.length();
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        stringBuilder.append(c);
                        continue block10;
                    }
                    StringUtil.escape(c, stringBuilder);
                }
            }
        }
    }

    public static String escape(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        StringUtil.escape(c, stringBuilder);
        return stringBuilder.toString();
    }

    public static void escape(char c, StringBuilder stringBuilder) {
        stringBuilder.append("\\u");
        String string = Integer.toString(c, 16);
        for (int i = string.length(); i < 4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
    }

    public static String unquote(String string) {
        int n = string.length();
        if (n >= 2 && string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
            return StringUtil.unescape(string, 1, n - 2);
        }
        return StringUtil.unescape(string, 0, n);
    }

    public static String unescape(String string) {
        return StringUtil.unescape(string, 0, string.length());
    }

    private static String unescape(String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n + n2;
        block16: for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    if (i + 1 == n3) {
                        stringBuilder.append(c);
                        continue block16;
                    }
                    switch (string.charAt(i + 1)) {
                        case 'b': {
                            stringBuilder.append('\b');
                            ++i;
                            continue block16;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            ++i;
                            continue block16;
                        }
                        case 'n': {
                            stringBuilder.append('\n');
                            ++i;
                            continue block16;
                        }
                        case 'f': {
                            stringBuilder.append('\f');
                            ++i;
                            continue block16;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            ++i;
                            continue block16;
                        }
                        case '\"': {
                            stringBuilder.append('\"');
                            ++i;
                            continue block16;
                        }
                        case '\'': {
                            stringBuilder.append('\'');
                            ++i;
                            continue block16;
                        }
                        case '\\': {
                            stringBuilder.append('\\');
                            ++i;
                            continue block16;
                        }
                        case 'u': {
                            if (i + 5 >= n3) break;
                            int n4 = -1;
                            try {
                                n4 = Integer.parseInt(string.substring(i + 2, i + 6), 16);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n4 < 0) break;
                            stringBuilder.append((char)n4);
                            i += 5;
                            continue block16;
                        }
                    }
                    stringBuilder.append(c);
                    continue block16;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

