/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.ObjectUtil;
import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.URIComponent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public final class URLUtil {
    private URLUtil() {
    }

    public static URL createURL(String string) throws MalformedURLException {
        return new URL(URIComponent.encode(string));
    }

    public static URL createURL(URL uRL, String string) throws MalformedURLException {
        return new URL(uRL, URIComponent.encode(string));
    }

    public static URL createURL(URL uRL, String string, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        return new URL(uRL, URIComponent.encode(string), uRLStreamHandler);
    }

    public static boolean isFileURL(URL uRL) {
        return "file".equals(uRL.getProtocol());
    }

    public static boolean isJarURL(URL uRL) {
        return "jar".equals(uRL.getProtocol());
    }

    public static File urlToFile(URL uRL) {
        if (!URLUtil.isFileURL(uRL)) {
            return null;
        }
        if (SystemUtil.IS_WINDOWS) {
            String string = uRL.getHost();
            if (string != null && string.length() > 0 && !"localhost".equalsIgnoreCase(string)) {
                String string2;
                Comparable<URI> comparable;
                String string3 = uRL.getPath();
                if (string3.length() == 0) {
                    string3 = "/";
                }
                string3 = "file:/C:" + string3;
                try {
                    comparable = new URI(URIComponent.encode(string3));
                    string2 = new File((URI)comparable).getPath();
                }
                catch (Exception exception) {
                    return null;
                }
                string2 = "\\\\" + string + string2.substring(2);
                comparable = new File(string2);
                try {
                    comparable = ((File)comparable).getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return comparable;
            }
            return URLUtil.convertURLToFile(uRL);
        }
        return URLUtil.convertURLToFile(uRL);
    }

    private static File convertURLToFile(URL uRL) {
        assert (URLUtil.isFileURL(uRL));
        try {
            String string = uRL.getPath();
            if (string.length() == 0) {
                string = "/";
            }
            string = "file://" + string;
            URI uRI = new URI(URIComponent.encode(string));
            if (SystemUtil.IS_WINDOWS) {
                File file = new File(uRI);
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return file;
            }
            uRI = uRI.normalize();
            return new File(uRI);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static URI urlToURI(URL uRL) {
        String string = uRL.toExternalForm();
        try {
            return new URI(URIComponent.encode(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static URL urlOrFile(String string) {
        return URLUtil.urlOrFile(string, false, false, null);
    }

    public static URL urlOrFile(String string, boolean bl) {
        return URLUtil.urlOrFile(string, bl, false, null);
    }

    public static URL urlOrFile(String string, boolean bl, boolean bl2) {
        return URLUtil.urlOrFile(string, bl, bl2, null);
    }

    public static URL urlOrFile(String string, boolean bl, boolean bl2, URL uRL) {
        int n = string.indexOf(10);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        URL uRL2 = null;
        try {
            uRL2 = URLUtil.createURL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL2 == null) {
            File file = new File(string);
            if (bl && !file.isAbsolute()) {
                return null;
            }
            if (bl2 ? !file.exists() : !file.isFile()) {
                return null;
            }
            uRL2 = FileUtil.fileToURL(file);
        }
        return uRL2;
    }

    public static boolean sameRoot(URL uRL, URL uRL2) {
        return ObjectUtil.equals(URLUtil.getRoot(uRL, true), URLUtil.getRoot(uRL2, true));
    }

    public static URL getRoot(URL uRL) {
        return URLUtil.getRoot(uRL, false);
    }

    private static URL getRoot(URL uRL, boolean bl) {
        String[] stringArray;
        int n = uRL.getPort();
        if (n < 0 && bl) {
            n = uRL.getDefaultPort();
        }
        if ((stringArray = URLUtil.splitPath(uRL)) == null) {
            stringArray = new String[]{null, "/"};
        }
        stringArray[1] = "/";
        String string = URIComponent.joinQuotedComponents(uRL.getProtocol(), uRL.getUserInfo(), null, uRL.getHost(), n, URLUtil.joinPath(stringArray), null, null);
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    private static String[] splitPath(URL uRL) {
        String string = uRL.getPath();
        if (string.length() == 0) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        if (URLUtil.isJarURL(uRL)) {
            int n = string.indexOf("!/");
            if (n < 0) {
                return null;
            }
            string2 = string.substring(0, n + 1);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        return new String[]{string2, string3};
    }

    private static String joinPath(String[] stringArray) {
        if (stringArray[0] == null) {
            return stringArray[1];
        }
        return stringArray[0] + stringArray[1];
    }

    public static URL getParent(URL uRL) {
        String[] stringArray = URLUtil.splitPath(uRL);
        if (stringArray == null) {
            return null;
        }
        stringArray[1] = URIComponent.getRawParentPath(stringArray[1]);
        if (stringArray[1] == null) {
            return null;
        }
        String string = URIComponent.joinQuotedComponents(uRL.getProtocol(), uRL.getUserInfo(), null, uRL.getHost(), uRL.getPort(), URLUtil.joinPath(stringArray), null, null);
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static String getBaseName(URL uRL) {
        String string = URLUtil.getRawBaseName(uRL);
        return string == null ? null : URIComponent.decode(string);
    }

    public static String getRawBaseName(URL uRL) {
        String[] stringArray = URLUtil.splitPath(uRL);
        return stringArray == null ? null : URIComponent.getRawBaseName(stringArray[1]);
    }

    public static String getExtension(URL uRL) {
        String string = URLUtil.getRawExtension(uRL);
        return string == null ? null : URIComponent.decode(string);
    }

    public static String getRawExtension(URL uRL) {
        String[] stringArray = URLUtil.splitPath(uRL);
        return stringArray == null ? null : URIComponent.getRawExtension(stringArray[1]);
    }

    public static URL setExtension(URL uRL, String string) {
        if (string != null) {
            string = URIComponent.quotePath(string);
        }
        return URLUtil.setRawExtension(uRL, string);
    }

    public static URL setRawExtension(URL uRL, String string) {
        String[] stringArray = URLUtil.splitPath(uRL);
        if (stringArray == null || stringArray[1].endsWith("/")) {
            return uRL;
        }
        stringArray[1] = URIComponent.setRawExtension(stringArray[1], string);
        String string2 = URIComponent.joinQuotedComponents(uRL.getProtocol(), uRL.getUserInfo(), null, uRL.getHost(), uRL.getPort(), URLUtil.joinPath(stringArray), uRL.getQuery(), uRL.getRef());
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static String getFragment(URL uRL) {
        String string = uRL.getRef();
        return string == null ? null : URIComponent.decode(string);
    }

    public static URL setFragment(URL uRL, String string) {
        if (string != null) {
            string = URIComponent.quoteFragment(string);
        }
        return URLUtil.setRawFragment(uRL, string);
    }

    public static URL setRawFragment(URL uRL, String string) {
        String[] stringArray = URLUtil.splitPath(uRL);
        if (stringArray == null) {
            return uRL;
        }
        String string2 = uRL.toExternalForm();
        string2 = URIComponent.setRawFragment(string2, string);
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static String getUserName(URL uRL) {
        String string = URLUtil.getRawUserName(uRL);
        return string == null ? null : URIComponent.decode(string);
    }

    public static String getRawUserName(URL uRL) {
        String string = uRL.getUserInfo();
        if (string != null) {
            int n = string.indexOf(58);
            if (n < 0) {
                return string;
            }
            if (n > 0) {
                return string.substring(0, n);
            }
            return null;
        }
        return null;
    }

    public static String getUserPassword(URL uRL) {
        String string = URLUtil.getRawUserPassword(uRL);
        return string == null ? null : URIComponent.decode(string);
    }

    public static String getRawUserPassword(URL uRL) {
        String string = uRL.getUserInfo();
        if (string != null) {
            int n = string.indexOf(58);
            if (n + 1 < string.length()) {
                return string.substring(n + 1);
            }
            return null;
        }
        return null;
    }

    public static URL setUserInfo(URL uRL, String string, String string2) {
        if (string != null) {
            string = URIComponent.quoteUserInfo(string);
        }
        if (string2 != null) {
            string2 = URIComponent.quoteUserInfo(string2);
        }
        return URLUtil.setRawUserInfo(uRL, string, string2);
    }

    public static URL setRawUserInfo(URL uRL, String string, String string2) {
        if (string == null) {
            string2 = null;
        }
        String string3 = URIComponent.joinQuotedComponents(uRL.getProtocol(), string, string2, uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
        try {
            return new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public static String getRawRelativePath(URL uRL, URL uRL2) {
        String[] stringArray;
        String[] stringArray2 = URLUtil.splitPath(uRL);
        if (stringArray2 == null || (stringArray = URLUtil.splitPath(uRL2)) == null || !URLUtil.sameRoot(uRL, uRL2)) {
            return uRL.toExternalForm();
        }
        String string = URIComponent.getRawRelativePath(stringArray2[1], stringArray[1]);
        return URIComponent.joinQuotedComponents(null, null, null, null, -1, string, uRL.getQuery(), uRL.getRef());
    }

    public static String toLabel(URL uRL) {
        File file = URLUtil.urlToFile(uRL);
        if (file != null) {
            return file.getPath();
        }
        return URLUtil.toDisplayForm(uRL);
    }

    public static String toDisplayForm(URL uRL) {
        URI uRI;
        URI uRI2 = URLUtil.urlToURI(uRL);
        if (uRI2 == null || uRI2.isOpaque()) {
            return uRL.toExternalForm();
        }
        String string = URLUtil.hideUserInfo(uRI2);
        try {
            uRI = new URI(uRI2.getScheme(), string, uRI2.getHost(), uRI2.getPort(), uRI2.getPath(), uRI2.getQuery(), uRI2.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRL.toExternalForm();
        }
        return uRI.toString();
    }

    private static String hideUserInfo(URI uRI) {
        String string = uRI.getUserInfo();
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (!bl) {
                    stringBuilder.append(c);
                    if (c != ':') continue;
                    bl = true;
                    continue;
                }
                stringBuilder.append('*');
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public static String toShortLabel(URL uRL, int n) {
        File file = URLUtil.urlToFile(uRL);
        if (file != null) {
            String string = file.getPath();
            if (File.separatorChar != '/') {
                string = string.replace(File.separatorChar, '/');
            }
            string = URIComponent.truncatePath(string, n);
            if (File.separatorChar != '/') {
                string = string.replace('/', File.separatorChar);
            }
            return string;
        }
        return URLUtil.toShortDisplayForm(uRL, n);
    }

    public static String toShortDisplayForm(URL uRL, int n) {
        URI uRI;
        URI uRI2 = URLUtil.urlToURI(uRL);
        if (uRI2 == null || uRI2.isOpaque()) {
            return uRL.toExternalForm();
        }
        String string = URLUtil.hideUserInfo(uRI2);
        try {
            uRI = new URI(uRI2.getScheme(), string, uRI2.getHost(), uRI2.getPort(), "/", null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRL.toExternalForm();
        }
        int n2 = 2 * n / 3;
        if (n2 <= 0) {
            n2 = 10;
        }
        n2 = Math.max(n2, n - uRI.toString().length());
        String string2 = URIComponent.truncatePath(uRI2.getPath(), n2);
        try {
            uRI = new URI(uRI2.getScheme(), string, uRI2.getHost(), uRI2.getPort(), string2, uRI2.getQuery(), uRI2.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRL.toExternalForm();
        }
        return uRI.toString();
    }

    public static boolean exists(URL uRL) {
        File file = URLUtil.urlToFile(uRL);
        if (file != null) {
            return file.exists();
        }
        try {
            InputStream inputStream = URLUtil.openStreamNoCache(uRL);
            inputStream.close();
            inputStream = null;
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static long lastModified(URL uRL) {
        File file = URLUtil.urlToFile(uRL);
        if (file != null) {
            return file.lastModified();
        }
        try {
            URLConnection uRLConnection = URLUtil.openConnectionNoCache(uRL);
            uRLConnection.connect();
            long l = uRLConnection.getLastModified();
            uRLConnection = null;
            return l;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytes(URL uRL) throws IOException {
        byte[] byArray = null;
        InputStream inputStream = URLUtil.openStreamNoCache(uRL);
        try {
            byArray = FileUtil.loadBytes(inputStream);
        }
        finally {
            inputStream.close();
        }
        return byArray;
    }

    public static String loadString(URL uRL) throws IOException {
        return URLUtil.loadString(uRL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(URL uRL, String string) throws IOException {
        Object object;
        int n;
        URLConnection uRLConnection = URLUtil.openConnectionNoCache(uRL);
        if (uRLConnection instanceof HttpURLConnection && (n = ((HttpURLConnection)(object = (HttpURLConnection)uRLConnection)).getResponseCode()) != 200) {
            StringBuilder stringBuilder = new StringBuilder("cannot access '");
            stringBuilder.append(uRL);
            stringBuilder.append("': error ");
            stringBuilder.append(n);
            String string2 = ((HttpURLConnection)object).getResponseMessage();
            if (string2 != null) {
                stringBuilder.append(": ");
                stringBuilder.append(string2);
            }
            throw new IOException(stringBuilder.toString());
        }
        if (string == null && (object = uRLConnection.getContentType()) != null) {
            string = URLUtil.contentTypeToCharset((String)object);
        }
        object = null;
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            object = FileUtil.loadString(inputStream, string);
        }
        finally {
            inputStream.close();
        }
        return object;
    }

    public static String contentTypeToCharset(String string) {
        int n;
        int n2;
        String string2 = null;
        if (string != null && (n2 = (string = string.toLowerCase()).indexOf("charset=")) >= 0 && n2 + 8 < string.length() - 1 && (n = (string2 = string.substring(n2 + 8).trim()).length()) >= 2 && string2.charAt(0) == '\"') {
            string2 = string2.substring(1, n - 1);
        }
        return string2;
    }

    public static String contentTypeToMedia(String string) {
        String string2 = null;
        if (string != null) {
            int n = (string = string.toLowerCase()).lastIndexOf(59);
            if (n < 0) {
                string2 = string.trim();
            } else if (n > 0) {
                string2 = string.substring(0, n).trim();
            }
        }
        return string2;
    }

    public static String normalizeContentType(String string, String string2) {
        String string3 = URLUtil.contentTypeToMedia(string);
        if (string3 == null) {
            return null;
        }
        String string4 = URLUtil.contentTypeToCharset(string);
        if (string4 == null && string2 != null) {
            string4 = string2.toLowerCase();
        }
        if (string4 == null) {
            return string3;
        }
        StringBuilder stringBuilder = new StringBuilder(string3);
        stringBuilder.append(";charset=");
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    public static boolean sameContentType(String string, String string2, String string3) {
        string = URLUtil.normalizeContentType(string, string3);
        string2 = URLUtil.normalizeContentType(string2, string3);
        return string == null && string2 == null || string != null && string.equals(string2);
    }

    public static URLConnection openConnectionNoCache(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        return uRLConnection;
    }

    public static InputStream openStreamNoCache(URL uRL) throws IOException {
        URLConnection uRLConnection = URLUtil.openConnectionNoCache(uRL);
        return uRLConnection.getInputStream();
    }
}

