/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class Zip {
    private Zip() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File file, boolean bl, FilenameFilter filenameFilter, File file2) throws IOException {
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        File file3 = file;
        if (bl && (file3 = file.getParentFile()) == null) {
            file3 = file;
        }
        Archive archive = new Archive(new ZipOutputStream(new FileOutputStream(file2)));
        try {
            archive.addAll(file, filenameFilter, file3);
        }
        finally {
            archive.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long computeCRC(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        CRC32 cRC32 = new CRC32();
        byte[] byArray = new byte[65536];
        try {
            int n;
            while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                cRC32.update(byArray, 0, n);
            }
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return cRC32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File file, File file2) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
        try {
            Zip.unzip(zipInputStream, file2);
        }
        finally {
            zipInputStream.close();
        }
    }

    public static void unzip(ZipInputStream zipInputStream, File file) throws IOException {
        ZipEntry zipEntry;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            File file2 = new File(Zip.fromZipEntryName(file, zipEntry.getName()));
            if (zipEntry.isDirectory()) {
                if (!file2.isDirectory()) {
                    FileUtil.checkedMkdirs(file2);
                }
            } else {
                File file3 = file2.getParentFile();
                if (!file3.isDirectory()) {
                    FileUtil.checkedMkdirs(file3);
                }
                FileUtil.copyFile((InputStream)zipInputStream, file2);
            }
            zipInputStream.closeEntry();
        }
    }

    private static String fromZipEntryName(File file, String string) {
        int n = string.length();
        if (n > 1 && string.endsWith("/")) {
            string = string.substring(0, n - 1);
        }
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        return file.getPath() + File.separatorChar + string;
    }

    public static final class Archive {
        private ZipOutputStream zip;
        private HashSet<String> zipDirs;

        public Archive(ZipOutputStream zipOutputStream) {
            this.zip = zipOutputStream;
            this.zipDirs = new HashSet();
            if (zipOutputStream instanceof JarOutputStream) {
                this.zipDirs.add("META-INF/");
            }
        }

        public ZipOutputStream getZipOutputStream() {
            return this.zip;
        }

        public void add(File file, File file2) throws IOException, IllegalArgumentException {
            this.add(file, file2, false);
        }

        public void add(File file, File file2, boolean bl) throws IOException, IllegalArgumentException {
            String string;
            String string2 = file2.getPath();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separatorChar;
            }
            if (!(string = file.getPath()).startsWith(string2)) {
                throw new IllegalArgumentException("'" + file2 + "' is not an ancestor directory of '" + file + "'");
            }
            String string3 = string.substring(string2.length());
            if (File.separatorChar != '/') {
                string3 = string3.replace(File.separatorChar, '/');
            }
            if (file.isDirectory()) {
                if (!string3.endsWith("/")) {
                    string3 = string3 + '/';
                }
                this.createZipDirs(string3);
            } else {
                this.createZipDirs(string3);
                ZipEntry zipEntry = new ZipEntry(string3);
                if (bl) {
                    zipEntry.setMethod(0);
                    zipEntry.setSize(file.length());
                    zipEntry.setCrc(Zip.computeCRC(file));
                }
                this.zip.putNextEntry(zipEntry);
                FileUtil.copyFile(file, (OutputStream)this.zip);
                this.zip.closeEntry();
            }
        }

        private void createZipDirs(String string) throws IOException {
            if ((string = Archive.parentPath(string)) == null || string.length() == 0) {
                return;
            }
            if (this.zipDirs.contains(string)) {
                return;
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            String[] stringArray = StringUtil.split(string, '/');
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                stringBuilder.append(string2);
                stringBuilder.append('/');
                String string3 = stringBuilder.toString();
                if (this.zipDirs.contains(string3)) continue;
                ZipEntry zipEntry = new ZipEntry(string3);
                this.zip.putNextEntry(zipEntry);
                this.zip.closeEntry();
                this.zipDirs.add(string3);
            }
        }

        private static String parentPath(String string) {
            int n = string.lastIndexOf(47);
            if (n < 0) {
                return null;
            }
            if (n + 1 < string.length()) {
                string = string.substring(0, n + 1);
            }
            return string;
        }

        public void finish() throws IOException {
            this.zip.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.zip.finish();
            }
            finally {
                this.zip.close();
            }
        }

        public void addAll(File file, FilenameFilter filenameFilter, File file2) throws IOException {
            File[] fileArray = FileUtil.checkedListFiles(file, filenameFilter);
            for (int i = 0; i < fileArray.length; ++i) {
                File file3 = fileArray[i];
                this.add(file3, file2);
                if (!file3.isDirectory()) continue;
                this.addAll(file3, filenameFilter, file2);
            }
        }
    }
}

