var plasma = getApiVersion(1);

var screenWidthGridUnits = screenGeometry(0).width / gridUnit;
var screenHeightGridUnits = screenGeometry(0).height / gridUnit;

var layout = {
    "desktops": [
        {
            "applets": [
                {
                    "config": {
                        "/": {
                            "formfactor": "0",
                            "immutability": "1",
                            "lastScreen": "-1",
                            "wallpaperplugin": ""
                        },
                        "/ConfigDialog": {
                            "DialogHeight": "541",
                            "DialogWidth": "720"
                        },
                        "/General": {
                            "iconSize": "3",
                            "url": "file://" + userDataPath("")
                        }
                    },
                    "geometry.height": screenHeightGridUnits * 0.5,
                    "geometry.width": screenWidthGridUnits * 0.4,
                    "geometry.x": 2,
                    "geometry.y": 3,
                    "plugin": "org.kde.plasma.folder",
                    "title": "Home"
                },
                {
                    "config": {
                        "/ConfigDialog": {
                            "DialogHeight": "540",
                            "DialogWidth": "720"
                        },
                        "/General": {
                            "places": "[{\"placeAlias\":\"Bonn\",\"placeIdentifier\":\"Germany/North_Rhine-Westphalia/Bonn\",\"providerId\":\"yrno\"}]",
                            "reloadIntervalMin": "20"
                        }
                    },
                    "geometry.height": 3,
                    "geometry.width": screenHeightGridUnits * 0.17,
                    "geometry.x": 2,
                    "geometry.y": screenHeightGridUnits * 0.7,
                    "plugin": "org.kde.weatherWidget",
                    "title": "Weather Widget"
                },
                {
                    "config": {
                        "/ConfigDialog": {
                            "DialogHeight": "540",
                            "DialogWidth": "720"
                        },
                        "/General": {
                            "sources": "partitions%2F%2Ffilllevel"
                        }
                    },
                    "geometry.height": 2,
                    "geometry.width": screenWidthGridUnits * 0.25,
                    "geometry.x": screenWidthGridUnits * 0.75,
                    "geometry.y": screenHeightGridUnits * 0.675,
                    "plugin": "org.kde.plasma.systemmonitor.diskusage",
                    "title": "Hard Disk Space Usage"
                }
            ],
            "config": {
                "/": {
                    "formfactor": "0",
                    "immutability": "1",
                    "lastScreen": "0",
                    "wallpaperplugin": "org.kde.image"
                },
                "/ConfigDialog": {
                    "DialogHeight": "546",
                    "DialogWidth": "720"
                },
                "/Wallpaper/org.kde.image/General": {
                    "Image": ""
                }
            },
            "wallpaperPlugin": "org.kde.image"
        },
        {
            "applets": [
            ],
            "config": {
                "/": {
                    "formfactor": "0",
                    "immutability": "1",
                    "lastScreen": "1",
                    "wallpaperplugin": "org.kde.image"
                },
                "/Wallpaper/org.kde.image/General": {
                    "height": "576",
                    "width": "720"
                }
            },
            "wallpaperPlugin": "org.kde.image"
        }
    ],
    "panels": [
        {
            "applets": [
                {
                    "config": {
                        "/": {
                            "immutability": "1"
                        },
                        "/Configuration/General": {
                            "expanding": "false",
                            "length": "8"
                        }
                    },
                    "plugin": "org.kde.plasma.panelspacer"
                },
                {
                    "config": {
                        "/": {
                            "immutability": "1"
                        }
                    },
                    "plugin": "org.kde.plasma.kicker"
                },
                {
                    "config": {
                        "/": {
                            "immutability": "1"
                        },
                        "/Configuration/General": {
                            "expanding": "false",
                            "length": "8"
                        }
                    },
                    "plugin": "org.kde.plasma.panelspacer"
                },
                {
                    "config": {
                        "/": {
                            "immutability": "1"
                        }
                    },
                    "plugin": "org.kde.plasma.digitalclock"
                },
                {
                    "config": {
                        "/": {
                            "immutability": "1"
                        },
                        "/Configuration/General": {
                            "expanding": "false",
                            "length": "6"
                        }
                    },
                    "plugin": "org.kde.plasma.panelspacer"
                },
                {
                    "config": {
                        "/": {
                            "immutability": "1"
                        }
                    },
                    "plugin": "org.kde.plasma.calculator"
                },
                {
                    "config": {
                        "/": {
                            "immutability": "1"
                        },
                        "/Configuration/General": {
                            "expanding": "false",
                            "length": "17"
                        }
                    },
                    "plugin": "org.kde.plasma.panelspacer"
                },
                {
                    "config": {
                        "/": {
                            "immutability": "1"
                        },
                        "/Configuration/ConfigDialog": {
                            "DialogHeight": "540",
                            "DialogWidth": "720"
                        },
                        "/Configuration/General": {
                            "monitorType": 2
                        }
                    },
                    "plugin": "org.kde.plasma.systemloadviewer"
                },
                {
                    "config": {
                        "/": {
                            "immutability": "1"
                        },
                        "/Configuration/General": {
                            "length": "17"
                        }
                    },
                    "plugin": "org.kde.plasma.panelspacer"
                },
                {
                    "config": {
                        "/": {
                            "immutability": "1"
                        },
                        "/Configuration/Containments/19": {
                            "formfactor": "2"
                        },
                        "/Configuration/General": {
                            "extraItems": "org.kde.plasma.battery,org.kde.plasma.bluetooth,org.kde.plasma.clipboard,org.kde.plasma.devicenotifier,org.kde.plasma.mediacontroller,org.kde.plasma.networkmanagement,org.kde.plasma.notifications,org.kde.plasma.volume,org.kde.ktp-contactlist,org.kde.plasma.printmanager",
                            "knownItems": "org.kde.plasma.battery,org.kde.plasma.bluetooth,org.kde.plasma.clipboard,org.kde.plasma.devicenotifier,org.kde.plasma.mediacontroller,org.kde.plasma.networkmanagement,org.kde.plasma.notifications,org.kde.plasma.volume,org.kde.ktp-contactlist,org.kde.plasma.printmanager"
                        }
                    },
                    "plugin": "org.kde.plasma.systemtray"
                }
            ],
            "config": {
                "/": {
                    "formfactor": "2",
                    "immutability": "1",
                    "lastScreen": "0",
                    "wallpaperplugin": "org.kde.image"
                },
                "/ConfigDialog": {
                    "DialogHeight": "84",
                    "DialogWidth": "640"
                }
            },
            "height": 28 / gridUnit,
            "length": screenWidthGridUnits / 2,
            "location": "top",
            "alignment": "center"
        }
    ],
    "serializationFormatVersion": "1"
}
;

layout.panels[0].minimumLength = layout.panels[0].length
layout.panels[0].maximumLength = layout.panels[0].length + (layout.panels[0].length / 2)

plasma.loadSerializedLayout(layout);

var panel = panelById(panelIds[0]);
panel.hiding = "autohide"

locked = "true"

