/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.net.ssl.SSLSocket;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPLoopback;
import org.jacorb.orb.iiop.IIOPLoopbackInputStream;
import org.jacorb.orb.iiop.IIOPLoopbackOutputStream;
import org.jacorb.orb.iiop.IIOPLoopbackRegistry;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.listener.TCPConnectionEvent;
import org.jacorb.orb.listener.TCPConnectionListener;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.Profile;

public class ClientIIOPConnection
extends IIOPConnection
implements Configurable {
    private int timeout = 0;
    private int ssl_port = -1;
    private int noOfRetries = 5;
    private int retryInterval = 0;
    private boolean doSupportSSL = false;
    private int client_required = -1;
    private int client_supported = -1;
    private TransportManager transportManager;
    private TCPConnectionListener connectionListener;
    private boolean keepAlive;
    public static int openTransports = 0;

    public ClientIIOPConnection() {
        this.use_ssl = false;
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.timeout = configuration.getAttributeAsInteger("jacorb.connection.client.idle_timeout", 0);
        this.noOfRetries = configuration.getAttributeAsInteger("jacorb.retries", 5);
        this.retryInterval = configuration.getAttributeAsInteger("jacorb.retry_interval", 500);
        this.doSupportSSL = configuration.getAttributeAsBoolean("jacorb.security.support_ssl", false);
        this.transportManager = this.configuration.getORB().getTransportManager();
        this.client_required = configuration.getAttributeAsInteger("jacorb.security.ssl.client.required_options", 16, 16);
        this.client_supported = configuration.getAttributeAsInteger("jacorb.security.ssl.client.supported_options", 16, 16);
        this.keepAlive = configuration.getAttributeAsBoolean("jacorb.connection.client.keepalive", false);
        this.connectionListener = this.transportManager.getSocketFactoryManager().getTCPListener();
    }

    public synchronized void connect(Profile server_profile, long time_out) {
        if (!this.connected) {
            if (!(server_profile instanceof IIOPProfile)) {
                throw new BAD_PARAM("attempt to connect an IIOP connection to a non-IIOP profile: " + server_profile.getClass());
            }
            this.profile = (IIOPProfile)server_profile;
            IIOPLoopback loopback = this.getLocalLoopback();
            if (loopback != null) {
                String connectionDetails;
                IIOPLoopbackInputStream lis = new IIOPLoopbackInputStream();
                IIOPLoopbackOutputStream los = new IIOPLoopbackOutputStream();
                this.connection_info = connectionDetails = this.profile + " using loopback connection";
                loopback.initLoopback(connectionDetails, lis, los);
                this.in_stream = lis;
                this.out_stream = los;
                this.connected = true;
                ++openTransports;
                return;
            }
            this.checkSSL();
            int retries = this.noOfRetries;
            while (retries >= 0) {
                try {
                    this.createSocket(time_out);
                    this.socket.setTcpNoDelay(true);
                    if (this.timeout != 0) {
                        this.socket.setSoTimeout(this.timeout);
                    }
                    this.socket.setKeepAlive(this.keepAlive);
                    this.in_stream = this.socket.getInputStream();
                    this.out_stream = new BufferedOutputStream(this.socket.getOutputStream());
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Connected to " + this.connection_info + " from local port " + this.socket.getLocalPort() + (this.isSSL() ? " via SSL" : "") + (this.timeout == 0 ? "" : " Timeout: " + this.timeout));
                    }
                    this.connected = true;
                    ++openTransports;
                    return;
                }
                catch (IOException c) {
                    if (--retries < 0) continue;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Retrying to connect to " + this.connection_info);
                    }
                    try {
                        Thread.sleep(this.retryInterval);
                    }
                    catch (InterruptedException i) {}
                }
                catch (TIMEOUT e) {
                    this.profile = null;
                    this.use_ssl = false;
                    this.ssl_port = -1;
                    throw e;
                }
            }
            if (retries < 0) {
                this.profile = null;
                this.use_ssl = false;
                this.ssl_port = -1;
                throw new TRANSIENT("Retries exceeded, couldn't reconnect to " + this.connection_info);
            }
        }
    }

    private IIOPLoopback getLocalLoopback() {
        IIOPProfile iiopProfile = (IIOPProfile)this.profile;
        ArrayList<ProtocolAddressBase> addressList = new ArrayList<ProtocolAddressBase>();
        addressList.add(iiopProfile.getAddress());
        addressList.addAll(iiopProfile.getAlternateAddresses());
        Iterator addressIterator = addressList.iterator();
        IIOPLoopbackRegistry registry = IIOPLoopbackRegistry.getRegistry();
        while (addressIterator.hasNext()) {
            IIOPLoopback loopback;
            IIOPAddress address = (IIOPAddress)((IIOPAddress)addressIterator.next()).copy();
            if (iiopProfile.getSSL() != null) {
                address.setPort(iiopProfile.getSSLPort());
            }
            if ((loopback = registry.getLoopback(address)) == null) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("connect to " + address + " using IIOPLoopback");
            }
            return loopback;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSocket(long time_out) throws IOException {
        ArrayList<ProtocolAddressBase> addressList = new ArrayList<ProtocolAddressBase>();
        addressList.add(((IIOPProfile)this.profile).getAddress());
        addressList.addAll(((IIOPProfile)this.profile).getAlternateAddresses());
        Iterator addressIterator = addressList.iterator();
        Exception exception = null;
        this.socket = null;
        while (this.socket == null && addressIterator.hasNext()) {
            try {
                IIOPAddress address = (IIOPAddress)addressIterator.next();
                SocketFactory factory = this.use_ssl ? this.getSSLSocketFactory() : this.getSocketFactory();
                String ipAddress = address.getIP();
                int port = this.use_ssl ? this.ssl_port : address.getPort();
                this.connection_info = ipAddress.indexOf(58) == -1 ? ipAddress + ":" + port : "[" + ipAddress + "]:" + port;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying to connect to " + this.connection_info + " with timeout=" + time_out + (this.use_ssl ? " using SSL." : "."));
                }
                exception = null;
                if (time_out > 0L) {
                    int truncatedTimeout = (int)time_out;
                    if ((long)truncatedTimeout != time_out) {
                        this.logger.warn("timeout might be changed due to conversion from long to int. old value: " + time_out + " new value: " + truncatedTimeout);
                    }
                    this.socket = factory.createSocket(ipAddress, port, truncatedTimeout);
                    continue;
                }
                this.socket = factory.createSocket(ipAddress, port);
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ClientIIOPConnection.createSocket to " + this.connection_info + " caught " + e);
                }
                exception = e;
            }
            finally {
                if (this.socket == null || !this.connectionListener.isListenerEnabled()) continue;
                this.connectionListener.connectionOpened(new TCPConnectionEvent(this, this.socket.getInetAddress().toString(), this.socket.getPort(), this.socket.getLocalPort(), this.getLocalhost()));
            }
        }
        if (exception != null) {
            if (exception instanceof SocketTimeoutException) {
                throw new TIMEOUT("connection timeout of " + time_out + " milliseconds expired: " + exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException("Unexpected exception occured: " + exception.toString());
        }
    }

    public synchronized void close() {
        if (!this.connected) {
            return;
        }
        try {
            if (this.socket != null && !(this.socket instanceof SSLSocket) && !this.socket.isClosed()) {
                this.socket.shutdownOutput();
            }
        }
        catch (IOException ex) {
            this.logger.error("Exception when shutting down output", (Throwable)ex);
        }
        this.silentClose(this.socket);
        this.silentClose(this.in_stream);
        this.silentClose(this.out_stream);
        --openTransports;
        this.connected = false;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Client-side TCP transport to " + this.connection_info + " closed.");
        }
        if (this.socket != null && this.connectionListener.isListenerEnabled()) {
            this.connectionListener.connectionClosed(new TCPConnectionEvent(this, this.socket.getInetAddress().toString(), this.socket.getPort(), this.socket.getLocalPort(), this.getLocalhost()));
        }
    }

    protected void checkSSL() {
        if (!this.doSupportSSL) {
            return;
        }
        this.ssl_port = ((IIOPProfile)this.profile).getSslPortIfSupported(this.client_required, this.client_supported);
        this.use_ssl = this.ssl_port != -1;
    }

    public int getSsl_port() {
        return this.ssl_port;
    }

    private SocketFactory getSocketFactory() {
        return this.transportManager.getSocketFactoryManager().getSocketFactory();
    }

    private SocketFactory getSSLSocketFactory() {
        return this.transportManager.getSocketFactoryManager().getSSLSocketFactory();
    }
}

