/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.concurrency;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.concurrency.LockCoordinatorImpl;
import org.jacorb.concurrency.LockSetFactoryImpl;
import org.jacorb.concurrency.TransactionalLockSetImpl;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosConcurrencyControl.LockCoordinator;
import org.omg.CosConcurrencyControl.LockCoordinatorHelper;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.ResourcePOA;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Vote;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.Servant;

class TransactionCoordinator
extends ResourcePOA {
    static final int ACTIVE = 0;
    static final int COMMITED = 1;
    static final int PREPARED = 2;
    static final int ROLLEDBACK = 3;
    private Coordinator current;
    private POA poa;
    private Hashtable locksets = new Hashtable();
    private int state;
    private LockSetFactoryImpl factory;

    TransactionCoordinator(LockSetFactoryImpl factory, Coordinator current, POA poa) {
        this.current = current;
        this.poa = poa;
        this.factory = factory;
        Status status = current.get_status();
        if (status.equals(Status.StatusActive)) {
            this.state = 0;
        } else if (status.equals(Status.StatusPrepared) || status.equals(Status.StatusPreparing)) {
            this.state = 2;
        } else if (status.equals(Status.StatusCommitted) || status.equals(Status.StatusUnknown) || status.equals(Status.StatusNoTransaction) || status.equals(Status.StatusCommitting)) {
            this.state = 1;
        } else if (status.equals(Status.StatusRollingBack) || status.equals(Status.StatusMarkedRollback) || status.equals(Status.StatusRolledBack)) {
            this.state = 3;
        }
    }

    Coordinator get_coordinator() {
        return this.current;
    }

    synchronized Status get_state() {
        switch (this.state) {
            case 0: {
                return Status.StatusActive;
            }
            case 1: {
                return Status.StatusCommitted;
            }
            case 2: {
                return Status.StatusPrepared;
            }
            case 3: {
                return Status.StatusRolledBack;
            }
        }
        return Status.StatusNoTransaction;
    }

    @Override
    public synchronized Vote prepare() throws HeuristicMixed, HeuristicHazard {
        if (this.state == 0) {
            this.state = 2;
            return Vote.VoteCommit;
        }
        return Vote.VoteRollback;
    }

    @Override
    public synchronized void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard {
        if (this.state == 0) {
            this.state = 3;
            this.run();
        }
    }

    @Override
    public synchronized void commit() throws NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard {
        if (this.state != 2) {
            throw new NotPrepared();
        }
        this.state = 1;
        this.run();
    }

    @Override
    public synchronized void commit_one_phase() throws HeuristicHazard {
        if (this.state == 0) {
            this.state = 1;
            this.run();
        }
    }

    @Override
    public synchronized void forget() {
        throw new NO_IMPLEMENT();
    }

    synchronized LockCoordinator get_lock_coordinator(TransactionalLockSetImpl ls) {
        LockCoordinatorImpl lc = (LockCoordinatorImpl)this.locksets.get(ls);
        if (lc == null) {
            lc = new LockCoordinatorImpl(this, ls);
            this.locksets.put(ls, lc);
        }
        try {
            return LockCoordinatorHelper.narrow(this.poa.servant_to_reference((Servant)lc));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new INTERNAL();
        }
    }

    synchronized void set_lock_coordinator(TransactionalLockSetImpl ls) {
        this.check_state();
        LockCoordinatorImpl lc = (LockCoordinatorImpl)this.locksets.get(ls);
        if (lc == null) {
            lc = new LockCoordinatorImpl(this, ls);
            this.locksets.put(ls, lc);
        }
    }

    synchronized void remove_coordinator(TransactionalLockSetImpl ls) {
        LockCoordinatorImpl lc = (LockCoordinatorImpl)this.locksets.get(ls);
        if (lc != null) {
            try {
                byte[] ObjId = this.poa.servant_to_id((Servant)lc);
                this.poa.deactivate_object(ObjId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.locksets.remove(ls);
        }
    }

    public void run() {
        Enumeration enumeration = this.locksets.elements();
        while (enumeration.hasMoreElements()) {
            LockCoordinatorImpl lc = (LockCoordinatorImpl)enumeration.nextElement();
            lc.drop_locks();
            try {
                byte[] ObjId = this.poa.servant_to_id((Servant)lc);
                this.poa.deactivate_object(ObjId);
            }
            catch (ServantNotActive e) {
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                throw new INTERNAL();
            }
        }
        this.factory.remove_me(this);
    }

    private void check_state() {
        if (this.state == 2 || this.state == 1) {
            throw new INVALID_TRANSACTION();
        }
        if (this.state == 3) {
            throw new TRANSACTION_ROLLEDBACK();
        }
    }
}

