/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.engine.RetryStrategy;
import org.jacorb.notification.interfaces.IProxyPushSupplier;
import org.jacorb.notification.util.LogUtil;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CosEventComm.Disconnected;
import org.slf4j.Logger;

public abstract class AbstractRetryStrategy
implements RetryStrategy {
    protected final Logger logger_ = LogUtil.getLogger(this.getClass().getName());
    protected final PushOperation pushOperation_;
    protected final IProxyPushSupplier pushSupplier_;
    private boolean active_ = true;

    public AbstractRetryStrategy(IProxyPushSupplier pushSupplier, PushOperation operation) {
        this.pushSupplier_ = pushSupplier;
        this.pushOperation_ = operation;
    }

    public void dispose() {
        this.pushOperation_.dispose();
    }

    protected boolean isRetryAllowed() {
        return this.active_ && this.pushSupplier_.isRetryAllowed();
    }

    protected void remoteExceptionOccured(Exception error) throws RetryException {
        this.logger_.debug("Error during retry", (Throwable)error);
        if (AbstractRetryStrategy.isFatalException(error)) {
            if (!this.pushSupplier_.isDestroyed()) {
                this.pushSupplier_.destroy();
            }
            this.active_ = false;
            throw new RetryException("fatal exception while retrying push");
        }
        this.pushSupplier_.incErrorCounter();
        if (!this.isRetryAllowed()) {
            if (!this.pushSupplier_.isDestroyed()) {
                this.pushSupplier_.destroy();
            }
            this.active_ = false;
            throw new RetryException("no more retries. giving up.");
        }
        this.waitUntilNextTry();
    }

    public static boolean isFatalException(Exception error) {
        if (error instanceof OBJECT_NOT_EXIST) {
            return true;
        }
        return error instanceof Disconnected;
    }

    protected abstract long getTimeToWait();

    @Override
    public final void retry() throws RetryException {
        if (this.isRetryAllowed()) {
            this.waitUntilNextTry();
            this.retryInternal();
        } else {
            this.dispose();
        }
    }

    protected abstract void retryInternal() throws RetryException;

    private void waitUntilNextTry() {
        long timeToWait = this.getTimeToWait();
        try {
            if (timeToWait > 0L) {
                Thread.sleep(timeToWait);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

