/*
 * Decompiled with CFR 0.152.
 */
package registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import registry.LanguagePackItem;

public class LanguagePackParser {
    private static HashMap<String, String> REGION_VARIANT_MAP = new HashMap<String, String>(){
        {
            this.put("XV", "valencia");
        }
    };
    private static HashMap<String, LanguagePackItem> langPacks = new HashMap();

    public static ArrayList<LanguagePackItem> parse(String pkgPrefix, ArrayList<String> strArray) {
        for (String pkg : strArray) {
            LanguagePackItem lpi;
            String pkgRegion;
            String tmpRegion;
            String localeString = pkg.replaceFirst(pkgPrefix + "-", "");
            StringTokenizer strTokenizer = new StringTokenizer(localeString, "-_");
            String tmpLang = strTokenizer.nextToken().trim();
            try {
                tmpRegion = strTokenizer.nextToken().trim();
            }
            catch (Exception e) {
                tmpRegion = "";
            }
            String pkgName = pkg;
            Locale tmpLocale = LanguagePackParser.getLocale(tmpLang, tmpRegion);
            String pkgLanguage = tmpLocale.getDisplayLanguage();
            if (pkgLanguage.equals(tmpLang)) {
                pkgLanguage = "Miscellaneous";
            }
            if ((pkgRegion = tmpLocale.getDisplayCountry()).isEmpty() && !tmpLocale.getDisplayVariant().isEmpty()) {
                pkgRegion = tmpLocale.getDisplayVariant();
                StringBuilder strBuilder = new StringBuilder(pkgRegion);
                strBuilder.replace(0, 1, pkgRegion.substring(0, 1).toUpperCase());
                pkgRegion = strBuilder.toString();
            }
            if ((lpi = langPacks.get(pkgLanguage)) == null) {
                lpi = new LanguagePackItem(pkgLanguage);
            }
            lpi.addPackage(pkgRegion, pkgName);
            langPacks.put(pkgLanguage, lpi);
        }
        return new ArrayList<LanguagePackItem>(langPacks.values());
    }

    static Locale getLocale(String lang, String region) {
        Locale returnLocale;
        block7: {
            returnLocale = new Locale("");
            try {
                String modifier = "";
                String tmpRegionToVariant = REGION_VARIANT_MAP.get(region);
                if (tmpRegionToVariant != null) {
                    modifier = tmpRegionToVariant;
                    region = "";
                }
                if (lang.contains("@")) {
                    StringTokenizer strTokenizer = new StringTokenizer(lang, "@");
                    lang = strTokenizer.nextToken().trim();
                    modifier = strTokenizer.nextToken().trim();
                }
                boolean modifierIsVariant = false;
                if (!modifier.isEmpty()) {
                    try {
                        new Locale.Builder().setLanguage(lang).setScript(modifier).setRegion(region).build();
                    }
                    catch (Exception e) {
                        modifierIsVariant = true;
                    }
                    returnLocale = modifierIsVariant ? new Locale.Builder().setLanguage(lang).setVariant(modifier).setRegion(region).build() : new Locale.Builder().setLanguage(lang).setScript(modifier).setRegion(region).build();
                    break block7;
                }
                returnLocale = new Locale.Builder().setLanguage(lang).setRegion(region).build();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return returnLocale;
    }
}

