/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.util.ArrayList;
import org.apache.batik.apps.svgbrowser.AbstractUndoableCommand;
import org.apache.batik.apps.svgbrowser.UndoableCommand;

public abstract class AbstractCompoundCommand
extends AbstractUndoableCommand {
    protected ArrayList atomCommands = new ArrayList();

    public void addCommand(UndoableCommand command) {
        if (command.shouldExecute()) {
            this.atomCommands.add(command);
        }
    }

    public void execute() {
        int n = this.atomCommands.size();
        int i = 0;
        while (i < n) {
            UndoableCommand cmd = (UndoableCommand)this.atomCommands.get(i);
            cmd.execute();
            ++i;
        }
    }

    public void undo() {
        int size = this.atomCommands.size();
        int i = size - 1;
        while (i >= 0) {
            UndoableCommand command = (UndoableCommand)this.atomCommands.get(i);
            command.undo();
            --i;
        }
    }

    public void redo() {
        int n = this.atomCommands.size();
        int i = 0;
        while (i < n) {
            UndoableCommand cmd = (UndoableCommand)this.atomCommands.get(i);
            cmd.redo();
            ++i;
        }
    }

    public boolean shouldExecute() {
        boolean shouldExecute = true;
        if (this.atomCommands.size() == 0) {
            shouldExecute = false;
        }
        int n = this.atomCommands.size();
        int i = 0;
        while (i < n && shouldExecute) {
            UndoableCommand command = (UndoableCommand)this.atomCommands.get(i);
            shouldExecute = command.shouldExecute() && shouldExecute;
            ++i;
        }
        return shouldExecute;
    }

    public int getCommandNumber() {
        return this.atomCommands.size();
    }
}

