/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.proj.Projection;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BufferedMapBean
extends MapBean {
    private static Logger logger = Logger.getLogger(BufferedMapBean.class.getName());
    protected boolean bufferDirty = true;
    protected BufferedImage drawingBuffer = null;
    protected PanHelper panningTransform = null;

    public BufferedMapBean() {
    }

    public BufferedMapBean(boolean useThreadedNotification) {
        super(useThreadedNotification);
    }

    public void componentResized(ComponentEvent e) {
        this.setBufferDirty(true);
        super.componentResized(e);
    }

    protected BufferedImage resetDrawingBuffer(BufferedImage currentImageBuffer, Projection proj) {
        try {
            int w = proj.getWidth();
            int h = proj.getHeight();
            if (currentImageBuffer != null) {
                int cibWidth = currentImageBuffer.getWidth();
                int cibHeight = currentImageBuffer.getHeight();
                if (cibWidth == w && cibHeight == h) {
                    Graphics2D graphics = (Graphics2D)currentImageBuffer.getGraphics();
                    graphics.setComposite(AlphaComposite.Clear);
                    graphics.fillRect(0, 0, w, h);
                    graphics.setComposite(AlphaComposite.SrcOver);
                    return currentImageBuffer;
                }
                currentImageBuffer.flush();
            }
            return new BufferedImage(w, h, 2);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new BufferedImage(1, 1, 2);
    }

    public void paintChildren(Graphics g, Rectangle clip) {
        BufferedImage localDrawingBuffer = this.drawingBuffer;
        if (this.panningTransform == null && this.bufferDirty) {
            this.bufferDirty = false;
            this.drawingBuffer = localDrawingBuffer = this.resetDrawingBuffer(localDrawingBuffer, this.getProjection());
            Graphics gr = this.getMapBeanRepaintPolicy().modifyGraphicsForPainting(localDrawingBuffer.getGraphics());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("BufferedMapBean rendering layers to buffer.");
            }
            super.paintChildren(gr, null);
            gr.dispose();
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("BufferedMapBean rendering buffer.");
        }
        if (this.panningTransform != null) {
            this.panningTransform.render((Graphics2D)g);
            return;
        }
        if (localDrawingBuffer != null) {
            MapBean.RotationHelper rotHelper = this.getRotHelper();
            if (rotHelper != null) {
                rotHelper.paintChildren(g, clip);
                rotHelper.paintPainters(g);
            } else {
                this.drawProjectionBackground(g);
                g.drawImage(localDrawingBuffer, 0, 0, null);
                this.painters.paint(g);
            }
        }
    }

    public boolean isBuffered() {
        return true;
    }

    public void setBufferDirty(boolean value) {
        this.bufferDirty = value;
    }

    public boolean isBufferDirty() {
        return this.bufferDirty;
    }

    protected void disposeDrawingBuffer() {
        BufferedImage localDrawingBuffer = this.drawingBuffer;
        this.drawingBuffer = null;
        if (localDrawingBuffer != null) {
            localDrawingBuffer.flush();
        }
    }

    public void dispose() {
        this.disposeDrawingBuffer();
        super.dispose();
    }

    public AffineTransform getPanningTransform() {
        return this.panningTransform;
    }

    public void setPanningTransform(AffineTransform transform) {
        if (transform != null) {
            if (this.panningTransform == null) {
                this.panningTransform = new PanHelper(transform);
                this.setBufferDirty(true);
            } else {
                this.panningTransform.update(transform);
            }
        } else {
            if (this.panningTransform != null) {
                this.panningTransform.dispose();
            }
            this.panningTransform = null;
        }
    }

    protected class PanHelper
    extends AffineTransform {
        protected Image buffer;

        protected PanHelper(AffineTransform aft) {
            super(aft);
            this.buffer = new BufferedImage(BufferedMapBean.this.getWidth(), BufferedMapBean.this.getHeight(), 2);
            BufferedMapBean.this.paintChildren(this.buffer.getGraphics(), null);
        }

        protected void update(AffineTransform aft) {
            super.setTransform(aft);
        }

        protected void render(Graphics2D g) {
            MapBean.RotationHelper rotationHelper;
            BufferedMapBean.this.drawProjectionBackground(g);
            g.setTransform(this);
            if (this.buffer != null) {
                g.drawImage(this.buffer, 0, 0, null);
            }
            if ((rotationHelper = BufferedMapBean.this.getRotHelper()) == null) {
                BufferedMapBean.this.painters.paint(g);
            }
        }

        protected void dispose() {
            if (this.buffer != null) {
                this.buffer.flush();
                this.buffer = null;
            }
        }
    }
}

