/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.app;

import com.bbn.openmap.Environment;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.gui.BasicMapPanel;
import com.bbn.openmap.gui.MapPanel;
import com.bbn.openmap.gui.OpenMapFrame;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class OpenMap {
    protected MapPanel mapPanel;

    public OpenMap() {
        this(null);
    }

    public OpenMap(PropertyHandler propertyHandler) {
        this.configureMapPanel(propertyHandler);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OpenMap.this.showInFrame();
            }
        });
    }

    protected void configureMapPanel(PropertyHandler propertyHandler) {
        BasicMapPanel basicMapPanel = new BasicMapPanel(propertyHandler, true);
        basicMapPanel.create();
        this.mapPanel = basicMapPanel;
    }

    protected void showInFrame() {
        MapHandler mapHandler = this.getMapHandler();
        OpenMapFrame omf = mapHandler.get(OpenMapFrame.class);
        if (omf == null) {
            omf = new OpenMapFrame(Environment.get("openmap.Title"));
            PropertyHandler propertyHandler = mapHandler.get(PropertyHandler.class);
            if (propertyHandler != null) {
                omf.setProperties("openmap", propertyHandler.getProperties());
            }
            this.getMapHandler().add(omf);
        }
        this.setWindowListenerOnFrame(omf);
        omf.setVisible(true);
        this.mapPanel.getMapBean().showLayerPalettes();
        OpenMap.getLogger().fine("OpenMap: READY");
    }

    protected void setWindowListenerOnFrame(OpenMapFrame omf) {
        omf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public MapHandler getMapHandler() {
        return this.mapPanel.getMapHandler();
    }

    public MapPanel getMapPanel() {
        return this.mapPanel;
    }

    public static OpenMap create() {
        return new OpenMap(null);
    }

    public static OpenMap create(String propertiesFile) {
        Debug.init();
        return new OpenMap(OpenMap.configurePropertyHandler(propertiesFile));
    }

    public static PropertyHandler configurePropertyHandler(String propertiesFile) {
        try {
            return new PropertyHandler.Builder().setPropertiesFile(propertiesFile).build();
        }
        catch (MalformedURLException murle) {
            OpenMap.getLogger().log(Level.WARNING, murle.getMessage(), murle);
        }
        catch (IOException ioe) {
            OpenMap.getLogger().log(Level.WARNING, ioe.getMessage(), ioe);
        }
        return new PropertyHandler();
    }

    public static void main(String[] args) {
        ArgParser ap = new ArgParser("OpenMap");
        String propArgs = null;
        ap.add("properties", "A resource, file path or URL to properties file\n Ex: http://myhost.com/xyz.props or file:/myhome/abc.pro\n See Java Documentation for java.net.URL class for more details", 1);
        ap.parse(args);
        String[] arg = ap.getArgValues("properties");
        if (arg != null) {
            propArgs = arg[0];
        }
        OpenMap.create(propArgs);
    }

    protected static Logger getLogger() {
        return LoggerHolder.LOGGER;
    }

    private static final class LoggerHolder {
        private static final Logger LOGGER = Logger.getLogger(OpenMap.class.getName());

        private LoggerHolder() {
            throw new AssertionError((Object)"This should never be instantiated");
        }
    }
}

