/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.dted;

import com.bbn.openmap.dataAccess.dted.DTEDFrameUtil;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DTEDFrameDSI {
    public char sec_code;
    public String sec_rel;
    public String sec_handling;
    public String sec_res;
    public String series;
    public String ser_ref_num;
    public String ser_res;
    public int data_ed;
    public char merge_version;
    public String maint_date;
    public String merge_date;
    public String maint_desc;
    public String prod_code;
    public String prod_res;
    public String spec;
    public int spec_amen;
    public String product_date;
    public String vert_datum;
    public String horiz_datum;
    public String dc_system;
    public String compilation_date;
    public String date_res;
    public float lat_origin;
    public float lon_origin;
    public float sw_lat;
    public float sw_lon;
    public float nw_lat;
    public float nw_lon;
    public float ne_lat;
    public float ne_lon;
    public float se_lat;
    public float se_lon;
    public float orient_ang;
    public int lat_post_interval;
    public int lon_post_interval;
    public int num_lat_lines;
    public int num_lon_points;
    public int part_cell;

    public DTEDFrameDSI(BinaryFile binFile) {
        try {
            String test;
            binFile.seek(80L);
            binFile.skipBytes(3L);
            this.sec_code = binFile.readChar();
            this.sec_rel = binFile.readFixedLengthString(2);
            this.sec_handling = binFile.readFixedLengthString(27);
            this.sec_res = binFile.readFixedLengthString(26);
            this.series = binFile.readFixedLengthString(5);
            this.ser_ref_num = binFile.readFixedLengthString(15);
            this.ser_res = binFile.readFixedLengthString(8);
            try {
                test = binFile.readFixedLengthString(2);
                this.data_ed = Integer.parseInt(test, 10);
            }
            catch (NumberFormatException nfe) {
                Debug.message("dted", "DTEDFrameDSI: Data Edition number bad, using 0");
                this.data_ed = 0;
            }
            this.merge_version = binFile.readChar();
            this.maint_date = binFile.readFixedLengthString(4);
            this.merge_date = binFile.readFixedLengthString(4);
            this.maint_desc = binFile.readFixedLengthString(4);
            this.prod_code = binFile.readFixedLengthString(8);
            this.prod_res = binFile.readFixedLengthString(16);
            this.spec = binFile.readFixedLengthString(9);
            try {
                test = binFile.readFixedLengthString(2);
                this.spec_amen = Integer.parseInt(test, 10);
            }
            catch (NumberFormatException nfe) {
                Debug.message("dted", "DTEDFrameDSI: Spec Amendment number bad, using 0");
                this.spec_amen = 0;
            }
            this.product_date = binFile.readFixedLengthString(4);
            this.vert_datum = binFile.readFixedLengthString(3);
            this.horiz_datum = binFile.readFixedLengthString(5);
            this.dc_system = binFile.readFixedLengthString(10);
            this.compilation_date = binFile.readFixedLengthString(4);
            this.date_res = binFile.readFixedLengthString(22);
            this.lat_origin = DTEDFrameUtil.stringToLat(binFile.readFixedLengthString(9));
            this.lon_origin = DTEDFrameUtil.stringToLon(binFile.readFixedLengthString(10));
            this.sw_lat = DTEDFrameUtil.stringToLat(binFile.readFixedLengthString(7));
            this.sw_lon = DTEDFrameUtil.stringToLon(binFile.readFixedLengthString(8));
            this.nw_lat = DTEDFrameUtil.stringToLat(binFile.readFixedLengthString(7));
            this.nw_lon = DTEDFrameUtil.stringToLon(binFile.readFixedLengthString(8));
            this.ne_lat = DTEDFrameUtil.stringToLat(binFile.readFixedLengthString(7));
            this.ne_lon = DTEDFrameUtil.stringToLon(binFile.readFixedLengthString(8));
            this.se_lat = DTEDFrameUtil.stringToLat(binFile.readFixedLengthString(7));
            this.se_lon = DTEDFrameUtil.stringToLon(binFile.readFixedLengthString(8));
            try {
                test = binFile.readFixedLengthString(9);
                this.orient_ang = Float.valueOf(test).floatValue();
            }
            catch (NumberFormatException nfe) {
                Debug.message("dted", "DTEDFrameDSI: orient angle number bad, using 0");
                this.orient_ang = 0.0f;
            }
            this.lat_post_interval = Integer.parseInt(binFile.readFixedLengthString(4), 10);
            this.lon_post_interval = Integer.parseInt(binFile.readFixedLengthString(4), 10);
            this.num_lat_lines = Integer.parseInt(binFile.readFixedLengthString(4), 10);
            this.num_lon_points = Integer.parseInt(binFile.readFixedLengthString(4), 10);
            try {
                test = binFile.readFixedLengthString(2);
                this.part_cell = Integer.parseInt(test, 10);
            }
            catch (NumberFormatException nfe) {
                Debug.message("dted", "DTEDFrameDSI: partial cell number bad, using 0");
                this.part_cell = 0;
            }
        }
        catch (IOException e) {
            Debug.error("DTEDFrameDSI: File IO Error!\n" + e.toString());
        }
        catch (FormatException f) {
            Debug.error("DTEDFrameDSI: File IO Format error!\n" + f.toString());
        }
        catch (NumberFormatException nfe) {
            Debug.error("DTEDFrameDSI: Number format error!\n" + nfe.toString());
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("***DSI***").append("\n");
        s.append("  sec_code: ").append(this.sec_code);
        s.append("  sec_rel: ").append(this.sec_rel).append("\n");
        s.append("  sec_handling: ").append(this.sec_handling).append("\n");
        s.append("  sec_res: ").append(this.sec_res).append("\n");
        s.append("  series: ").append(this.series).append("\n");
        s.append("  ser_ref_num: ").append(this.ser_ref_num).append("\n");
        s.append("  ser_res: ").append(this.ser_res).append("\n");
        s.append("  data_ed: ").append(this.data_ed).append("\n");
        s.append("  merge_version: ").append(this.merge_version).append("\n");
        s.append("  maint_date: ").append(this.maint_date).append("\n");
        s.append("  merge_date: ").append(this.merge_date).append("\n");
        s.append("  maint_desc: ").append(this.maint_desc).append("\n");
        s.append("  prod_code: ").append(this.prod_code).append("\n");
        s.append("  prod_res: ").append(this.prod_res).append("\n");
        s.append("  spec: ").append(this.spec).append("\n");
        s.append("  spec_amen: ").append(this.spec_amen).append("\n");
        s.append("  product_date: ").append(this.product_date).append("\n");
        s.append("  vert_datum: ").append(this.vert_datum).append("\n");
        s.append("  horiz_datum: ").append(this.horiz_datum).append("\n");
        s.append("  dc_system: ").append(this.dc_system).append("\n");
        s.append("  compilation_date: ").append(this.compilation_date).append("\n");
        s.append("  date_res: ").append(this.date_res).append("\n");
        s.append("  lat_origin: ").append(this.lat_origin).append("\n");
        s.append("  lon_origin: ").append(this.lon_origin).append("\n");
        s.append("  sw_lat: ").append(this.sw_lat).append("\n");
        s.append("  sw_lon: ").append(this.sw_lon).append("\n");
        s.append("  nw_lat: ").append(this.nw_lat).append("\n");
        s.append("  nw_lon: ").append(this.nw_lon).append("\n");
        s.append("  ne_lat: ").append(this.ne_lat).append("\n");
        s.append("  ne_lon: ").append(this.ne_lon).append("\n");
        s.append("  se_lat: ").append(this.se_lat).append("\n");
        s.append("  se_lon: ").append(this.se_lon).append("\n");
        s.append("  orient_ang: ").append(this.orient_ang).append("\n");
        s.append("  lat_post_interval: ").append(this.lat_post_interval).append("\n");
        s.append("  lon_post_interval: ").append(this.lon_post_interval).append("\n");
        s.append("  num_lat_lines: ").append(this.num_lat_lines).append("\n");
        s.append("  num_lon_points: ").append(this.num_lon_points).append("\n");
        s.append("  part_cell: ").append(this.part_cell).append("\n");
        return s.toString();
    }

    public static void main(String[] args) {
        Debug.init();
        if (args.length < 1) {
            Debug.output("dtedframe_dsi:  Need a path/filename");
            System.exit(0);
        }
        Debug.output("DTEDFrameDSI: using frame " + args[0]);
        File file = new File(args[0]);
        try {
            BinaryBufferedFile binFile = new BinaryBufferedFile(file);
            DTEDFrameDSI dfd = new DTEDFrameDSI(binFile);
            Debug.output(dfd.toString());
        }
        catch (FileNotFoundException e) {
            Debug.error("DTEDFrameDSI: file " + args[0] + " not found");
            System.exit(-1);
        }
        catch (IOException e) {
            Debug.error("DTEDFrameDSI: File IO Error!\n" + e.toString());
        }
    }
}

