/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.dted;

import com.bbn.openmap.dataAccess.dted.DTEDFrameUtil;
import com.bbn.openmap.dataAccess.dted.DTEDNameTranslator;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.util.Debug;

public class StandardDTEDNameTranslator
implements DTEDNameTranslator {
    protected boolean DEBUG = Debug.debugging("dtedfile");
    protected String filename = null;
    protected String subDirs = null;
    protected String dtedDir = "";
    protected double lat;
    protected double lon;
    protected int level;

    public StandardDTEDNameTranslator() {
    }

    public StandardDTEDNameTranslator(String dtedDir, double lat, double lon, int level) {
        this.set(dtedDir, lat, lon, level);
    }

    public StandardDTEDNameTranslator(double lat, double lon, int level) {
        this.set(null, lat, lon, level);
    }

    public void set(String filePath) throws FormatException {
        this.evaluate(filePath);
    }

    public void set(String dtedDir, double lat, double lon, int level) {
        this.setDTEDDir(dtedDir);
        this.filename = this.evaluate(lat, lon, level);
    }

    public void set(double lat, double lon, int level) {
        this.set(this.getDTEDDir(), lat, lon, level);
    }

    public void setLat(double latitude) {
        this.filename = this.evaluate(latitude, this.getLon(), this.getLevel());
    }

    public double getLat() {
        return this.lat;
    }

    public void setLon(double longitude) {
        this.filename = this.evaluate(this.getLat(), longitude, this.getLevel());
    }

    public double getLon() {
        return this.lon;
    }

    public void setLevel(int level) {
        this.filename = this.evaluate(this.getLat(), this.getLon(), level);
    }

    public int getLevel() {
        return this.level;
    }

    public String getSubDirs() {
        return this.subDirs;
    }

    public String getFileName() {
        return this.filename;
    }

    public String getName() {
        return this.dtedDir + "/" + this.filename;
    }

    public void setName(String fileName) throws FormatException {
        this.evaluate(fileName);
    }

    public void setDTEDDir(String dtedDirectory) {
        if (dtedDirectory == null) {
            this.dtedDir = "";
        }
        this.dtedDir = dtedDirectory;
    }

    public String getDTEDDir() {
        return this.dtedDir;
    }

    protected String evaluate(double lat, double lon, int level) {
        this.lat = Math.floor(lat);
        this.lon = Math.floor(lon);
        this.level = level;
        return DTEDFrameUtil.lonToFileString((float)lon) + "/" + DTEDFrameUtil.latToFileString((float)lat, level);
    }

    protected void evaluate(String filePath) throws FormatException {
        try {
            int latSlash = filePath.lastIndexOf("/");
            if (latSlash > 1) {
                int lonSlash;
                if (this.DEBUG) {
                    Debug.output("Have lat index of " + latSlash);
                }
                String lonSearch = filePath.substring(0, latSlash);
                if (this.DEBUG) {
                    Debug.output("Searching for lon index in " + lonSearch);
                }
                if ((lonSlash = lonSearch.lastIndexOf("/")) > 1) {
                    int dotIndex;
                    this.filename = filePath.substring(latSlash + 1);
                    String latString = this.filename.toUpperCase();
                    if (this.DEBUG) {
                        Debug.output("have lat " + latString);
                    }
                    if ((dotIndex = latString.indexOf(".")) > 0) {
                        this.lat = Double.parseDouble(latString.substring(1, dotIndex));
                        if (latString.charAt(0) == 'S') {
                            this.lat *= -1.0;
                        }
                        this.subDirs = filePath.substring(lonSlash + 1, latSlash);
                        String dd = filePath.substring(0, lonSlash + 1);
                        if (dd.length() > 0) {
                            this.dtedDir = dd;
                        }
                        String lonString = this.subDirs.toUpperCase();
                        if (this.DEBUG) {
                            Debug.output("have lon " + lonString);
                        }
                        this.lon = Double.parseDouble(lonString.substring(1));
                        if (lonString.charAt(0) == 'W') {
                            this.lon *= -1.0;
                        }
                        this.level = Integer.parseInt(filePath.substring(filePath.length() - 1));
                        if (this.DEBUG) {
                            Debug.output("have level " + this.level);
                        }
                        return;
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new FormatException("StandardDTEDNameTranslator couldn't convert " + filePath + " to valid parameters");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("For file: ").append(this.filename).append("\n");
        sb.append("  lat = ").append(this.lat).append("\n");
        sb.append("  lon = ").append(this.lon).append("\n");
        sb.append("  level = ").append(this.level).append("\n");
        String dd = this.getDTEDDir();
        if (dd.length() > 0) {
            dd = dd + "/";
        }
        sb.append("  path = ").append(dd).append(this.getSubDirs()).append("/").append(this.getName()).append("\n");
        return sb.toString();
    }

    public static void main(String[] argv) {
        Debug.init();
        if (argv.length == 0) {
            Debug.output("Usage:  StandardDTEDNameTranslator <dted file path>");
            System.exit(0);
        }
        StandardDTEDNameTranslator sdnt = new StandardDTEDNameTranslator();
        try {
            sdnt.set(argv[0]);
            Debug.output(sdnt.toString());
        }
        catch (FormatException fe) {
            Debug.output(fe.getMessage());
        }
    }
}

