/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.OSMMapTileCoordinateTransform;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;

public class MapTileUtil {
    static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.mapTile");
    public static final String SOURCE_PROPERTY = "source";
    public static final String BOUNDS_PROPERTY = "bounds";
    public static final String DESTINATION_PROPERTY = "destination";
    public static final String IMAGEFORMAT_PROPERTY = "format";
    public static final String ZOOMLEVEL_PROPERTY = "zoom";
    public static final int ZOOM_LEVELS = 21;
    MapTileCoordinateTransform mtcTransform;
    List<double[]> boundsList;
    boolean[] zoomLevels;

    public MapTileUtil(Action builder) {
        this.boundsList = builder.boundsList;
        this.zoomLevels = builder.zoomLevels;
        this.mtcTransform = builder.mtcTransform;
    }

    public void grabTiles(Action builder) {
        if (this.boundsList == null) {
            this.boundsList = new ArrayList<double[]>();
            this.boundsList.add(new double[]{80.0, -180.0, -80.0, 180.0});
        }
        for (int i = 0; i < 21; ++i) {
            if (this.zoomLevels == null ? i > 14 : !this.zoomLevels[i]) continue;
            for (double[] bounds : this.boundsList) {
                int[] uvBounds = this.mtcTransform.getTileBoundsForProjection(new LatLonPoint.Double(bounds[0], bounds[1]), new LatLonPoint.Double(bounds[2], bounds[3]), i);
                int uvup = uvBounds[0];
                int uvleft = uvBounds[1];
                int uvbottom = uvBounds[2];
                int uvright = uvBounds[3];
                int uvleftM = Math.min(uvleft, uvright);
                int uvrightM = Math.max(uvleft, uvright);
                int uvupM = Math.min(uvbottom, uvup);
                int uvbottomM = Math.max(uvbottom, uvup);
                for (int x = uvleftM; x < uvrightM; ++x) {
                    for (int y = uvupM; y < uvbottomM; ++y) {
                        builder.action(x, y, i, this);
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        new Jar("/data/sourcetiles", "/data/dest.jar").addZoomRange(0, 17).addBounds(14.042, 2.498, 0.809, 15.215).go();
    }

    public static class URLGrabber
    extends Action {
        public URLGrabber(String source, String destination) {
            super(source, destination);
        }

        public void go() {
            if (this.source != null && this.destination != null) {
                new MapTileUtil(this).grabTiles(this);
            } else {
                logger.warning("Need a source and destination for tile locations");
            }
        }

        public void action(int x, int y, int zoomLevel, MapTileUtil mtu) {
            this.grabURLTile(x, y, zoomLevel);
        }

        public void grabURLTile(int x, int y, int zoomLevel) {
            URL url = null;
            String imagePath = this.source + "/" + zoomLevel + "/" + x + "/" + y + (this.format.startsWith(".") ? this.format : "." + this.format);
            try {
                url = new URL(imagePath);
                HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("url content type: " + urlc.getContentType());
                }
                if (urlc == null) {
                    logger.warning("unable to connect to " + imagePath);
                    return;
                }
                if (urlc.getContentType().startsWith("image")) {
                    InputStream in = urlc.getInputStream();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    int buflen = 2048;
                    byte[] buf = new byte[buflen];
                    int len = -1;
                    while ((len = in.read(buf, 0, buflen)) != -1) {
                        out.write(buf, 0, len);
                    }
                    out.flush();
                    out.close();
                    byte[] imageBytes = out.toByteArray();
                    if (this.destination != null) {
                        File localFile = new File(this.destination + "/" + zoomLevel + "/" + x + "/" + y + (this.format.startsWith(".") ? this.format : "." + this.format));
                        File parentDir = localFile.getParentFile();
                        parentDir.mkdirs();
                        FileOutputStream fos = new FileOutputStream(localFile);
                        fos.write(imageBytes);
                        fos.flush();
                        fos.close();
                    }
                }
            }
            catch (MalformedURLException murle) {
                logger.warning("WebImagePlugIn: URL \"" + imagePath + "\" is malformed.");
            }
            catch (IOException ioe) {
                logger.warning("Couldn't connect to " + imagePath + "Connection Problem");
            }
        }
    }

    public static class Jar
    extends Action {
        ZipOutputStream zoStream = null;
        File destinationFile = null;
        long fileCount = 0L;
        int zipTrim = 0;

        public Jar(String source, String destination) {
            super(source, destination);
        }

        public void go() {
            if (this.source != null && this.destination != null) {
                new MapTileUtil(this).grabTiles(this);
                if (this.zoStream != null) {
                    try {
                        this.zoStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                logger.info("Created " + this.getDestination() + " with " + this.fileCount + " files.");
            } else {
                logger.warning("Need a source and destination for tile locations");
            }
        }

        public void action(int x, int y, int zoomLevel, MapTileUtil mtu) {
            File tile = new File(this.getSource() + "/" + zoomLevel + "/" + x + "/" + y + "." + this.format);
            if (tile.exists()) {
                try {
                    if (this.zoStream == null) {
                        File tileDescription;
                        this.destinationFile = new File(this.getDestination());
                        FileOutputStream fos = new FileOutputStream(this.destinationFile);
                        this.zoStream = new ZipOutputStream(fos);
                        this.zipTrim = this.destinationFile.getParent().length() + 1;
                        logger.info("creating " + this.destinationFile);
                        File sourceParentFile = new File(this.getSource()).getParentFile();
                        if (sourceParentFile.exists() && (tileDescription = new File(sourceParentFile, "tiles.omp")).exists()) {
                            FileUtils.writeZipEntry(tileDescription, this.zoStream, this.zipTrim);
                            ++this.fileCount;
                            logger.info("adding " + tileDescription);
                        }
                    }
                    FileUtils.writeZipEntry(tile, this.zoStream, this.zipTrim);
                    ++this.fileCount;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    public static class Copy
    extends Action {
        public Copy(String source, String destination) {
            super(source, destination);
        }

        public void go() {
            if (this.source != null && this.destination != null) {
                new MapTileUtil(this).grabTiles(this);
            } else {
                logger.warning("Need a source and destination for tile locations");
            }
        }

        public void action(int x, int y, int zoomLevel, MapTileUtil mtu) {
            File sourceFile = new File(this.getSource() + "/" + zoomLevel + "/" + x + "/" + y + "." + this.format);
            File destDir = new File(this.getDestination() + "/" + zoomLevel + "/" + x);
            destDir.mkdirs();
            File destFile = new File(destDir, y + "." + this.format);
            try {
                if (sourceFile.exists()) {
                    FileUtils.copy(sourceFile, destFile, 1024);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Action {
        String source;
        String destination;
        String format = "png";
        List<double[]> boundsList;
        boolean[] zoomLevels;
        MapTileCoordinateTransform mtcTransform = new OSMMapTileCoordinateTransform();

        public Action(String source, String destination) {
            this.source = source;
            this.destination = destination;
        }

        public Action addBounds(double ulat, double llon, double llat, double rlon) {
            if (this.boundsList == null) {
                this.boundsList = new ArrayList<double[]>();
            }
            double[] bnds = new double[]{ulat, llon, llat, rlon};
            this.boundsList.add(bnds);
            return this;
        }

        public Action addZoom(int zoom) {
            if (this.zoomLevels == null) {
                this.zoomLevels = new boolean[21];
            }
            try {
                this.zoomLevels[zoom] = true;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                logger.warning("zoom level invalid, ignoring: " + zoom);
            }
            return this;
        }

        public Action addZoomRange(int zoom1, int zoom2) {
            int min = Math.min(zoom1, zoom2);
            int max = Math.max(zoom1, zoom2);
            for (int z = min; z <= max; ++z) {
                this.addZoom(z);
            }
            return this;
        }

        public Action format(String format) {
            this.format = format;
            return this;
        }

        public Action transform(MapTileCoordinateTransform transform) {
            this.mtcTransform = transform;
            return this;
        }

        public abstract void go();

        public abstract void action(int var1, int var2, int var3, MapTileUtil var4);

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public List<double[]> getBoundsList() {
            return this.boundsList;
        }

        public void setBoundsList(List<double[]> boundsList) {
            this.boundsList = boundsList;
        }

        public boolean[] getZoomLevels() {
            return this.zoomLevels;
        }

        public void setZoomLevels(boolean[] zoomLevels) {
            this.zoomLevels = zoomLevels;
        }

        public MapTileCoordinateTransform getMtcTransform() {
            return this.mtcTransform;
        }

        public void setMtcTransform(MapTileCoordinateTransform mtcTransform) {
            this.mtcTransform = mtcTransform;
        }
    }
}

