/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.mapTile.MapTileFactory;
import com.bbn.openmap.dataAccess.mapTile.StandardMapTileFactory;
import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.cacheHandler.CacheObject;
import java.awt.image.BufferedImage;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.ImageIcon;

public class TileMillMapTileFactory
extends StandardMapTileFactory
implements MapTileFactory,
PropertyConsumer {
    public static final String DEFAULT_TEST_CLASS = "org.sqlite.JDBC";
    public static final String TEST_CLASS_PROPERTY = "testClass";
    protected String testClass = "org.sqlite.JDBC";

    public TileMillMapTileFactory() {
        this(null);
    }

    public TileMillMapTileFactory(String rootDir) {
        this.rootDir = rootDir;
        this.fileExt = ".png";
        this.verbose = logger.isLoggable(Level.FINE);
    }

    public CacheObject load(Object key, int x, int y, int zoomLevel, Projection proj) {
        try {
            Class.forName(this.testClass);
        }
        catch (Exception e) {
            logger.warning("can't locate sqlite JDBC components");
            return null;
        }
        try {
            Connection conn = DriverManager.getConnection(this.rootDir);
            Statement stat = conn.createStatement();
            StringBuilder statement = new StringBuilder("select tile_data from map, images where");
            statement.append(" zoom_level = ").append(zoomLevel);
            statement.append(" and tile_column = ").append(x);
            statement.append(" and tile_row = ").append(Math.pow(2.0, zoomLevel) - (double)y - 1.0);
            statement.append(" and map.tile_id = images.tile_id;");
            ResultSet rs = stat.executeQuery(statement.toString());
            while (rs.next()) {
                byte[] imageBytes = rs.getBytes("tile_data");
                ImageIcon ii = new ImageIcon(imageBytes);
                BufferedImage bi = BufferedImageHelper.getBufferedImage(ii.getImage(), 0, 0, -1, -1);
                OMGraphic raster = this.createOMGraphicFromBufferedImage(bi, x, y, zoomLevel, proj);
                if (raster == null) continue;
                return new CacheObject((String)key, raster);
            }
            rs.close();
            conn.close();
        }
        catch (Exception e) {
            logger.warning("something went wrong fetching image from database: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public Properties getProperties(Properties getList) {
        getList = super.getProperties(getList);
        if (this.testClass != null && !this.testClass.equals(DEFAULT_TEST_CLASS)) {
            getList.put(this.prefix + TEST_CLASS_PROPERTY, PropUtils.unnull(this.testClass));
        }
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        I18n i18n = Environment.getI18n();
        PropUtils.setI18NPropertyInfo(i18n, list, StandardMapTileFactory.class, TEST_CLASS_PROPERTY, "JDBC Availability Test Class", "A class in the JDBC driver package to use to test for JDBC driver configuration (any class in package).", null);
        return list;
    }

    public void setProperties(String prefix, Properties setList) {
        super.setProperties(prefix, setList);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.testClass = setList.getProperty(prefix + TEST_CLASS_PROPERTY, this.testClass);
    }
}

