/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPolygon;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMRangeRings;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Iterator;
import java.util.Vector;

public class EsriPolygonList
extends EsriGraphicList {
    public boolean add(OMGraphic shape) {
        boolean ret = false;
        try {
            if (this.typeMatches(shape)) {
                ret = this.graphics.add(shape);
                this.addExtents(((EsriGraphic)((Object)shape)).getExtents());
            } else if (shape instanceof OMPoly) {
                EsriPolygon eg = this.convert((OMPoly)shape);
                if (this.typeMatches(eg)) {
                    ret = this.graphics.add(eg);
                    this.addExtents(eg.getExtents());
                }
            } else if (shape instanceof OMGraphicList && !((OMGraphicList)shape).isVague()) {
                Iterator it = ((OMGraphicList)shape).iterator();
                while (it.hasNext()) {
                    this.add((OMGraphic)it.next());
                }
                ret = true;
            } else {
                Debug.message("esri", "EsriPolygonList.add()- graphic isn't a EsriPoly or OMPoly, can't add.");
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return ret;
    }

    public EsriPolygon convert(OMPoly ompoly) {
        return EsriPolygon.convert(ompoly);
    }

    public boolean typeMatches(OMGraphic omg) {
        return omg instanceof EsriGraphic && ((EsriGraphic)((Object)omg)).getType() == this.getType();
    }

    public int getType() {
        return 5;
    }

    public EsriPolygonList() {
    }

    public EsriPolygonList(int initialCapacity) {
        super(initialCapacity);
    }

    public EsriPolygonList(int initialCapacity, int capacityIncrement) {
        super(initialCapacity);
    }

    public static OMPoly convert(OMRect omRect) {
        double[] rectPoints = new double[]{omRect.getNorthLat(), omRect.getWestLon(), omRect.getSouthLat(), omRect.getWestLon(), omRect.getSouthLat(), omRect.getEastLon(), omRect.getNorthLat(), omRect.getEastLon(), omRect.getNorthLat(), omRect.getWestLon()};
        OMPoly poly = new OMPoly(rectPoints, 0, omRect.getLineType());
        poly.setAttributes(omRect.getAttributes());
        DrawingAttributes da = new DrawingAttributes();
        da.setFrom(omRect);
        da.setTo(poly);
        return poly;
    }

    public static OMPoly convert(OMCircle omCircle, Projection proj) {
        GeneralPath shape = omCircle.getShape();
        PathIterator circle = shape.getPathIterator(null);
        Vector<Float> initialPoints = new Vector<Float>();
        double[] segPoints = new double[2];
        while (!circle.isDone()) {
            int segType = circle.currentSegment(segPoints);
            initialPoints.add(new Float(segPoints[0]));
            initialPoints.add(new Float(segPoints[1]));
            circle.next();
        }
        double[] circlePoints = new double[initialPoints.size()];
        if (proj == null) {
            return null;
        }
        LatLonPoint.Double llp = new LatLonPoint.Double();
        for (int p = 0; p < initialPoints.size(); p += 2) {
            proj.inverse(((Float)initialPoints.elementAt(p)).doubleValue(), ((Float)initialPoints.elementAt(p + 1)).doubleValue(), llp);
            circlePoints[p] = (float)llp.getRadLat();
            circlePoints[p + 1] = (float)llp.getRadLon();
        }
        OMPoly poly = new OMPoly(circlePoints, 1, omCircle.getLineType());
        poly.setAttributes(omCircle.getAttributes());
        DrawingAttributes da = new DrawingAttributes();
        da.setFrom(omCircle);
        da.setTo(poly);
        return poly;
    }

    public static OMGraphicList convert(OMRangeRings omRR, Projection proj) {
        OMCircle[] circles = omRR.createCircles();
        OMGraphicList circleList = new OMGraphicList();
        circleList.setAttributes(omRR.getAttributes());
        if (proj == null) {
            return circleList;
        }
        for (int i = 0; i < circles.length; ++i) {
            if (circles[i].generate(proj)) {
                OMPoly poly = EsriPolygonList.convert(circles[i], proj);
                if (poly == null) continue;
                circleList.add(poly);
                continue;
            }
            System.out.println("Could not generate circle from RangeRing");
            return null;
        }
        DrawingAttributes da = new DrawingAttributes();
        da.setFrom(omRR);
        da.setTo(circleList);
        return circleList;
    }

    public EsriGraphic shallowCopy() {
        EsriPolygonList ret = new EsriPolygonList(this.size());
        for (EsriGraphic g : this) {
            ret.add((OMGraphic)((Object)g.shallowCopy()));
        }
        ret.setAttributes(this.getAttributes());
        return ret;
    }
}

