/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.event.UndoEvent;
import com.bbn.openmap.event.UndoStackSupport;
import com.bbn.openmap.event.UndoStackTrigger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoStack
extends OMComponent
implements ActionListener {
    private static final Logger logger = Logger.getLogger("com.bbn.openmap.event.UndoStack");
    public static final int DEFAULT_MAX_SIZE = 10;
    public static final int REMEMBER_ALL = -1;
    protected transient UndoEvent currentState;
    protected int stackSize = 10;
    public static final transient String UndoCmd = "undo";
    public static final transient String RedoCmd = "redo";
    public static final transient String ClearUndoCmd = "clearUndoStack";
    public static final transient String ClearRedoCmd = "clearRedoStack";
    public static final transient String ClearCmd = "clearStacks";
    protected final Stack<UndoEvent> undoStack;
    protected final Stack<UndoEvent> redoStack = new Stack();
    protected final UndoStackSupport triggers;

    public UndoStack() {
        this.undoStack = new Stack();
        this.triggers = new UndoStackSupport();
    }

    public void setTheWayThingsAre(UndoEvent event) {
        if (this.currentState != null) {
            this.rememberLastThing(this.currentState);
        }
        this.currentState = event;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("making (" + this.currentState.getDescription() + ") current state");
        }
        this.redoStack.clear();
        this.fireStackStatus();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand().intern();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Received command: " + command);
        }
        if (UndoCmd.equalsIgnoreCase(command) && this.undoStack != null && !this.undoStack.empty()) {
            this.undo();
        } else if (RedoCmd.equalsIgnoreCase(command) && this.redoStack != null && !this.redoStack.empty()) {
            this.redo();
        } else {
            this.clearStacks(ClearUndoCmd.equalsIgnoreCase(command) || ClearCmd.equalsIgnoreCase(command), ClearRedoCmd.equalsIgnoreCase(command) || ClearCmd.equalsIgnoreCase(command));
        }
    }

    protected synchronized void rememberLastThing(UndoEvent event) {
        if (this.undoStack.size() >= this.stackSize) {
            this.undoStack.removeElementAt(0);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("remembering (" + event.getDescription() + ")");
        }
        this.undoStack.push(event);
    }

    protected synchronized void undo() {
        if (this.currentState != null) {
            while (this.redoStack.size() >= this.stackSize) {
                this.redoStack.removeElementAt(0);
                logger.info("making room for " + this.currentState.getDescription());
            }
            this.redoStack.push(this.currentState);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("making last current state (" + this.currentState.getDescription() + ") on redo stack");
            }
        }
        this.currentState = this.undoStack.pop();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("making top undo state (" + this.currentState.getDescription() + ") current state");
        }
        if (this.currentState != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("calling setState on " + this.currentState.getDescription());
            }
            this.currentState.setState();
        }
        this.fireStackStatus();
    }

    protected synchronized void redo() {
        if (this.currentState != null) {
            while (this.undoStack.size() >= this.stackSize) {
                this.undoStack.removeElementAt(0);
            }
            this.undoStack.push(this.currentState);
        }
        this.currentState = this.redoStack.pop();
        if (this.currentState != null) {
            this.currentState.setState();
        }
        this.fireStackStatus();
    }

    public synchronized void clearStacks(boolean clearUndoStack, boolean clearRedoStack) {
        if (clearUndoStack && this.undoStack != null) {
            this.undoStack.clear();
        }
        if (clearRedoStack && this.redoStack != null) {
            this.redoStack.clear();
        }
        this.currentState = null;
        this.fireStackStatus();
    }

    public void fireStackStatus() {
        if (this.triggers != null) {
            UndoEvent undoEvent = this.getWhatWillHappenNextFromStack(this.undoStack);
            UndoEvent redoEvent = this.getWhatWillHappenNextFromStack(this.redoStack);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("back enabled: " + (undoEvent != null) + ", forward enabled: " + (redoEvent != null));
            }
            this.triggers.fireStackStatus(undoEvent, redoEvent);
        }
    }

    protected UndoEvent getWhatWillHappenNextFromStack(Stack<UndoEvent> stack) {
        UndoEvent nextThing = null;
        try {
            nextThing = stack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return nextThing;
    }

    public void addUndoStackTrigger(UndoStackTrigger trigger) {
        trigger.addActionListener(this);
        UndoEvent undoEvent = this.getWhatWillHappenNextFromStack(this.undoStack);
        UndoEvent redoEvent = this.getWhatWillHappenNextFromStack(this.redoStack);
        this.triggers.add(trigger);
        trigger.updateUndoStackStatus(undoEvent, redoEvent);
    }

    public void removeUndoStackTrigger(UndoStackTrigger trigger) {
        trigger.removeActionListener(this);
        if (this.triggers != null) {
            this.triggers.remove(trigger);
        }
    }
}

