/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.BoundingCircle;
import com.bbn.openmap.geo.ExtentIndex;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.GeoArray;
import com.bbn.openmap.geo.GeoExtent;
import com.bbn.openmap.geo.GeoPath;
import com.bbn.openmap.geo.GeoPoint;
import com.bbn.openmap.geo.GeoRegion;
import com.bbn.openmap.geo.GeoSegment;
import com.bbn.openmap.geo.MatchCollector;
import com.bbn.openmap.geo.MatchFilter;
import com.bbn.openmap.geo.MatchParameters;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Intersection {
    protected final MatchFilter filter;
    protected final MatchCollector collector;

    public Intersection(MatchFilter filter, MatchCollector collector) {
        this.filter = filter;
        this.collector = collector;
    }

    public static Intersection intersector() {
        return new Intersection(new MatchFilter.MatchParametersMF(MatchParameters.STRICT), new MatchCollector.SetMatchCollector());
    }

    public static Intersection intersector(MatchParameters params) {
        return new Intersection(new MatchFilter.MatchParametersMF(params), new MatchCollector.SetMatchCollector());
    }

    public static Intersection intersector(MatchParameters params, Collection c) {
        return new Intersection(new MatchFilter.MatchParametersMF(params), new MatchCollector.CollectionMatchCollector(c));
    }

    public static Intersection intersector(MatchFilter filter, MatchCollector collector) {
        return new Intersection(filter, collector);
    }

    public MatchCollector getCollector() {
        return this.collector;
    }

    public MatchFilter getFilter() {
        return this.filter;
    }

    public void consider(Object a, Object b) {
        if (b instanceof Collection) {
            if (a instanceof GeoRegion) {
                this.considerRegionXRegions((GeoRegion)a, (Collection)b);
            } else if (a instanceof GeoPath) {
                this.considerPathXRegions((GeoPath)a, (Collection)b);
            } else if (a instanceof GeoPoint) {
                this.considerPointXRegions((GeoPoint)a, (Collection)b);
            }
        } else if (b instanceof GeoRegion) {
            if (a instanceof GeoRegion) {
                this.considerRegionXRegion((GeoRegion)a, (GeoRegion)b);
            } else if (a instanceof GeoPath) {
                this.considerPathXRegion((GeoPath)a, (GeoRegion)b);
            } else if (a instanceof GeoPoint) {
                this.considerPointXRegion((GeoPoint)a, (GeoRegion)b);
            }
        }
    }

    public void considerRegionXRegions(GeoRegion r, Collection regions) {
        Iterator possibles = regions instanceof ExtentIndex ? ((ExtentIndex)regions).iterator(r) : regions.iterator();
        while (possibles.hasNext()) {
            GeoExtent extent = (GeoExtent)possibles.next();
            if (extent instanceof GeoRegion) {
                this.considerRegionXRegion(r, (GeoRegion)extent);
                continue;
            }
            if (extent instanceof GeoPath) {
                GeoPath.SegmentIterator pit = ((GeoPath)extent).segmentIterator();
                while (pit.hasNext()) {
                    GeoSegment seg = pit.nextSegment();
                    if (!this.filter.preConsider(seg, r) || !this.considerSegmentXRegion(seg, r)) continue;
                    this.collector.collect(seg, extent);
                }
                continue;
            }
            BoundingCircle bc = extent.getBoundingCircle();
            BoundingCircle rbc = r.getBoundingCircle();
            if (!rbc.intersects(bc.getCenter(), bc.getRadius() + this.filter.getHRange())) continue;
            GeoArray pts = r.getPoints();
            if (Intersection.isPointInPolygon(bc.getCenter(), pts)) {
                this.collector.collect(r, extent);
                continue;
            }
            if (!Intersection.isPointNearPoly(bc.getCenter(), pts, bc.getRadius() + this.filter.getHRange())) continue;
            this.collector.collect(r, extent);
        }
    }

    public void considerRegionXRegion(GeoRegion r, GeoRegion region) {
        GeoArray rBoundary = r.getPoints();
        Geo rPoint = rBoundary.get(0, new Geo());
        GeoArray regionBoundary = region.getPoints();
        Geo regionPoint = regionBoundary.get(0, new Geo());
        if (Intersection.isPointInPolygon(rPoint, regionBoundary) || Intersection.isPointInPolygon(regionPoint, rBoundary)) {
            this.collector.collect(r, region);
        } else {
            GeoPath.SegmentIterator pit = r.segmentIterator();
            while (pit.hasNext()) {
                GeoSegment seg = pit.nextSegment();
                if (!this.filter.preConsider(seg, region) || !this.considerSegmentXRegion(seg, region)) continue;
                this.collector.collect(seg, region);
                return;
            }
        }
    }

    public void considerPathXRegions(GeoPath path, Collection regions) {
        GeoPath.SegmentIterator pit = path.segmentIterator();
        while (pit.hasNext()) {
            GeoSegment seg = pit.nextSegment();
            Iterator rit = regions instanceof ExtentIndex ? ((ExtentIndex)regions).iterator(seg) : regions.iterator();
            while (rit.hasNext()) {
                GeoExtent extent = (GeoExtent)rit.next();
                if (!this.filter.preConsider(path, extent)) continue;
                if (extent instanceof GeoRegion) {
                    GeoRegion region = (GeoRegion)extent;
                    if (!this.considerSegmentXRegion(seg, region)) continue;
                    this.collector.collect(seg, region);
                    continue;
                }
                if (extent instanceof GeoPath) {
                    GeoPath p = (GeoPath)extent;
                    if (Intersection.isSegmentNearPoly(seg, p.getPoints(), this.filter.getHRange()) == null) continue;
                    this.collector.collect(seg, p);
                    continue;
                }
                BoundingCircle bc = extent.getBoundingCircle();
                if (!Intersection.isSegmentNearRadialRegion(seg, bc.getCenter(), bc.getRadius(), this.filter.getHRange())) continue;
                this.collector.collect(seg, extent);
            }
        }
    }

    public void considerPathXRegion(GeoPath path, GeoRegion region) {
        GeoPath.SegmentIterator pit = path.segmentIterator();
        while (pit.hasNext()) {
            GeoSegment seg = pit.nextSegment();
            if (!this.filter.preConsider(seg, region) || !this.considerSegmentXRegion(seg, region)) continue;
            this.collector.collect(seg, region);
            return;
        }
    }

    public boolean considerSegmentXRegion(GeoSegment seg, GeoRegion region) {
        return region.isSegmentNear(seg, this.filter.getHRange());
    }

    public void considerPointXRegions(GeoPoint p, Collection regions) {
        Iterator rit = regions instanceof ExtentIndex ? ((ExtentIndex)regions).iterator(p) : regions.iterator();
        while (rit.hasNext()) {
            GeoExtent extent = (GeoExtent)rit.next();
            if (!this.filter.preConsider(p, extent)) continue;
            if (extent instanceof GeoRegion) {
                GeoRegion region = (GeoRegion)extent;
                if (!this.considerPointXRegion(p, region)) continue;
                this.collector.collect(p, region);
                continue;
            }
            if (extent instanceof GeoPath) {
                GeoPath path = (GeoPath)extent;
                if (!Intersection.isPointNearPoly(p.getPoint(), path.getPoints(), this.filter.getHRange())) continue;
                this.collector.collect(p, path);
                continue;
            }
            BoundingCircle bc = extent.getBoundingCircle();
            if (!(p.getPoint().distance(bc.getCenter()) <= bc.getRadius() + this.filter.getHRange())) continue;
            this.collector.collect(p, extent);
        }
    }

    public boolean considerPointXRegion(GeoPoint p, GeoRegion region) {
        return Intersection.isPointInPolygon(p.getPoint(), region.getPoints());
    }

    public static Iterator intersect(Object path, Object regions) {
        MatchCollector.SetMatchCollector c = new MatchCollector.SetMatchCollector();
        Intersection ix = new Intersection(new MatchFilter.MatchParametersMF(MatchParameters.STRICT), c);
        ix.consider(path, regions);
        return c.iterator();
    }

    public static float[] getIntersection(float lat1, float lon1, float lat2, float lon2, float lat3, float lon3, float lat4, float lon4) {
        Geo geoCross1 = new Geo(lat1, lon1).crossNormalize(new Geo(lat2, lon2));
        Geo geoCross2 = new Geo(lat3, lon3).crossNormalize(new Geo(lat4, lon4));
        Geo geo = geoCross1.crossNormalize(geoCross2);
        Geo anti = geo.antipode();
        return new float[]{(float)geo.getLatitude(), (float)geo.getLongitude(), (float)anti.getLatitude(), (float)anti.getLongitude()};
    }

    public static double[] getIntersection(double lat1, double lon1, double lat2, double lon2, double lat3, double lon3, double lat4, double lon4) {
        Geo geoCross1 = new Geo(lat1, lon1).crossNormalize(new Geo(lat2, lon2));
        Geo geoCross2 = new Geo(lat3, lon3).crossNormalize(new Geo(lat4, lon4));
        Geo geo = geoCross1.crossNormalize(geoCross2);
        Geo anti = geo.antipode();
        return new double[]{geo.getLatitude(), geo.getLongitude(), anti.getLatitude(), anti.getLongitude()};
    }

    public static Geo getIntersectionGeo(double lat1, double lon1, double lat2, double lon2, double lat3, double lon3, double lat4, double lon4) {
        Geo geoCross1 = new Geo(lat1, lon1).crossNormalize(new Geo(lat2, lon2));
        Geo geoCross2 = new Geo(lat3, lon3).crossNormalize(new Geo(lat4, lon4));
        return geoCross1.crossNormalize(geoCross2, geoCross1);
    }

    public static boolean intersects(double lat1, double lon1, double lat2, double lon2, double lat3, double lon3, double lat4, double lon4) {
        double[] llp = Intersection.getSegIntersection(lat1, lon1, lat2, lon2, lat3, lon3, lat4, lon4);
        return llp[0] != Double.MAX_VALUE && llp[1] != Double.MAX_VALUE || llp[2] != Double.MAX_VALUE && llp[3] != Double.MAX_VALUE;
    }

    public static boolean polyIntersect(float[] polyPoints1, float[] polyPoints2) {
        for (int i = 0; i < polyPoints1.length / 2 - 1; ++i) {
            for (int j = 0; j < polyPoints2.length / 2 - 1; ++j) {
                if (!Intersection.intersects(polyPoints1[2 * i], polyPoints1[2 * i + 1], polyPoints1[2 * i + 2], polyPoints1[2 * i + 3], polyPoints2[2 * j], polyPoints2[2 * j + 1], polyPoints2[2 * j + 2], polyPoints2[2 * j + 3])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean polyIntersect(double[] polyPoints1, double[] polyPoints2) {
        for (int i = 0; i < polyPoints1.length / 2 - 1; ++i) {
            for (int j = 0; j < polyPoints2.length / 2 - 1; ++j) {
                if (!Intersection.intersects(polyPoints1[2 * i], polyPoints1[2 * i + 1], polyPoints1[2 * i + 2], polyPoints1[2 * i + 3], polyPoints2[2 * j], polyPoints2[2 * j + 1], polyPoints2[2 * j + 2], polyPoints2[2 * j + 3])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean polyIntersect_optimized(double[] polyPoints1, double[] polyPoints2) {
        int i;
        Geo[] geos1 = new Geo[polyPoints1.length / 2];
        Geo[] geos2 = new Geo[polyPoints2.length / 2];
        for (i = 0; i < geos1.length; ++i) {
            geos1[i] = new Geo(polyPoints1[2 * i], polyPoints1[2 * i + 1]);
        }
        for (i = 0; i < geos2.length; ++i) {
            geos2[i] = new Geo(polyPoints2[2 * i], polyPoints2[2 * i + 1]);
        }
        for (i = 0; i < geos1.length - 1; ++i) {
            for (int j = 0; j < geos2.length - 1; ++j) {
                Geo p1 = geos1[i];
                Geo p2 = geos1[i + 1];
                Geo p3 = geos2[j];
                Geo p4 = geos2[j + 1];
                Geo[] results = Intersection.getSegIntersection(p1, p2, p3, p4);
                if (results[0] == null && results[1] == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSelfIntersectingPoly(float[] polyPoints) {
        for (int i = 0; i < polyPoints.length / 2 - 1; ++i) {
            for (int j = i + 1; j < polyPoints.length / 2 - 1; ++j) {
                float lat1 = polyPoints[2 * i];
                float lon1 = polyPoints[2 * i + 1];
                float lat2 = polyPoints[2 * i + 2];
                float lon2 = polyPoints[2 * i + 3];
                float lat3 = polyPoints[2 * j];
                float lon3 = polyPoints[2 * j + 1];
                float lat4 = polyPoints[2 * j + 2];
                float lon4 = polyPoints[2 * j + 3];
                if (lat1 == lat4 && lon1 == lon4 || lat2 == lat3 && lon2 == lon3 || !Intersection.intersects(lat1, lon1, lat2, lon2, lat3, lon3, lat4, lon4)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSelfIntersectingPoly(double[] polyPoints) {
        for (int i = 0; i < polyPoints.length / 2 - 1; ++i) {
            for (int j = i + 1; j < polyPoints.length / 2 - 1; ++j) {
                double lat1 = polyPoints[2 * i];
                double lon1 = polyPoints[2 * i + 1];
                double lat2 = polyPoints[2 * i + 2];
                double lon2 = polyPoints[2 * i + 3];
                double lat3 = polyPoints[2 * j];
                double lon3 = polyPoints[2 * j + 1];
                double lat4 = polyPoints[2 * j + 2];
                double lon4 = polyPoints[2 * j + 3];
                if (lat1 == lat4 && lon1 == lon4 || lat2 == lat3 && lon2 == lon3 || !Intersection.intersects(lat1, lon1, lat2, lon2, lat3, lon3, lat4, lon4)) continue;
                return true;
            }
        }
        return false;
    }

    public static double pointCircleDistanceNM(Geo p1, Geo p2, Geo center) {
        return Geo.nm(Intersection.pointCircleDistance(p1, p2, center));
    }

    public static double pointCircleDistance(Geo p1, Geo p2, Geo center) {
        Geo n = Geo.crossNormalize(p1, p2, new Geo());
        Geo c = center.normalize(new Geo());
        double cosTheta = Geo.dot(n, c);
        double theta = Math.acos(cosTheta);
        return Math.abs(1.5707963267948966 - theta);
    }

    public static boolean isOnSegment(Geo a, Geo b, Geo i) {
        return a.distance(i) < a.distance(b) && b.distance(i) < b.distance(a);
    }

    public static boolean isOnSegment(Geo a, Geo b, Geo i, double withinRad) {
        return Math.abs(a.crossNormalize(b).dot(i)) <= withinRad && a.distance(i) < a.distance(b) && b.distance(i) < b.distance(a);
    }

    public static Geo segIntersection(Geo a, Geo b, Geo c) {
        Geo g = a.crossNormalize(b);
        Geo f = c.crossNormalize(g);
        Geo i = f.crossNormalize(g, g);
        if (Intersection.isOnSegment(a, b, i)) {
            return i;
        }
        Geo ai = i.antipode(i);
        if (Intersection.isOnSegment(a, b, ai)) {
            return ai;
        }
        return null;
    }

    public static final boolean segIntersects(Geo p1, Geo p2, Geo p3, Geo p4) {
        Geo[] r = Intersection.getSegIntersection(p1, p2, p3, p4);
        return r[0] != null || r[1] != null;
    }

    public static double pointSegDistanceNM(double lat1, double lon1, double lat2, double lon2, double lat, double lon) {
        double ret = Intersection.pointSegDistance(new Geo(lat1, lon1), new Geo(lat2, lon2), new Geo(lat, lon));
        return ret == -1.0 ? ret : Geo.nm(ret);
    }

    public static double pointSegDistance(Geo a, Geo b, Geo c) {
        Geo i = Intersection.segIntersection(a, b, c);
        return i == null ? -1.0 : c.distance(i);
    }

    public static boolean intersectsCircle(Geo p1, Geo p2, Geo center, double radius) {
        double d1 = Geo.distance(p1, center);
        if (d1 < radius) {
            return true;
        }
        double d2 = Geo.distance(p2, center);
        if (d2 < radius) {
            return true;
        }
        double dist = Intersection.pointCircleDistance(p1, p2, center);
        if (dist > radius) {
            return false;
        }
        Geo g = p1.cross(p2);
        Geo f = center.cross(g);
        Geo i = f.crossNormalize(g, g);
        double d = Geo.distance(p1, p2);
        if (center.distance(i) < radius) {
            double d11 = Geo.distance(p1, i);
            double d12 = Geo.distance(p2, i);
            return d11 <= d && d12 <= d && Math.abs(d11 + d12 - d) < (double)0.01f;
        }
        Geo i2 = i.antipode(i);
        if (center.distance(i2) < radius) {
            double d21 = Geo.distance(p1, i2);
            double d22 = Geo.distance(p2, i2);
            return d21 <= d && d22 <= d && Math.abs(d21 + d22 - d) < (double)0.01f;
        }
        return false;
    }

    public static boolean intersectsCircle(float[] polyPoints, double lat, double lon, double radius) {
        Geo a = new Geo(polyPoints[0], polyPoints[1]);
        Geo b = new Geo();
        Geo c = new Geo(lat, lon);
        int numCoords = polyPoints.length / 2 - 1;
        for (int i = 1; i < numCoords; ++i) {
            float lat2 = polyPoints[2 * i];
            float lon2 = polyPoints[2 * i + 1];
            b.initialize(lat2, lon2);
            if (Intersection.intersectsCircle(a, b, c, radius)) {
                return true;
            }
            a.initialize(b);
        }
        return false;
    }

    public static boolean intersectsCircle(double[] polyPoints, double lat, double lon, double radius) {
        Geo a = new Geo(polyPoints[0], polyPoints[1]);
        Geo b = new Geo();
        Geo c = new Geo(lat, lon);
        int numCoords = polyPoints.length / 2 - 1;
        for (int i = 1; i < numCoords; ++i) {
            double lat2 = polyPoints[2 * i];
            double lon2 = polyPoints[2 * i + 1];
            b.initialize(lat2, lon2);
            if (Intersection.intersectsCircle(a, b, c, radius)) {
                return true;
            }
            a.initialize(b);
        }
        return false;
    }

    public static Geo center(Geo[] poly) {
        return Intersection.center(poly, new Geo());
    }

    public static Geo center(Geo[] poly, Geo ret) {
        Geo c = new Geo(poly[0]);
        for (int i = 1; i < poly.length; ++i) {
            ret.initialize(poly[i]);
            c = c.add(poly[i], c);
        }
        return c.normalize(ret);
    }

    public static Geo center(GeoArray poly) {
        return Intersection.center(poly, new Geo());
    }

    public static Geo center(GeoArray poly, Geo ret) {
        Geo c = poly.get(0, new Geo());
        int size = poly.getSize();
        for (int i = 1; i < size; ++i) {
            poly.get(i, ret);
            c = c.add(ret, c);
        }
        return c.normalize(ret);
    }

    public static boolean isPointInPolygon(Geo x, GeoArray poly) {
        Geo c = Intersection.center(poly, new Geo());
        double d = x.distance(c);
        if (d >= 1.5707963267948966) {
            return false;
        }
        Geo ray = c.crossNormalize(x, c);
        Geo side = x.crossNormalize(ray, new Geo());
        boolean in = false;
        Geo p1 = poly.get(0, new Geo());
        Geo p2 = poly.get(0, new Geo());
        Geo tmp = new Geo();
        int polySize = poly.getSize();
        for (int i = 1; i < polySize; ++i) {
            p2 = poly.get(i, p2);
            if (p1.dot(ray) < 0.0 != p2.dot(ray) < 0.0 && p1.intersect(p2, ray, tmp).dot(side) > 0.0) {
                in = !in;
            }
            p1.initialize(p2);
        }
        if (!poly.equals(0, p1)) {
            poly.get(0, p2);
            if (p1.dot(ray) < 0.0 != p2.dot(ray) < 0.0 && p1.intersect(p2, ray, tmp).dot(side) > 0.0) {
                in = !in;
            }
        }
        return in;
    }

    public static boolean isPointInPolygon(Geo x, GeoArray poly, Geo internal) {
        Geo c = Geo.makeGeo(internal);
        double d = x.distance(c);
        if (d >= 1.5707963267948966) {
            return false;
        }
        if (internal.equals(c)) {
            return true;
        }
        Geo ray = c.crossNormalize(x, c);
        Geo side = x.crossNormalize(ray, new Geo());
        boolean in = false;
        Geo p1 = poly.get(0, new Geo());
        Geo p2 = poly.get(0, new Geo());
        Geo tmp = new Geo();
        int polySize = poly.getSize();
        for (int i = 1; i < polySize; ++i) {
            p2 = poly.get(i, p2);
            if (p1.dot(ray) < 0.0 != p2.dot(ray) < 0.0 && p1.intersect(p2, ray, tmp).dot(side) > 0.0) {
                in = !in;
            }
            p1.initialize(p2);
        }
        if (!poly.equals(0, p1)) {
            poly.get(0, p2);
            if (p1.dot(ray) < 0.0 != p2.dot(ray) < 0.0 && p1.intersect(p2, ray, tmp).dot(side) > 0.0) {
                in = !in;
            }
        }
        return in;
    }

    public static boolean isPointInPolygon(Geo x, double[] poly, boolean polyInDegrees) {
        if (polyInDegrees) {
            return Intersection.isPointInPolygon(x, GeoArray.Float.createFromLatLonDegrees(poly));
        }
        return Intersection.isPointInPolygon(x, GeoArray.Float.createFromLatLonRadians(poly));
    }

    public static boolean isPointInPolygon(Geo x, float[] poly, boolean polyInDegrees) {
        if (polyInDegrees) {
            return Intersection.isPointInPolygon(x, GeoArray.Float.createFromLatLonDegrees(poly));
        }
        return Intersection.isPointInPolygon(x, GeoArray.Float.createFromLatLonRadians(poly));
    }

    public static boolean isPolylineInsidePolygon(GeoArray poly, GeoArray region) {
        int polySize = poly.getSize();
        Geo testPoint = new Geo();
        for (int i = 0; i < polySize; ++i) {
            poly.get(i, testPoint);
            if (!Intersection.isPointInPolygon(testPoint, region)) continue;
            return true;
        }
        return false;
    }

    public static double[] getSegIntersection(double lat1, double lon1, double lat2, double lon2, double lat3, double lon3, double lat4, double lon4) {
        Geo p1 = new Geo(lat1, lon1);
        Geo p2 = new Geo(lat2, lon2);
        Geo p3 = new Geo(lat3, lon3);
        Geo p4 = new Geo(lat4, lon4);
        Geo[] results = Intersection.getSegIntersection(p1, p2, p3, p4);
        Geo i1 = results[0];
        Geo i2 = results[1];
        double[] llp = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE};
        if (i1 != null) {
            llp[0] = i1.getLatitude();
            llp[1] = i1.getLongitude();
        }
        if (i2 != null) {
            llp[2] = i2.getLatitude();
            llp[3] = i2.getLongitude();
        }
        return llp;
    }

    public static final Geo[] getSegIntersection(Geo p1, Geo p2, Geo p3, Geo p4) {
        Geo geoCross1 = p1.crossNormalize(p2);
        Geo geoCross2 = p3.crossNormalize(p4);
        Geo i1 = geoCross1.crossNormalize(geoCross2, geoCross1);
        Geo i2 = i1.antipode(geoCross2);
        double d1 = p1.distance(p2);
        double d2 = p3.distance(p4);
        double d111 = p1.distance(i1);
        double d121 = p2.distance(i1);
        double d112 = p1.distance(i2);
        double d122 = p2.distance(i2);
        double d211 = p3.distance(i1);
        double d221 = p4.distance(i1);
        double d212 = p3.distance(i2);
        double d222 = p4.distance(i2);
        Geo[] result = new Geo[]{null, null};
        if (d1 >= d111 && d1 >= d121 && d2 >= d211 && d2 >= d221) {
            result[0] = i1;
        }
        if (d1 >= d112 && d1 >= d122 && d2 >= d212 && d2 >= d222) {
            result[1] = i2;
        }
        return result;
    }

    public static final boolean isSegmentNearRadialRegion(GeoSegment segment, Geo rCenter, double rRadius, double near) {
        Geo[] s = segment.getSeg();
        if (s != null && s.length == 2) {
            return Intersection.isSegmentNearRadialRegion(s[0], s[1], rCenter, rRadius, near);
        }
        return false;
    }

    public static final boolean isSegmentNearRadialRegion(Geo s1, Geo s2, Geo rCenter, double rRadius, double near) {
        return s1.isInside(s2, near + rRadius, rCenter);
    }

    public static final boolean isSegmentNearRegion(GeoSegment segment, double hrange, GeoRegion region) {
        return Intersection.isSegmentNearPolyRegion(segment, region.getPoints(), hrange);
    }

    public static final boolean isSegmentNearPolyRegion(GeoSegment segment, GeoArray r, double near) {
        Geo[] s = segment.getSeg();
        if (s != null && s.length == 2) {
            return Intersection.isSegmentNearPolyRegion(s[0], s[1], r, near);
        }
        return false;
    }

    public static final boolean isSegmentNearPolyRegion(Geo s1, Geo s2, GeoArray r, double near) {
        return Intersection.isSegmentNearPoly(s1, s2, r, near) != null || Intersection.isPointInPolygon(s1, r);
    }

    public static final Geo isSegmentNearPoly(GeoSegment segment, GeoArray r, double near) {
        Geo[] s = segment.getSeg();
        if (s != null && s.length == 2) {
            return Intersection.isSegmentNearPoly(s[0], s[1], r, near);
        }
        return null;
    }

    public static final Geo isSegmentNearPoly(Geo s1, Geo s2, GeoArray r, double near) {
        int rlen = r.getSize();
        Geo pl0 = r.get(rlen - 1, new Geo());
        Geo pl1 = new Geo();
        Geo check = new Geo();
        for (int j = 0; j < rlen; ++j) {
            Geo ret = Intersection.segmentsIntersectOrNear(s1, s2, pl0, pl1 = r.get(j, pl1), near, check);
            if (ret != null) {
                return ret;
            }
            pl0.initialize(pl1);
        }
        return null;
    }

    public static final List<Geo> segmentNearPoly(GeoSegment segment, GeoArray r, double near) {
        Geo[] s = segment.getSeg();
        List<Geo> list = null;
        if (s != null && s.length == 2) {
            list = Intersection.segmentNearPoly(s[0], s[1], r, near);
        }
        return list;
    }

    public static final List<Geo> segmentNearPoly(Geo s1, Geo s2, GeoArray r, double near) {
        int rlen = r.getSize();
        Geo pl0 = r.get(rlen - 1, new Geo());
        Geo pl1 = new Geo();
        LinkedList<Geo> list = null;
        Geo check = new Geo();
        for (int j = 0; j < rlen; ++j) {
            r.get(j, pl1);
            Geo ret = Intersection.segmentsIntersectOrNear(s1, s2, pl0, pl1, near, check);
            if (ret != null) {
                if (list == null) {
                    list = new LinkedList<Geo>();
                }
                list.add(ret);
                check = new Geo();
            }
            pl0.initialize(pl1);
        }
        return list;
    }

    public static final boolean isPointNearPoly(Geo s, GeoArray r, double near) {
        int rlen = r.getSize();
        Geo pl0 = r.get(rlen - 1, new Geo());
        Geo pl1 = new Geo();
        for (int j = 0; j < rlen; ++j) {
            r.get(j, pl1);
            if (pl0.isInside(pl1, near, s)) {
                return true;
            }
            pl0.initialize(pl1);
        }
        return false;
    }

    public static final Geo isPolyNearPoly(GeoArray s, GeoArray r, double near) {
        int rlen = r.getSize();
        int slen = s.getSize();
        Geo pl0 = r.get(rlen - 1);
        Geo pl1 = new Geo();
        Geo sl0 = s.get(slen - 1);
        Geo sl1 = new Geo();
        for (int j = 0; j < rlen; ++j) {
            pl1 = r.get(j, pl1);
            for (int i = 0; i < slen; ++i) {
                Geo ret = Intersection.segmentsIntersectOrNear(sl0, sl1 = s.get(i, sl1), pl0, pl1, near);
                if (ret != null) {
                    return ret;
                }
                sl0 = sl1;
            }
            pl0 = pl1;
        }
        return null;
    }

    public static final List<Geo> polyNearPoly(GeoArray s, GeoArray r, double near) {
        int rlen = r.getSize();
        int slen = s.getSize();
        Geo pl0 = r.get(rlen - 1);
        Geo pl1 = new Geo();
        Geo sl0 = s.get(slen - 1);
        Geo sl1 = new Geo();
        LinkedList<Geo> list = null;
        for (int j = 0; j < rlen; ++j) {
            pl1 = r.get(j, pl1);
            for (int i = 0; i < slen; ++i) {
                Geo ret = Intersection.segmentsIntersectOrNear(sl0, sl1 = s.get(i, sl1), pl0, pl1, near);
                if (ret != null) {
                    if (list == null) {
                        list = new LinkedList<Geo>();
                    }
                    list.add(ret);
                }
                sl0 = sl1;
            }
            pl0 = pl1;
        }
        return list;
    }

    public static Geo segmentsIntersect(Geo a1, Geo a2, Geo b1, Geo b2) {
        return Intersection.segmentsIntersectOrNear(a1, a2, b1, b2, 0.0);
    }

    public static Geo segmentsIntersectOrNear(Geo a1, Geo a2, Geo b1, Geo b2, double r) {
        if (a1 == null || a2 == null || b1 == null || b2 == null) {
            return null;
        }
        Geo ac = a1.crossNormalize(a2);
        Geo bc = b1.crossNormalize(b2);
        double aL = a1.distance(a2) + r;
        double bL = b1.distance(b2) + r;
        Geo i = ac.crossNormalize(bc, bc);
        if (!(i.distance(a1) <= aL && i.distance(a2) <= aL || (i = i.antipode(i)).distance(a1) <= aL && i.distance(a2) <= aL)) {
            return null;
        }
        if (i.distance(b1) <= bL && i.distance(b2) <= bL) {
            return i;
        }
        return null;
    }

    public static Geo segmentsIntersectOrNear(Geo a1, Geo a2, Geo b1, Geo b2, double r, Geo ret) {
        if (a1 == null || a2 == null || b1 == null || b2 == null) {
            return null;
        }
        Geo ac = a1.crossNormalize(a2);
        Geo bc = b1.crossNormalize(b2, ret);
        double aL = a1.distance(a2) + r;
        double bL = b1.distance(b2) + r;
        Geo i = ac.crossNormalize(bc, bc);
        if (!(i.distance(a1) <= aL && i.distance(a2) <= aL || (i = i.antipode(ret)).distance(a1) <= aL && i.distance(a2) <= aL)) {
            return null;
        }
        if (i.distance(b1) <= bL && i.distance(b2) <= bL) {
            return i;
        }
        return null;
    }

    public static void main(String[] args) {
        double lat1 = 60.0;
        double lon1 = -130.0;
        double lat2 = 30.0;
        double lon2 = -70.0;
        double lat3 = 60.0;
        double lon3 = -70.0;
        double lat4 = 30.0;
        double lon4 = -130.0;
        double[] ll = Intersection.getSegIntersection(lat1, -lon1, lat2, -lon2, lat3, -lon3, lat4, -lon4);
        System.out.println("(1)=" + ll[0] + ", " + -ll[1]);
        System.out.println("(2)=" + ll[2] + ", " + -ll[3]);
        boolean b1 = Intersection.intersects(lat1, -lon1, lat2, -lon2, lat3, -lon3, lat4, -lon4);
        System.out.println("intersects=" + b1);
        double[] polypoints1 = new double[]{38.0, -27.0, -46.0, 165.0};
        double[] polypoints2 = new double[]{51.0, -42.0, 55.0, -17.0, 11.0, -23.0, 51.0, -42.0};
        boolean b2 = Intersection.polyIntersect(polypoints1, polypoints2);
        System.out.println("polyIntersect=" + b2);
    }
}

