/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Environment;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.event.CenterListener;
import com.bbn.openmap.event.CenterSupport;
import com.bbn.openmap.event.PanListener;
import com.bbn.openmap.event.PanSupport;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.event.ZoomListener;
import com.bbn.openmap.event.ZoomSupport;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphicConstants;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionStack;
import com.bbn.openmap.proj.ProjectionStackTrigger;
import com.bbn.openmap.tools.icon.IconPart;
import com.bbn.openmap.tools.icon.IconPartList;
import com.bbn.openmap.tools.icon.OMIconFactory;
import com.bbn.openmap.tools.icon.OpenMapAppPartCollection;
import com.bbn.openmap.util.PropUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;

public class EmbeddedNavPanel
extends OMComponentPanel
implements ProjectionListener,
ProjectionStackTrigger,
SoloMapComponent {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.gui.EmbeddedNavPanel");
    private static final long serialVersionUID = 1L;
    public static final int SLIDER_MAX = 17;
    public static final String FADE_ATTRIBUTES_PROPERTY = "fade";
    public static final String LIVE_ATTRIBUTES_PROPERTY = "live";
    public static final String PanDistanceProperty = "panDistance";
    public static final String ZoomFactorProperty = "zoomFactor";
    public static final int DEFAULT_BUTTON_SIZE = 15;
    protected static final float defaultPanDistance = Float.NaN;
    protected static final float defaultZoomFactor = 2.0f;
    protected static Color CONTROL_BACKGROUND = OMGraphicConstants.clear;
    protected DrawingAttributes fadeAttributes;
    protected DrawingAttributes liveAttributes;
    protected int buttonSize = 15;
    protected ImageIcon backIcon;
    protected ImageIcon backDimIcon;
    protected ImageIcon forwardIcon;
    protected ImageIcon forwardDimIcon;
    protected MapBean map;
    protected CenterSupport centerDelegate;
    protected PanSupport panDelegate;
    protected ZoomSupport zoomDelegate;
    protected JButton forwardProjectionButton;
    protected JButton backProjectionButton;
    protected JSlider slider;
    private float panDistance = Float.NaN;
    private float zoomFactor = 2.0f;
    protected float MIN_TRANSPARENCY = 0.25f;
    protected float SEMI_TRANSPARENCY = 0.65f;
    protected float MAX_TRANSPARENCY = 1.0f;
    protected boolean fade = false;
    protected Point2D recenterPoint;
    protected AlphaComposite ac = AlphaComposite.getInstance(10, this.MAX_TRANSPARENCY);

    public EmbeddedNavPanel() {
        this(null, null, 15);
    }

    public EmbeddedNavPanel(DrawingAttributes buttonColors, DrawingAttributes fadeColors, int buttonSize) {
        this.centerDelegate = new CenterSupport(this);
        this.panDelegate = new PanSupport(this);
        this.zoomDelegate = new ZoomSupport(this);
        this.setBackground(OMGraphicConstants.clear);
        this.setOpaque(false);
        this.initColors(buttonColors, fadeColors, buttonSize);
        float lat = Environment.getFloat("openmap.Latitude", 0.0f);
        float lon = Environment.getFloat("openmap.Longitude", 0.0f);
        this.setRecenterPoint(new Point2D.Float(lon, lat));
        this.layoutPanel();
    }

    protected void initColors(DrawingAttributes buttonColors, DrawingAttributes fadeColors, int buttonSize) {
        this.fadeAttributes = fadeColors;
        this.liveAttributes = buttonColors;
        if (buttonSize >= 10) {
            this.buttonSize = buttonSize;
        }
        if (this.fadeAttributes == null) {
            this.fadeAttributes = DrawingAttributes.getDefaultClone();
            Color fadeColor = new Color(-5592406);
            this.fadeAttributes.setFillPaint(fadeColor);
            this.fadeAttributes.setLinePaint(fadeColor.darker());
        }
        if (buttonColors == null) {
            this.liveAttributes = DrawingAttributes.getDefaultClone();
            Color liveColor = new Color(-571214861);
            this.liveAttributes.setFillPaint(liveColor);
            this.liveAttributes.setMattingPaint(liveColor);
            this.liveAttributes.setMatted(true);
        }
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.fadeAttributes.setProperties(prefix + FADE_ATTRIBUTES_PROPERTY, props);
        this.liveAttributes.setProperties(prefix + LIVE_ATTRIBUTES_PROPERTY, props);
        this.panDistance = PropUtils.floatFromProperties(props, prefix + PanDistanceProperty, Float.NaN);
        this.zoomFactor = PropUtils.floatFromProperties(props, prefix + ZoomFactorProperty, 2.0f);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        this.fadeAttributes.getProperties(props);
        this.liveAttributes.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + PanDistanceProperty, String.valueOf(this.panDistance));
        props.put(prefix + ZoomFactorProperty, String.valueOf(this.zoomFactor));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        props.put("initProperties", "panDistance zoomFactor");
        String interString = this.i18n.get(EmbeddedNavPanel.class, PanDistanceProperty, 3, "Panning Distance.");
        props.put(PanDistanceProperty, interString);
        interString = this.i18n.get(EmbeddedNavPanel.class, PanDistanceProperty, "Panning Distance");
        props.put("panDistance.label", interString);
        props.put("panDistance.editor", "com.bbn.openmap.util.propertyEditor.TextPropertyEditor");
        interString = this.i18n.get(EmbeddedNavPanel.class, ZoomFactorProperty, 3, "Zoom Factor.");
        props.put(ZoomFactorProperty, interString);
        interString = this.i18n.get(EmbeddedNavPanel.class, ZoomFactorProperty, "Zoom Factor");
        props.put("zoomFactor.label", interString);
        props.put("zoomFactor.editor", "com.bbn.openmap.util.propertyEditor.TextPropertyEditor");
        return props;
    }

    protected void layoutPanel() {
        this.removeAll();
        int projStackButtonSize = (int)((double)this.buttonSize * 1.25);
        int rosetteButtonSize = this.buttonSize;
        int zoomButtonSize = this.buttonSize;
        this.setLayout(new GridBagLayout());
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        int baseY = 0;
        IconPart bigArrow = OpenMapAppPartCollection.BIG_ARROW.getIconPart();
        bigArrow.setRenderingAttributes(this.fadeAttributes);
        this.backDimIcon = OMIconFactory.getIcon(projStackButtonSize, projStackButtonSize, bigArrow, null, Length.DECIMAL_DEGREE.toRadians(270.0));
        bigArrow.setRenderingAttributes(this.liveAttributes);
        this.backIcon = OMIconFactory.getIcon(projStackButtonSize, projStackButtonSize, bigArrow, null, Length.DECIMAL_DEGREE.toRadians(270.0));
        this.backProjectionButton = this.makeButton(this.backDimIcon, "Show Previous Projection");
        this.backProjectionButton.setActionCommand("backProjection");
        bigArrow.setRenderingAttributes(this.fadeAttributes);
        this.forwardDimIcon = OMIconFactory.getIcon(projStackButtonSize, projStackButtonSize, bigArrow, null, Length.DECIMAL_DEGREE.toRadians(90.0));
        bigArrow.setRenderingAttributes(this.liveAttributes);
        this.forwardIcon = OMIconFactory.getIcon(projStackButtonSize, projStackButtonSize, bigArrow, null, Length.DECIMAL_DEGREE.toRadians(90.0));
        this.forwardProjectionButton = this.makeButton(this.forwardDimIcon, "Show Next Projection");
        this.forwardProjectionButton.setActionCommand("forwardProjection");
        JPanel projStackButtonPanel = new JPanel();
        projStackButtonPanel.setOpaque(false);
        projStackButtonPanel.setBackground(CONTROL_BACKGROUND);
        projStackButtonPanel.add(this.backProjectionButton);
        projStackButtonPanel.add(this.forwardProjectionButton);
        layoutConstraints.anchor = 10;
        layoutConstraints.gridwidth = 0;
        layoutConstraints.gridy = baseY++;
        this.add((Component)projStackButtonPanel, layoutConstraints);
        JPanel rosette = new JPanel();
        GridBagLayout internalGridbag = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        rosette.setLayout(internalGridbag);
        rosette.setOpaque(false);
        rosette.setBackground(CONTROL_BACKGROUND);
        c2.gridx = 0;
        c2.gridy = 0;
        rosette.add((Component)this.makeButton(OpenMapAppPartCollection.OPP_CORNER_TRI.getIconPart(), this.liveAttributes, rosetteButtonSize, 0.0, "Pan Northwest", new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EmbeddedNavPanel.this.panDelegate.firePan(-45.0f, EmbeddedNavPanel.this.panDistance);
            }
        }), c2);
        c2.gridx = 1;
        rosette.add(this.makeButton(OpenMapAppPartCollection.MED_ARROW.getIconPart(), this.liveAttributes, rosetteButtonSize, 0.0, "Pan North", new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EmbeddedNavPanel.this.panDelegate.firePan(0.0f, EmbeddedNavPanel.this.panDistance);
            }
        }));
        c2.gridx = 2;
        rosette.add((Component)this.makeButton(OpenMapAppPartCollection.OPP_CORNER_TRI.getIconPart(), this.liveAttributes, rosetteButtonSize, 90.0, "Pan Northeast", new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EmbeddedNavPanel.this.panDelegate.firePan(45.0f, EmbeddedNavPanel.this.panDistance);
            }
        }), c2);
        c2.gridx = 0;
        c2.gridy = 1;
        rosette.add((Component)this.makeButton(OpenMapAppPartCollection.MED_ARROW.getIconPart(), this.liveAttributes, rosetteButtonSize, 270.0, "Pan West", new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EmbeddedNavPanel.this.panDelegate.firePan(-90.0f, EmbeddedNavPanel.this.panDistance);
            }
        }), c2);
        c2.gridx = 1;
        IconPartList ipl = new IconPartList();
        ipl.add(OpenMapAppPartCollection.CIRCLE.getIconPart());
        ipl.add(OpenMapAppPartCollection.DOT.getIconPart());
        rosette.add((Component)this.makeButton(ipl, this.liveAttributes, rosetteButtonSize, 0.0, "Center Map", new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Point2D centerPnt = EmbeddedNavPanel.this.getRecenterPoint();
                if (centerPnt == null) {
                    EmbeddedNavPanel.this.centerDelegate.fireCenter(0.0, 0.0);
                } else {
                    EmbeddedNavPanel.this.centerDelegate.fireCenter(centerPnt.getY(), centerPnt.getX());
                }
            }
        }), c2);
        c2.gridx = 2;
        rosette.add((Component)this.makeButton(OpenMapAppPartCollection.MED_ARROW.getIconPart(), this.liveAttributes, rosetteButtonSize, 90.0, "Pan East", new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EmbeddedNavPanel.this.panDelegate.firePan(90.0f, EmbeddedNavPanel.this.panDistance);
            }
        }), c2);
        c2.gridx = 0;
        c2.gridy = 2;
        rosette.add((Component)this.makeButton(OpenMapAppPartCollection.OPP_CORNER_TRI.getIconPart(), this.liveAttributes, rosetteButtonSize, 270.0, "Pan Southwest", new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EmbeddedNavPanel.this.panDelegate.firePan(-135.0f, EmbeddedNavPanel.this.panDistance);
            }
        }), c2);
        c2.gridx = 1;
        rosette.add((Component)this.makeButton(OpenMapAppPartCollection.MED_ARROW.getIconPart(), this.liveAttributes, rosetteButtonSize, 180.0, "Pan South", new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EmbeddedNavPanel.this.panDelegate.firePan(180.0f, EmbeddedNavPanel.this.panDistance);
            }
        }), c2);
        c2.gridx = 2;
        rosette.add((Component)this.makeButton(OpenMapAppPartCollection.OPP_CORNER_TRI.getIconPart(), this.liveAttributes, rosetteButtonSize, 180.0, "Pan Southeast", new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EmbeddedNavPanel.this.panDelegate.firePan(135.0f, EmbeddedNavPanel.this.panDistance);
            }
        }), c2);
        layoutConstraints.gridy = baseY++;
        this.add((Component)rosette, layoutConstraints);
        layoutConstraints.gridy = baseY++;
        layoutConstraints.insets = new Insets(6, 0, 6, 0);
        ipl = new IconPartList();
        ipl.add(OpenMapAppPartCollection.PLUS.getIconPart());
        this.add((Component)this.makeButton(ipl, this.liveAttributes, zoomButtonSize, 0.0, "Zoom In", new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EmbeddedNavPanel.this.zoomDelegate.fireZoom(301, 1.0f / EmbeddedNavPanel.this.zoomFactor);
            }
        }), layoutConstraints);
        layoutConstraints.gridy = baseY++;
        layoutConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.makeScaleSlider(this.liveAttributes), layoutConstraints);
        layoutConstraints.gridy = baseY++;
        layoutConstraints.insets = new Insets(6, 0, 6, 0);
        ipl = new IconPartList();
        ipl.add(OpenMapAppPartCollection.MINUS.getIconPart());
        this.add((Component)this.makeButton(ipl, this.liveAttributes, zoomButtonSize, 0.0, "Zoom Out", new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                EmbeddedNavPanel.this.zoomDelegate.fireZoom(301, EmbeddedNavPanel.this.zoomFactor);
            }
        }), layoutConstraints);
        layoutConstraints.fill = 3;
        layoutConstraints.gridy = baseY++;
        layoutConstraints.weighty = 1.0;
        JPanel filler = new JPanel();
        filler.setOpaque(false);
        filler.setBackground(OMGraphicConstants.clear);
        this.add((Component)filler, layoutConstraints);
        this.setMinimumSize(new Dimension(75, projStackButtonSize + 3 * rosetteButtonSize + 2 * zoomButtonSize + 24 + 200));
    }

    public Point2D getRecenterPoint() {
        return this.recenterPoint;
    }

    public void setRecenterPoint(Point2D recenterPoint) {
        this.recenterPoint = recenterPoint;
    }

    public float getPanDistance() {
        return this.panDistance;
    }

    public void setPanDistance(float panDistance) {
        this.panDistance = panDistance;
    }

    public float getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(float zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    protected JButton makeButton(IconPart iconPart, DrawingAttributes da, int size, double ddRot, String tooltip, ActionListener ac) {
        iconPart.setRenderingAttributes(da);
        return this.makeButton(OMIconFactory.getIcon(size, size, iconPart, null, Length.DECIMAL_DEGREE.toRadians(ddRot)), tooltip, ac);
    }

    protected JButton makeButton(ImageIcon icon, String toolTip, ActionListener listener) {
        JButton button = this.makeButton(icon, toolTip);
        button.addActionListener(listener);
        button.setFocusable(false);
        button.addMouseListener(new NavPanelMouseListener());
        return button;
    }

    protected JButton makeButton(ImageIcon icon, String toolTip) {
        JButton button = new JButton(icon);
        button.setBackground(CONTROL_BACKGROUND);
        button.setBorder(null);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setOpaque(false);
        button.setBorderPainted(false);
        button.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        button.setToolTipText(toolTip);
        button.setFocusable(false);
        button.addMouseListener(new NavPanelMouseListener());
        return button;
    }

    protected JComponent makeScaleSlider(DrawingAttributes da) {
        this.slider = new JSlider(1, 0, 17, 17);
        this.slider.setUI(new NavPanelSliderUI(this.slider, (Color)da.getFillPaint()));
        this.slider.setBackground((Color)da.getFillPaint());
        this.slider.setBorder(BorderFactory.createLineBorder((Color)da.getFillPaint(), 1));
        this.slider.setForeground((Color)da.getFillPaint());
        this.slider.setInverted(true);
        this.slider.setMinorTickSpacing(1);
        this.slider.setOpaque(false);
        this.slider.setPaintTicks(true);
        this.slider.setSnapToTicks(true);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                if (EmbeddedNavPanel.this.slider.getValueIsAdjusting()) {
                    EmbeddedNavPanel.this.changeMapScale(EmbeddedNavPanel.this.slider.getValue());
                }
            }
        });
        this.slider.setFocusable(false);
        this.slider.addMouseListener(new NavPanelMouseListener());
        return this.slider;
    }

    protected void changeMapScale(int sliderValue) {
        float newScale = this.sliderToScale(sliderValue);
        if (this.map.getScale() != newScale) {
            this.map.setScale(newScale);
        }
    }

    protected void changeSliderValue(Projection projection) {
        int newValue = this.scaleToSlider(projection.getScale());
        if (this.slider.getValue() != newValue) {
            this.slider.setValue(newValue);
        }
    }

    protected float sliderToScale(int sliderValue) {
        return (float)((double)this.getMapMaxScale() / Math.pow(2.0, 17 - sliderValue));
    }

    protected int scaleToSlider(float mapScale) {
        return 17 - EmbeddedNavPanel.logBase2(this.getMapMaxScale() / mapScale);
    }

    public static final int logBase2(double number) {
        int log = 0;
        while (number > 1.0) {
            number = Math.floor(number / 2.0);
            ++log;
        }
        return log;
    }

    public Color getScaleSliderBackground() {
        return this.slider.getBackground();
    }

    public void setScaleSliderBackground(Color sliderBackground) {
        this.slider.setBackground(sliderBackground);
    }

    public Color getScaleSliderForeground() {
        return this.slider.getForeground();
    }

    public void setScaleSliderForeground(Color sliderForeground) {
        this.slider.setForeground(sliderForeground);
    }

    private final float getMapMaxScale() {
        return this.map.getProjection().getMaxScale();
    }

    public void findAndInit(Object someObject) {
        if (someObject instanceof MapBean) {
            this.map = (MapBean)someObject;
            this.map.addProjectionListener(this);
        }
        if (someObject instanceof PanListener) {
            this.addPanListener((PanListener)someObject);
        }
        if (someObject instanceof CenterListener) {
            this.addCenterListener((CenterListener)someObject);
        }
        if (someObject instanceof ZoomListener) {
            this.addZoomListener((ZoomListener)someObject);
        }
        if (someObject instanceof ProjectionStack) {
            ((ProjectionStack)someObject).addProjectionStackTrigger(this);
        }
    }

    public void findAndUndo(Object someObject) {
        if (someObject instanceof MapBean) {
            this.map.removeProjectionListener(this);
        }
        if (someObject instanceof PanListener) {
            this.removePanListener((PanListener)someObject);
        }
        if (someObject instanceof CenterListener) {
            this.removeCenterListener((CenterListener)someObject);
        }
        if (someObject instanceof ZoomListener) {
            this.removeZoomListener((ZoomListener)someObject);
        }
        if (someObject instanceof ProjectionStack) {
            ((ProjectionStack)someObject).removeProjectionStackTrigger(this);
        }
    }

    public synchronized void addCenterListener(CenterListener listener) {
        this.centerDelegate.add(listener);
    }

    public synchronized void removeCenterListener(CenterListener listener) {
        this.centerDelegate.remove(listener);
    }

    public synchronized void addPanListener(PanListener listener) {
        this.panDelegate.add(listener);
    }

    public synchronized void removePanListener(PanListener listener) {
        this.panDelegate.remove(listener);
    }

    public synchronized void addZoomListener(ZoomListener listener) {
        this.zoomDelegate.add(listener);
    }

    public synchronized void removeZoomListener(ZoomListener listener) {
        this.zoomDelegate.remove(listener);
    }

    public void projectionChanged(ProjectionEvent event) {
        this.changeSliderValue(event.getProjection());
    }

    public void addActionListener(ActionListener listener) {
        this.forwardProjectionButton.addActionListener(listener);
        this.backProjectionButton.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.forwardProjectionButton.addActionListener(listener);
        this.backProjectionButton.addActionListener(listener);
    }

    public void updateProjectionStackStatus(boolean haveBackProjections, boolean haveForwardProjections) {
        this.forwardProjectionButton.setIcon(haveForwardProjections ? this.forwardIcon : this.forwardDimIcon);
        this.backProjectionButton.setIcon(haveBackProjections ? this.backIcon : this.backDimIcon);
        this.forwardProjectionButton.setEnabled(haveForwardProjections);
        this.backProjectionButton.setEnabled(haveBackProjections);
    }

    public void paint(Graphics g) {
        if (this.ac != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setComposite(this.ac);
            super.paint(g2);
            g2.dispose();
        } else {
            super.paint(g);
        }
    }

    public void setTransparency(float transparency) {
        if (this.ac != null) {
            if (transparency > this.MAX_TRANSPARENCY) {
                transparency = this.MAX_TRANSPARENCY;
            }
            this.ac = AlphaComposite.getInstance(10, transparency);
            this.repaint();
        }
    }

    public void setMinimumTransparency(float minTransparency) {
        this.MIN_TRANSPARENCY = minTransparency;
    }

    public void setSemiTransparency(float semiTransparency) {
        this.SEMI_TRANSPARENCY = semiTransparency;
    }

    public DrawingAttributes getFadeAttributes() {
        return this.fadeAttributes;
    }

    public void setFadeAttributes(DrawingAttributes fadeAttributes) {
        this.fadeAttributes = fadeAttributes;
    }

    public DrawingAttributes getLiveAttributes() {
        return this.liveAttributes;
    }

    public void setLiveAttributes(DrawingAttributes liveAttributes) {
        this.liveAttributes = liveAttributes;
    }

    public AlphaComposite getAc() {
        return this.ac;
    }

    public void setAc(AlphaComposite ac) {
        this.ac = ac;
    }

    public MapBean getMap() {
        return this.map;
    }

    private class NavPanelMouseListener
    extends MouseAdapter {
        private NavPanelMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            if (EmbeddedNavPanel.this.ac.getAlpha() < EmbeddedNavPanel.this.SEMI_TRANSPARENCY) {
                EmbeddedNavPanel.this.setTransparency(EmbeddedNavPanel.this.SEMI_TRANSPARENCY);
                EmbeddedNavPanel.this.getTopLevelAncestor().repaint();
            }
        }

        public void mouseExited(MouseEvent e) {
            if (EmbeddedNavPanel.this.ac.getAlpha() > EmbeddedNavPanel.this.MIN_TRANSPARENCY) {
                EmbeddedNavPanel.this.setTransparency(EmbeddedNavPanel.this.MIN_TRANSPARENCY);
                EmbeddedNavPanel.this.getTopLevelAncestor().repaint();
            }
        }
    }

    private class NavPanelSliderUI
    extends BasicSliderUI {
        Color sliderTickColor;

        public NavPanelSliderUI(JSlider slider, Color tickColor) {
            super(slider);
            this.sliderTickColor = Color.white;
            this.sliderTickColor = tickColor;
        }

        protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
            g.setColor(this.sliderTickColor);
            super.paintMinorTickForVertSlider(g, tickBounds, y);
        }
    }
}

