/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.gui.MapPanelChild;
import com.bbn.openmap.gui.Tool;
import com.bbn.openmap.gui.menu.ToolPanelToggleMenuItem;
import com.bbn.openmap.util.PropUtils;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolPanel
extends JToolBar
implements BeanContextChild,
BeanContextMembershipListener,
MapPanelChild,
PropertyConsumer,
ComponentListener {
    private static Logger logger = Logger.getLogger(ToolPanel.class.getName());
    private static final long serialVersionUID = 1L;
    protected Hashtable<String, Tool> items = new Hashtable();
    protected boolean autoSpace = false;
    private BeanContextChildSupport beanContextChildSupport = new BeanContextChildSupport(this);
    protected String propertyPrefix = null;
    public static final String ComponentsProperty = "components";
    public static final String AvoidComponentsProperty = "avoid";
    public static final String MembershipProperty = "membership";
    public static final String NameProperty = "name";
    protected List<String> componentList = null;
    protected List<String> avoidList = null;
    protected GridBagLayout gridbag = new GridBagLayout();
    protected GridBagConstraints c = new GridBagConstraints();
    protected String parentName = null;
    protected JLabel filler = null;
    protected boolean[] usedIndexes;
    public int MAX_INDEXES = 101;
    protected String preferredLocation = "North";

    public ToolPanel() {
        this.setLayout(this.gridbag);
        this.setFloatable(false);
        this.setVisible(false);
        this.setName("Tool Panel");
    }

    public void add(String key, Tool item) {
        this.add(key, item, -1);
    }

    protected int getNextAvailableIndex() {
        return this.getNextAvailableIndex(0);
    }

    protected int getNextAvailableIndex(int startAt) {
        int i;
        if (this.usedIndexes == null) {
            this.usedIndexes = new boolean[this.MAX_INDEXES];
        }
        if (startAt < 0) {
            startAt = 0;
        }
        if (startAt >= this.MAX_INDEXES) {
            startAt = this.MAX_INDEXES - 1;
        }
        for (i = startAt; i < this.MAX_INDEXES && this.usedIndexes[i]; ++i) {
        }
        this.usedIndexes[i] = true;
        return i;
    }

    public void add(String key, Tool item, int index) {
        int orientation = this.getOrientation();
        boolean hOrient = orientation == 0;
        item.setOrientation(orientation);
        Container face = item.getFace();
        if (face != null) {
            face.addComponentListener(this);
            this.items.put(key.intern(), item);
            if (this.autoSpace) {
                index *= 2;
            }
            if (hOrient) {
                this.c.weightx = 0.0;
                this.c.gridx = this.getNextAvailableIndex(index);
                this.c.gridy = 0;
                this.c.anchor = 17;
            } else {
                this.c.weighty = 0.0;
                this.c.gridx = 0;
                this.c.gridy = this.getNextAvailableIndex(index);
                this.c.anchor = 11;
            }
            this.gridbag.setConstraints(face, this.c);
            this.add(face);
            if (this.filler == null) {
                if (hOrient) {
                    this.c.gridx = this.getNextAvailableIndex(this.MAX_INDEXES);
                    this.c.anchor = 13;
                    this.c.weightx = 1.0;
                } else {
                    this.c.gridy = this.getNextAvailableIndex(this.MAX_INDEXES);
                    this.c.anchor = 15;
                    this.c.weighty = 1.0;
                }
                this.filler = new JLabel("");
                this.gridbag.setConstraints(this.filler, this.c);
                this.add(this.filler);
            }
            if (this.autoSpace) {
                JLabel l = new JLabel(" ");
                this.gridbag.setConstraints(l, this.c);
                this.add(l);
            }
        }
        this.setVisibility();
        this.firePropertyChange(MembershipProperty, null, this.items);
    }

    public void add(Tool item) {
        this.add(item, -1);
    }

    public void add(Tool item, int index) {
        try {
            this.add(item.getKey(), item, index);
        }
        catch (NullPointerException npe) {
            if (item != null) {
                logger.warning("ToolPanel.add(): no name for " + item.getClass().getName());
                npe.printStackTrace();
            }
            logger.warning("ToolPanel.add(): no name for null tool.");
        }
    }

    public Tool get(String key) {
        return this.items.get(key.intern());
    }

    public void remove(String key) {
        Tool tool = this.items.remove(key.intern());
        if (tool != null) {
            this.remove(tool.getFace());
            tool.getFace().removeComponentListener(this);
            this.firePropertyChange(MembershipProperty, null, this.items);
        }
    }

    protected void addSpace() {
        this.add(new JLabel(" "));
    }

    public void setAutoSpace(boolean set) {
        this.autoSpace = set;
    }

    @Override
    public void setPreferredLocation(String value) {
        this.preferredLocation = value;
    }

    @Override
    public String getPreferredLocation() {
        return this.preferredLocation;
    }

    public boolean isAutoSpace() {
        return this.autoSpace;
    }

    public void setComponentList(List<String> list) {
        this.componentList = list;
    }

    public List<String> getComponentList() {
        return this.componentList;
    }

    public void setAvoidList(List<String> list) {
        this.avoidList = list;
    }

    public List<String> getAvoidList() {
        return this.avoidList;
    }

    public void findAndInit(Iterator<Object> it) {
        while (it.hasNext()) {
            this.findAndInit(it.next());
        }
    }

    protected int keyOnList(String key, List<String> list) {
        int ret = -1;
        int index = 0;
        if (list != null) {
            for (String listKey : list) {
                if (listKey.equalsIgnoreCase(key)) {
                    ret = index;
                    break;
                }
                ++index;
            }
        }
        return ret;
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof Tool) {
            String key = ((Tool)someObj).getKey();
            List<String> list = this.getComponentList();
            if (list != null) {
                int index = this.keyOnList(key, list);
                if (index >= 0) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "ToolPanel: found a tool Object {0} for placement at {1}", new Object[]{key, index});
                    }
                    this.add((Tool)someObj, index);
                }
            } else {
                int index = this.keyOnList(key, this.getAvoidList());
                if (index < 0) {
                    logger.fine("ToolPanel: found a tool Object");
                    this.add((Tool)someObj);
                }
            }
        }
    }

    public ToolPanelToggleMenuItem getToggleMenu() {
        return new ToolPanelToggleMenuItem(this);
    }

    public boolean checkToolPanelToggleMenuItem(ToolPanelToggleMenuItem mi) {
        return mi != null && mi.getToolPanel().equals(this);
    }

    @Override
    public void childrenAdded(BeanContextMembershipEvent bcme) {
        this.findAndInit(bcme.iterator());
    }

    @Override
    public void childrenRemoved(BeanContextMembershipEvent bcme) {
        Iterator it = bcme.iterator();
        while (it.hasNext()) {
            Object someObj = it.next();
            if (!(someObj instanceof Tool)) continue;
            logger.fine("ToolPanel removing tool Object");
            this.remove(((Tool)someObj).getKey());
        }
    }

    @Override
    public BeanContext getBeanContext() {
        return this.beanContextChildSupport.getBeanContext();
    }

    @Override
    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            in_bc.addBeanContextMembershipListener(this);
            this.beanContextChildSupport.setBeanContext(in_bc);
            this.findAndInit(in_bc.iterator());
        }
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener in_pcl) {
        this.beanContextChildSupport.addPropertyChangeListener(propertyName, in_pcl);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener in_pcl) {
        this.beanContextChildSupport.removePropertyChangeListener(propertyName, in_pcl);
    }

    @Override
    public void addVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.addVetoableChangeListener(propertyName, in_vcl);
    }

    @Override
    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.removeVetoableChangeListener(propertyName, in_vcl);
    }

    @Override
    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    @Override
    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    @Override
    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        String preferredLocationString;
        String avoidComponentsString;
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String componentsString = props.getProperty(prefix + ComponentsProperty);
        if (componentsString != null) {
            this.setComponentList(PropUtils.parseSpacedMarkers(componentsString));
        }
        if ((avoidComponentsString = props.getProperty(prefix + AvoidComponentsProperty)) != null) {
            this.setAvoidList(PropUtils.parseSpacedMarkers(avoidComponentsString));
        }
        if ((preferredLocationString = props.getProperty(prefix + "preferredLocation")) != null) {
            try {
                preferredLocationString = (String)BorderLayout.class.getField(preferredLocationString).get(null);
            }
            catch (NoSuchFieldException nsfe) {
                preferredLocationString = null;
            }
            catch (IllegalAccessException iae) {
                preferredLocationString = null;
            }
            if (preferredLocationString != null) {
                this.setPreferredLocation(preferredLocationString);
                if (preferredLocationString.equalsIgnoreCase("WEST") || preferredLocationString.equalsIgnoreCase("EAST")) {
                    this.setOrientation(1);
                }
            }
        }
        this.setName(props.getProperty(prefix + NameProperty, this.getName()));
        this.setParentName(props.getProperty(prefix + "parent", this.getParentName()));
    }

    protected StringBuffer rebuildListProperty(List<String> aList) {
        StringBuffer list = null;
        if (aList != null) {
            list = new StringBuffer();
            for (String toolKey : aList) {
                list.append(toolKey).append(" ");
            }
        }
        return list;
    }

    @Override
    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        StringBuffer listProp = this.rebuildListProperty(this.getComponentList());
        if (listProp != null) {
            props.put(prefix + ComponentsProperty, listProp.toString());
        }
        if ((listProp = this.rebuildListProperty(this.getAvoidList())) != null) {
            props.put(prefix + AvoidComponentsProperty, listProp.toString());
        }
        PropUtils.putIfNotDefault(props, prefix + "preferredLocation", this.getPreferredLocation());
        PropUtils.putIfNotDefault(props, prefix + NameProperty, this.getName());
        PropUtils.putIfNotDefault(props, prefix + "parent", this.getParentName());
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        I18n i18n = Environment.getI18n();
        PropUtils.setI18NPropertyInfo(i18n, props, ToolPanel.class, ComponentsProperty, "Tool Names", "List of Names of Tools to Add", null);
        PropUtils.setI18NPropertyInfo(i18n, props, ToolPanel.class, AvoidComponentsProperty, "Avoid Tool Names", "List of Names of Tools to Not Add", null);
        PropUtils.setI18NPropertyInfo(i18n, props, ToolPanel.class, "preferredLocation", "Location", "Preferred Location of Tool Panel", null);
        PropUtils.setI18NPropertyInfo(i18n, props, ToolPanel.class, NameProperty, "Tool Name", "Name of This Tool Panel", null);
        return props;
    }

    protected void setVisibility() {
        this.setVisible(this.areComponentsVisible());
    }

    public boolean areComponentsVisible() {
        Enumeration<Tool> enumeration = this.items.elements();
        while (enumeration.hasMoreElements()) {
            Tool tool = enumeration.nextElement();
            Container face = tool.getFace();
            if (this.filler.equals(tool) || face == null || !face.isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void componentHidden(ComponentEvent ce) {
        this.setVisibility();
    }

    @Override
    public void componentMoved(ComponentEvent ce) {
    }

    @Override
    public void componentResized(ComponentEvent ce) {
    }

    @Override
    public void componentShown(ComponentEvent ce) {
        this.setVisibility();
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }
}

