/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.event.ZoomListener;
import com.bbn.openmap.event.ZoomSupport;
import com.bbn.openmap.gui.OMToolComponent;
import com.bbn.openmap.util.Debug;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ZoomPanel
extends OMToolComponent
implements ActionListener,
Serializable {
    public static final transient String zoomInCmd = "zoomin";
    public static final transient String zoomOutCmd = "zoomout";
    protected transient JButton zoomInButton;
    protected transient JButton zoomOutButton;
    protected transient ZoomSupport zoomDelegate;
    public static final String defaultKey = "zoompanel";
    protected transient float zoomInFactor = 0.5f;
    protected transient float zoomOutFactor = 2.0f;

    public ZoomPanel() {
        this.setKey(defaultKey);
        this.setOpaque(false);
        JPanel panel = new JPanel();
        GridBagLayout internalGridbag = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        panel.setLayout(internalGridbag);
        this.zoomDelegate = new ZoomSupport(this);
        this.zoomInButton = this.getButton("zoomIn", "Zoom In", zoomInCmd);
        c2.gridx = 0;
        c2.gridy = 0;
        internalGridbag.setConstraints(this.zoomInButton, c2);
        panel.add(this.zoomInButton);
        this.zoomOutButton = this.getButton("zoomOut", "Zoom Out", zoomOutCmd);
        c2.gridy = 1;
        internalGridbag.setConstraints(this.zoomOutButton, c2);
        panel.add(this.zoomOutButton);
        this.add(panel);
    }

    public float getZoomInFactor() {
        return this.zoomInFactor;
    }

    public void setZoomInFactor(float factor) {
        if (!(factor < 1.0f)) {
            throw new IllegalArgumentException("Zoom In factor too large (must be < 1.0)");
        }
        this.zoomInFactor = factor;
        this.zoomInButton.setToolTipText(this.i18n.get(ZoomPanel.class, "zoominfactor", 3, "zoom in X" + this.zoomInFactor, (Object)new Float(this.zoomInFactor)));
    }

    public float getZoomOutFactor() {
        return this.zoomOutFactor;
    }

    public void setZoomOutFactor(float factor) {
        if (!(factor > 1.0f)) {
            throw new IllegalArgumentException("Zoom In factor too small (must be > 1.0)");
        }
        this.zoomOutFactor = factor;
        this.zoomOutButton.setToolTipText(this.i18n.get(ZoomPanel.class, "zoomoutfactor", 3, "zoom out X" + this.zoomOutFactor, (Object)new Float(this.zoomOutFactor)));
    }

    protected JButton getButton(String name, String info, String command) {
        URL url = ZoomPanel.class.getResource(name + ".gif");
        ImageIcon icon = new ImageIcon(url, info);
        JButton b = new JButton(icon);
        b.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        b.setToolTipText(this.i18n.get(ZoomPanel.class, command, 3, info));
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setActionCommand(command);
        b.addActionListener(this);
        b.setBorderPainted(Debug.debugging("layout"));
        b.setOpaque(false);
        return b;
    }

    public synchronized void addZoomListener(ZoomListener listener) {
        this.zoomDelegate.add(listener);
    }

    public synchronized void removeZoomListener(ZoomListener listener) {
        this.zoomDelegate.remove(listener);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(zoomInCmd)) {
            this.zoomDelegate.fireZoom(301, this.zoomInFactor);
        } else if (command.equals(zoomOutCmd)) {
            this.zoomDelegate.fireZoom(301, this.zoomOutFactor);
        }
    }

    public void setOpaque(boolean set) {
        super.setOpaque(set);
        if (this.zoomInButton != null) {
            this.zoomInButton.setOpaque(set);
        }
        if (this.zoomOutButton != null) {
            this.zoomOutButton.setOpaque(set);
        }
    }

    public void findAndInit(Object obj) {
        if (obj instanceof ZoomListener) {
            this.addZoomListener((ZoomListener)obj);
        }
    }

    public void findAndUndo(Object obj) {
        if (obj instanceof ZoomListener) {
            this.removeZoomListener((ZoomListener)obj);
        }
    }
}

