/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.dock;

import com.bbn.openmap.gui.dock.BasicDockPanel;
import com.bbn.openmap.gui.dock.DockWrapper;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;

public class DockLayout
implements LayoutManager2 {
    private BasicDockPanel p;
    protected Rectangle occludingBounds;
    protected Rectangle backgroundBounds;

    public DockLayout(BasicDockPanel p) {
        this.p = p;
    }

    protected int getHeightAtLeftCardinal(DockWrapper dw) {
        return this.getHeightAtLeft(dw) - this.p.getOverlapTolerance();
    }

    protected int getHeightAtRightCardinal(DockWrapper dw) {
        return this.getHeightAtRight(dw) - this.p.getOverlapTolerance();
    }

    protected int getWidthAtYCardinal(DockWrapper dw, int y) {
        return this.getWidthAtY(dw, y) - this.p.getOverlapTolerance();
    }

    protected int getHeightAtLeft(DockWrapper dw) {
        int ret = dw.getPreferredSize().height;
        List l = dw.getDockedWrappers();
        if (!l.isEmpty()) {
            ret += this.getHeightAtLeft((DockWrapper)l.get(0));
        }
        return ret;
    }

    protected int getHeightAtRight(DockWrapper dw) {
        int ret = dw.getPreferredSize().height;
        List l = dw.getDockedWrappers();
        if (!l.isEmpty()) {
            ret += this.getHeightAtRight((DockWrapper)l.get(l.size() - 1));
        }
        return ret;
    }

    protected int getWidthAtY(DockWrapper dw, int y) {
        Rectangle bounds = dw.getBounds();
        int ret = 0;
        if (bounds.y <= y && bounds.y + bounds.height >= y) {
            ret = bounds.width;
        }
        for (DockWrapper c : dw.getDockedWrappers()) {
            ret += this.getWidthAtY(c, y);
        }
        return ret;
    }

    protected void layoutContainer() {
        Rectangle inBounds = this.p.getBounds();
        Insets insets = this.p.getInsets();
        inBounds.x += insets.left;
        inBounds.width -= insets.left;
        inBounds.width -= insets.right;
        inBounds.y += insets.top;
        inBounds.height -= insets.top;
        inBounds.height -= insets.bottom;
        this.backgroundBounds = (Rectangle)inBounds.clone();
        this.occludingBounds = (Rectangle)inBounds.clone();
        this.layoutCardinals();
        this.layoutEast(this.p.getEast(), this.occludingBounds.x + this.occludingBounds.width, this.occludingBounds.y, this.occludingBounds.width, this.occludingBounds.height);
        this.layoutWest(this.p.getWest(), this.occludingBounds.x, this.occludingBounds.y, this.occludingBounds.width, this.occludingBounds.height);
        int southLeft = inBounds.x + this.getWidthAtYCardinal(this.p.getWest(), inBounds.y + inBounds.height - this.getHeightAtLeftCardinal(this.p.getSouth()));
        int southRight = inBounds.x + inBounds.width - this.getWidthAtYCardinal(this.p.getEast(), inBounds.y + inBounds.height - this.getHeightAtRightCardinal(this.p.getSouth()));
        this.layoutSouth(this.p.getSouth(), southLeft, this.occludingBounds.y + this.occludingBounds.height, southRight - southLeft, this.occludingBounds.height);
        int northLeft = inBounds.x + this.getWidthAtYCardinal(this.p.getWest(), inBounds.y + this.getHeightAtLeftCardinal(this.p.getNorth()));
        int northRight = inBounds.x + inBounds.width - this.getWidthAtYCardinal(this.p.getEast(), inBounds.y + this.getHeightAtRightCardinal(this.p.getNorth()));
        this.layoutNorth(this.p.getNorth(), northLeft, this.occludingBounds.y, northRight - northLeft, this.occludingBounds.height);
        this.layoutBackground();
    }

    protected void layoutCardinals() {
        this.p.getNorth().setBounds(0, 0, this.p.getWidth(), this.p.getOverlapTolerance());
        this.p.getSouth().setBounds(0, this.p.getHeight() - this.p.getOverlapTolerance(), this.p.getWidth(), this.p.getOverlapTolerance());
        this.p.getEast().setBounds(this.p.getWidth() - this.p.getOverlapTolerance(), 0, this.p.getOverlapTolerance(), this.p.getWidth());
        this.p.getWest().setBounds(0, 0, this.p.getOverlapTolerance(), this.p.getWidth());
    }

    protected void layoutEast(DockWrapper base, int x, int y, int maxwidth, int maxheight) {
        for (DockWrapper dw : base.getDockedWrappers()) {
            Dimension d = dw.getPreferredSize();
            int w = this.min(d.width, maxwidth);
            int h = this.min(d.height, maxheight);
            dw.setBounds(x - w, y, w, h);
            if (!dw.canOcclude()) {
                this.updateRight(this.backgroundBounds, x - w);
            }
            this.updateRight(this.occludingBounds, x - w);
            this.layoutEast(dw, x - w, y, maxwidth - w, maxheight);
            y += h;
            maxheight -= h;
        }
    }

    protected void layoutWest(DockWrapper base, int x, int y, int maxwidth, int maxheight) {
        for (DockWrapper dw : base.getDockedWrappers()) {
            Dimension d = dw.getPreferredSize();
            int w = this.min(d.width, maxwidth);
            int h = this.min(d.height, maxheight);
            dw.setBounds(x, y, w, h);
            if (!dw.canOcclude()) {
                this.updateLeft(this.backgroundBounds, x + w);
            }
            this.updateLeft(this.occludingBounds, x + w);
            this.layoutWest(dw, x + w, y, maxwidth - w, maxheight);
            y += h;
            maxheight -= h;
        }
    }

    protected void layoutNorth(DockWrapper base, int x, int y, int maxwidth, int maxheight) {
        for (DockWrapper dw : base.getDockedWrappers()) {
            Dimension d = dw.getPreferredSize();
            int w = this.min(d.width, maxwidth);
            int h = this.min(d.height, maxheight);
            dw.setBounds(x, y, w, h);
            if (!dw.canOcclude()) {
                this.updateTop(this.backgroundBounds, y + h);
            }
            this.updateTop(this.occludingBounds, y + h);
            this.layoutNorth(dw, x, y + h, maxwidth, maxheight - h);
            x += w;
            maxwidth -= w;
        }
    }

    protected void layoutSouth(DockWrapper base, int x, int y, int maxwidth, int maxheight) {
        for (DockWrapper dw : base.getDockedWrappers()) {
            Dimension d = dw.getPreferredSize();
            int w = this.min(d.width, maxwidth);
            int h = this.min(d.height, maxheight);
            dw.setBounds(x, y - h, w, h);
            if (!dw.canOcclude()) {
                this.updateBottom(this.backgroundBounds, y - h);
            }
            this.updateBottom(this.occludingBounds, y - h);
            this.layoutSouth(dw, x, y - h, maxwidth, maxheight - h);
            x += w;
            maxwidth -= w;
        }
    }

    protected void layoutBackground() {
        JComponent background = this.p.getBackgroundComponent();
        if (background != null) {
            background.setBounds(this.backgroundBounds);
        }
    }

    protected int min(int a, int b) {
        return Math.min(a, b);
    }

    protected int max(int a, int b) {
        return Math.max(a, b);
    }

    protected void updateLeft(Rectangle r, int left) {
        int tmp = left - r.x;
        if (tmp > 0) {
            r.x += tmp;
            r.width -= tmp;
        }
    }

    protected void updateRight(Rectangle r, int right) {
        r.width = this.min(r.x + r.width, right);
    }

    protected void updateTop(Rectangle r, int top) {
        int tmp = top - r.y;
        if (tmp > 0) {
            r.y += tmp;
            r.height -= tmp;
        }
    }

    protected void updateBottom(Rectangle r, int bottom) {
        r.height = this.min(r.y + r.height, bottom);
    }

    public void layoutContainer(Container parent) {
        if (parent != this.p) {
            Debug.error("DockLayout: Asked to layout unexpected container");
            return;
        }
        this.layoutContainer();
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void addLayoutComponent(Component comp, Object constraints) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        JComponent background = this.p.getBackgroundComponent();
        if (background != null) {
            return background.getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    public Dimension minimumLayoutSize(Container parent) {
        JComponent background = this.p.getBackgroundComponent();
        if (background != null) {
            return background.getMinimumSize();
        }
        return new Dimension(0, 0);
    }

    public Dimension maximumLayoutSize(Container parent) {
        JComponent background = this.p.getBackgroundComponent();
        if (background != null) {
            return background.getMaximumSize();
        }
        return new Dimension(0, 0);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }
}

