/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.event;

import com.bbn.openmap.MapHandler;
import com.bbn.openmap.gui.MapPanelChild;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.gui.OpenMapFrame;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.gui.event.EventPresenter;
import com.bbn.openmap.gui.event.MacroFilter;
import com.bbn.openmap.util.PropUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EventPanel
extends OMComponentPanel
implements MapPanelChild {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.gui.event.EventPanel");
    public static final String SHOW_ALL_EVENTS_STRING = " Show All Events ";
    public static final String HIDE_ALL_EVENTS_STRING = " Hide All Events ";
    public static final String SET_FILTERS_STRING = " Filter Events... ";
    public static final String NO_EVENTS_STRING = "No Events";
    protected List<EventPresenter> eventPresenters;
    protected List<MacroFilter> macroFilters;
    protected String preferredLocation = "West";
    protected JPanel filterPanel;
    protected Hashtable<Object, EventPresenter> eventPresenterComponentLookup;
    protected boolean hasFilters = false;
    protected String parentName;
    protected JPanel launchFilterPanel = null;
    protected JPanel macroPanel = null;

    public EventPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "  Events  "));
        this.eventPresenters = new LinkedList<EventPresenter>();
        this.macroFilters = new LinkedList<MacroFilter>();
        this.eventPresenterComponentLookup = new Hashtable();
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.parentName = props.getProperty(prefix + "parent");
    }

    public void addEventPresenter(EventPresenter ep) {
        logger.fine("adding " + ep.getClass().getName());
        this.eventPresenters.add(ep);
        this.initInterface();
    }

    public void removeEventPresenter(EventPresenter ep) {
        this.eventPresenters.remove(ep);
        this.initInterface();
    }

    public void clearEventPresenters() {
        this.eventPresenters.clear();
        this.eventPresenterComponentLookup.clear();
        this.initInterface();
    }

    public void addMacroFilter(MacroFilter mf) {
        this.macroFilters.add(mf);
        this.initInterface();
    }

    public void removeMacroFilter(MacroFilter mf) {
        this.macroFilters.remove(mf);
        this.initInterface();
    }

    public void clearMacroFilters() {
        this.macroFilters.clear();
        this.initInterface();
    }

    public void initInterface() {
        logger.fine("rebuilding interface");
        this.removeAll();
        int numPresenters = this.eventPresenters.size();
        this.hasFilters = false;
        EventPresenter eventPresenter2 = null;
        Component presenterComponent = null;
        if (numPresenters == 1) {
            eventPresenter2 = this.eventPresenters.get(0);
            presenterComponent = eventPresenter2.getComponent();
            this.add(presenterComponent, "Center");
            this.eventPresenterComponentLookup.put(presenterComponent, eventPresenter2);
            this.hasFilters = this.hasFilters || eventPresenter2.getFilters() != null && !eventPresenter2.getFilters().isEmpty();
            this.setActiveEventPresenter(eventPresenter2);
        } else if (numPresenters > 1) {
            JTabbedPane jtb = new JTabbedPane();
            jtb.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    JTabbedPane jtb = (JTabbedPane)ce.getSource();
                    EventPanel.this.setActiveEventPresenter(EventPanel.this.eventPresenterComponentLookup.get(jtb.getSelectedComponent()));
                }
            });
            for (EventPresenter eventPresenter2 : this.eventPresenters) {
                String name = eventPresenter2.getName();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("\tEventPanel: adding presenter (" + name + ") to tabbed pane");
                }
                presenterComponent = eventPresenter2.getComponent();
                jtb.addTab(name, presenterComponent);
                this.eventPresenterComponentLookup.put(presenterComponent, eventPresenter2);
                this.hasFilters = this.hasFilters || eventPresenter2.getFilters() != null && !eventPresenter2.getFilters().isEmpty();
            }
            this.add((Component)jtb, "Center");
        }
        this.updateFilterCalloutInterface();
        this.updateMacroFilterInterface();
        this.revalidate();
        logger.fine("--- EventPanel: Done");
    }

    protected void updateFilterCalloutInterface() {
        if (this.launchFilterPanel == null) {
            this.launchFilterPanel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 2, 4, 2);
            this.launchFilterPanel.setLayout(gridbag);
            JButton launchFilterButton = new JButton(SET_FILTERS_STRING);
            launchFilterButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    EventPanel.this.showFilterInterface();
                }
            });
            JButton clearFilterButton = new JButton(SHOW_ALL_EVENTS_STRING);
            clearFilterButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    EventPanel.this.resetFilters(Boolean.TRUE);
                }
            });
            gridbag.setConstraints(clearFilterButton, c);
            gridbag.setConstraints(launchFilterButton, c);
            this.launchFilterPanel.add(clearFilterButton);
            this.launchFilterPanel.add(launchFilterButton);
        }
        this.add((Component)this.launchFilterPanel, "North");
        this.launchFilterPanel.setVisible(this.hasFilters);
    }

    public void updateMacroFilterInterface() {
        if (this.macroPanel == null) {
            this.macroPanel = new JPanel();
        }
        this.macroPanel.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.macroPanel.setLayout(gridbag);
        c.insets = new Insets(10, 10, 0, 10);
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        for (MacroFilter fp : this.macroFilters) {
            JPanel fpp = fp.getFilterPanel();
            fpp.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), fp.getName()));
            gridbag.setConstraints(fpp, c);
            this.macroPanel.add(fpp);
        }
        this.getFilterPanel().add((Component)this.macroPanel, "North");
        this.macroPanel.setVisible(!this.macroFilters.isEmpty());
        this.getFilterPanel().revalidate();
    }

    protected void resetFilters(Boolean true1) {
        Iterator<EventPresenter> it = this.eventPresenters.iterator();
        while (it.hasNext()) {
            it.next().resetFilters(true1);
        }
    }

    protected void setActiveEventPresenter(EventPresenter eventPresenter) {
        JPanel filterPanel = this.getFilterPanel();
        filterPanel.add((Component)eventPresenter.getFilterPanel(), "Center");
        filterPanel.revalidate();
    }

    protected void showFilterInterface() {
        if (this.windowSupport != null) {
            this.windowSupport.killWindow();
        }
        MapHandler beanContext = (MapHandler)this.getBeanContext();
        OpenMapFrame frame = beanContext.get(OpenMapFrame.class);
        this.windowSupport = new WindowSupport((Component)this.getFilterPanel(), new WindowSupport.Dlg((Frame)frame, this.i18n.get(EventPanel.class, "title", "Event Filters")));
        this.windowSupport.displayInWindow();
    }

    protected JPanel getFilterPanel() {
        if (this.filterPanel == null) {
            this.filterPanel = new JPanel();
            this.filterPanel.setLayout(new BorderLayout());
        }
        return this.filterPanel;
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof EventPresenter) {
            this.addEventPresenter((EventPresenter)someObj);
        }
        if (someObj instanceof MacroFilter) {
            this.addMacroFilter((MacroFilter)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof EventPresenter) {
            this.removeEventPresenter((EventPresenter)someObj);
        }
        if (someObj instanceof MacroFilter) {
            this.removeMacroFilter((MacroFilter)someObj);
        }
    }

    public void setPreferredLocation(String loc) {
        this.preferredLocation = loc;
    }

    public String getPreferredLocation() {
        return this.preferredLocation;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String pName) {
        this.parentName = pName;
    }
}

