/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.gui.AbstractOpenMapMenu;
import com.bbn.openmap.util.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;

public class MouseModeMenu
extends AbstractOpenMapMenu
implements PropertyChangeListener,
ActionListener {
    public static final String defaultText = "Mouse Mode";
    public static final transient String mouseModeCmd = "setMouseMode";
    protected transient MouseDelegator mouseDelegator = null;
    protected transient JRadioButtonMenuItem[] mouseModeButtons = new JRadioButtonMenuItem[0];
    protected transient ButtonGroup group2 = null;

    public MouseModeMenu() {
        this.setText(this.i18n.get(this, "mouseModeMenu", defaultText));
        this.addActionListener(this);
    }

    public void setMouseDelegator(MouseDelegator md) {
        this.mouseDelegator = md;
        if (this.mouseDelegator != null) {
            this.mouseDelegator.addPropertyChangeListener(this);
            MapMouseMode[] modes = this.mouseDelegator.getMouseModes();
            String activeMode = this.mouseDelegator.getActiveMouseModeID();
            Debug.message("mousemodemenuitem", "MouseModeMenuItem.setMouseDelegator MouseDelegator has " + modes.length + " modes");
            this.setUpItems(modes, activeMode);
        }
    }

    public void unsetMouseDelegator(MouseDelegator md) {
        if (md != null) {
            this.mouseDelegator.removePropertyChangeListener(this);
            if (this.mouseModeButtons != null) {
                for (int mms = 0; mms < this.mouseModeButtons.length; ++mms) {
                    this.mouseModeButtons[mms].removeActionListener(this);
                    this.group2.remove(this.mouseModeButtons[mms]);
                }
            }
        }
        this.group2 = null;
        this.mouseModeButtons = null;
        this.mouseDelegator = null;
    }

    protected void setUpItems(MapMouseMode[] modes, String activeMode) {
        if (this.group2 == null) {
            this.group2 = new ButtonGroup();
        }
        this.mouseModeButtons = new JRadioButtonMenuItem[modes.length];
        for (int mms = 0; mms < modes.length; ++mms) {
            Debug.message("mousemodemenuitem", "MouseModeMenuItem.setUpItems adding " + modes[mms].getID());
            this.mouseModeButtons[mms] = (JRadioButtonMenuItem)this.add(new JRadioButtonMenuItem(modes[mms].getPrettyName()));
            this.mouseModeButtons[mms].setActionCommand(mouseModeCmd);
            this.mouseModeButtons[mms].setName(modes[mms].getID());
            this.mouseModeButtons[mms].addActionListener(this);
            this.mouseModeButtons[mms].setVisible(modes[mms].isVisible());
            this.group2.add(this.mouseModeButtons[mms]);
            if (activeMode == null || !activeMode.equals(modes[mms].getID())) continue;
            this.mouseModeButtons[mms].setSelected(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(mouseModeCmd)) {
            JRadioButtonMenuItem rb = (JRadioButtonMenuItem)e.getSource();
            this.mouseDelegator.setActiveMouseModeWithID(rb.getName());
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Debug.message("mousemodemenuitem", "MouseModeMenuItem.propertyChange()");
        if (evt.getPropertyName() == "NewActiveMouseMode") {
            String mmID = ((MapMouseMode)evt.getNewValue()).getID();
            for (int i = 0; i < this.mouseModeButtons.length; ++i) {
                if (!this.mouseModeButtons[i].getName().equals(mmID)) continue;
                this.mouseModeButtons[i].setSelected(true);
                break;
            }
        } else if (evt.getPropertyName() == "NewListOfMouseModes") {
            for (int i = 0; i < this.mouseModeButtons.length; ++i) {
                this.remove(this.mouseModeButtons[i]);
            }
            MapMouseMode[] modes = this.mouseDelegator.getMouseModes();
            String activeMode = this.mouseDelegator.getActiveMouseModeID();
            this.setUpItems(modes, activeMode);
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MouseDelegator) {
            Debug.message("mousemodemenuitem", "MouseModeMenuItem found a MouseDelegator.");
            this.setMouseDelegator((MouseDelegator)someObj);
        }
    }

    public void findAndUnInit(Object someObj) {
        if (someObj instanceof MouseDelegator) {
            Debug.message("mousemodemenuitem", "MouseModeMenuItem removing MouseDelegator.");
            this.setMouseDelegator(null);
        }
    }
}

