/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.time;

import com.bbn.openmap.gui.time.TimerControlButtonPanel;
import com.bbn.openmap.time.RealTimeHandler;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class HotwashTimerControlButtonPanel
extends TimerControlButtonPanel {
    JButton forwardStepButton;
    JButton backwardStepButton;

    public HotwashTimerControlButtonPanel() {
    }

    public HotwashTimerControlButtonPanel(RealTimeHandler rth) {
        super(rth);
    }

    public void initGUI() {
        this.removeAll();
        try {
            URL url = PropUtils.getResourceOrFileOrURL(TimerControlButtonPanel.class, this.forwardIconURL);
            this.forwardIcon = new ImageIcon(url);
            url = PropUtils.getResourceOrFileOrURL(TimerControlButtonPanel.class, this.forwardStepIconURL);
            this.forwardStepIcon = new ImageIcon(url);
            url = PropUtils.getResourceOrFileOrURL(TimerControlButtonPanel.class, this.backwardIconURL);
            this.backwardIcon = new ImageIcon(url);
            url = PropUtils.getResourceOrFileOrURL(TimerControlButtonPanel.class, this.backwardStepIconURL);
            this.backwardStepIcon = new ImageIcon(url);
            url = PropUtils.getResourceOrFileOrURL(TimerControlButtonPanel.class, this.pauseIconURL);
            this.pauseIcon = new ImageIcon(url);
        }
        catch (MalformedURLException murle) {
            Debug.error("TimerToggleButton: initGUI() bad icon.");
        }
        catch (NullPointerException npe) {
            Debug.error("TimerToggleButton: initGUI() bad icon.");
            npe.printStackTrace();
        }
        JToolBar jtb = new JToolBar();
        jtb.setFloatable(false);
        this.backwardButton = new JButton(this.backwardIcon);
        this.backwardButton.setToolTipText("Run Timer Backwards");
        this.backwardButton.setActionCommand("Timer run backward");
        this.backwardButton.addActionListener(this);
        this.forwardStepButton = new JButton(this.backwardStepIcon);
        this.forwardStepButton.setToolTipText("Step Timer Backward");
        this.forwardStepButton.setActionCommand("Timer step backward");
        this.forwardStepButton.addActionListener(this);
        jtb.add(this.forwardStepButton);
        this.forwardButton = new JButton(this.forwardIcon);
        this.forwardButton.setToolTipText("Run Timer Forward");
        this.forwardButton.setActionCommand("Timer run forward");
        this.forwardButton.addActionListener(this);
        jtb.add(this.forwardButton);
        this.backwardStepButton = new JButton(this.forwardStepIcon);
        this.backwardStepButton.setToolTipText("Step Timer Forward");
        this.backwardStepButton.setActionCommand("Timer step forward");
        this.backwardStepButton.addActionListener(this);
        jtb.add(this.backwardStepButton);
        this.add(jtb);
    }

    public void enableForwardButton(boolean set) {
        this.forwardButton.setEnabled(set && this.clockEnabled);
    }

    public void enableBackwardButton(boolean set) {
        this.backwardButton.setEnabled(set && this.clockEnabled);
    }

    public void setEnableState(boolean set) {
        super.setEnableState(set);
        this.forwardStepButton.setEnabled(set);
        this.backwardStepButton.setEnabled(set);
    }
}

