/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.image.ColorReducer;
import com.bbn.openmap.image.ImageFormatter;
import com.bbn.openmap.image.ImageIOFormatter;
import com.bbn.openmap.util.Debug;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class GIFImageIOFormatter
extends ImageIOFormatter {
    public GIFImageIOFormatter() {
        this.setFormatName("gif");
    }

    public ImageFormatter makeClone() {
        return new GIFImageIOFormatter();
    }

    public byte[] formatImage(BufferedImage bi) {
        BufferedImage reducedImage = ColorReducer.reduce24(bi, 256);
        try {
            ByteArrayOutputStream byo = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)reducedImage, this.getFormatName(), byo);
            return byo.toByteArray();
        }
        catch (IOException e) {
            Debug.error("ImageIOFormatter caught IOException formatting image!");
            return new byte[0];
        }
    }

    public String getFormatLabel() {
        return "GIF";
    }

    public String getContentType() {
        return "image/gif";
    }

    protected boolean imageFormatSupportAlphaChannel() {
        return false;
    }

    protected boolean imageFormatSupportTransparentPixel() {
        return true;
    }
}

