/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.io;

import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.io.InputReader;
import com.bbn.openmap.util.Debug;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileInputReader
implements InputReader {
    protected RandomAccessFile inputFile = null;
    protected String name = null;
    protected String absolutePath = null;

    public FileInputReader(File f) throws IOException {
        if (Debug.debugging("binaryfile")) {
            Debug.output("FileInputReader created from " + f.getAbsolutePath());
        }
        this.name = f.getName();
        this.absolutePath = f.getAbsolutePath();
        this.inputFile = this.init(f);
    }

    public FileInputReader(String f) throws IOException {
        if (Debug.debugging("binaryfile")) {
            Debug.output("FileInputReader created from " + f);
        }
        File file = new File(f);
        this.name = file.getName();
        this.absolutePath = file.getAbsolutePath();
        this.inputFile = this.init(file);
    }

    public String getName() {
        return this.name;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    protected RandomAccessFile init(File f) throws IOException {
        RandomAccessFile inputFile = null;
        try {
            inputFile = new RandomAccessFile(f, "r");
        }
        catch (IOException i) {
            if (i instanceof FileNotFoundException) {
                throw i;
            }
            if (f.canRead()) {
                BinaryFile.closeClosable();
                inputFile = new RandomAccessFile(f, "r");
            }
            throw i;
        }
        return inputFile;
    }

    public RandomAccessFile getInputFile() {
        return this.inputFile;
    }

    public RandomAccessFile checkInputFile() throws IOException {
        if (this.inputFile == null && this.absolutePath != null) {
            this.inputFile = this.init(new File(this.absolutePath));
        }
        return this.inputFile;
    }

    public long skipBytes(long n) throws IOException {
        return this.checkInputFile().skipBytes((int)n);
    }

    public long getFilePointer() throws IOException {
        return this.checkInputFile().getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.checkInputFile().seek(pos);
    }

    public long length() throws IOException {
        return this.checkInputFile().length();
    }

    public long available() throws IOException {
        return this.length() - this.getFilePointer();
    }

    public void close() throws IOException {
        if (Debug.debugging("binaryfile")) {
            Debug.output("FileInputReader.close()");
        }
        try {
            if (this.inputFile != null) {
                this.inputFile.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.inputFile = null;
    }

    public int read() throws IOException {
        return this.checkInputFile().read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.checkInputFile().read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.checkInputFile().read(b);
    }

    public byte[] readBytes(int howmany, boolean allowless) throws EOFException, FormatException {
        byte[] foo = new byte[howmany];
        int err = 0;
        try {
            RandomAccessFile inputFile = this.checkInputFile();
            for (int gotsofar = 0; gotsofar < howmany; gotsofar += err) {
                err = inputFile.read(foo, gotsofar, howmany - gotsofar);
                if (err != -1) continue;
                if (allowless) {
                    byte[] retval = new byte[gotsofar];
                    System.arraycopy(foo, 0, retval, 0, gotsofar);
                    return retval;
                }
                if (gotsofar > 0) {
                    throw new FormatException("EOF while reading data");
                }
                throw new EOFException();
            }
        }
        catch (IOException i) {
            throw new FormatException("FileInputReader: readBytes IOException: " + i.getMessage());
        }
        return foo;
    }
}

