/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.layer.dted.DTEDFrameCache;
import com.bbn.openmap.layer.dted.DTEDFrameColorTable;
import com.bbn.openmap.layer.dted.DTEDFrameSubframeInfo;
import com.bbn.openmap.layer.dted.DTEDSubframedFrame;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.LLXY;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.geom.Point2D;

public class DTEDCacheHandler {
    public static final int FRAME_CACHE_SIZE = 20;
    public static final int SF_PIXEL_HW = 200;
    protected String[] paths;
    protected DTEDFrameCache frameCache;
    protected int frameCacheSize = -1;
    protected DTEDFrameColorTable colortable;
    LatLonPoint ulCoords;
    LatLonPoint lrCoords;
    double frameUp;
    double frameDown;
    double frameLeft;
    double frameRight;
    double xPixInterval;
    double yPixInterval;
    int numXSubframes;
    int numYSubframes;
    int lastSubframeWidth;
    int lastSubframeHeight;
    int currentFrameCacheSize = -10;
    boolean firstImageReturned = true;
    double frameLon = 0.0;
    double frameLat = 0.0;
    int subx = 0;
    int suby = 0;
    boolean newframe = false;
    DTEDSubframedFrame frame = null;
    protected DTEDFrameSubframeInfo dfsi = new DTEDFrameSubframeInfo(0, 25, 0, 3);

    public DTEDCacheHandler() {
        this(null, 216, 255, 20);
    }

    public DTEDCacheHandler(String[] dataPaths, int numColors, int opaque) {
        this(dataPaths, numColors, opaque, -1);
    }

    public DTEDCacheHandler(String[] dataPaths, int numColors, int opaqueness, int subframe_cache_size) {
        this.colortable = new DTEDFrameColorTable(numColors, opaqueness, true);
        this.setFrameCacheSize(subframe_cache_size);
        this.paths = dataPaths;
        this.frameCache = new DTEDFrameCache(dataPaths, this.frameCacheSize);
        if (Debug.debugging("dted")) {
            Debug.output("DTEDCacheHandler: Created with cache size of " + this.frameCacheSize);
        }
    }

    public void setFrameCacheSize(int size) {
        this.frameCacheSize = size <= 0 ? 20 : size;
    }

    public int getFrameCacheSize() {
        return this.frameCacheSize;
    }

    public int getElevation(float lat, float lon) {
        return this.frameCache.getElevation(lat, lon);
    }

    public void setSubframeInfo(DTEDFrameSubframeInfo new_dfsi) {
        this.dfsi = new_dfsi;
        if (this.dfsi.viewType == 5) {
            this.colortable.setGreyScale(false);
        } else {
            this.colortable.setGreyScale(true);
        }
    }

    public void setProjection(EqualArc proj) {
        this.setProjection(proj, ((Point2D)proj.getUpperLeft()).getY(), ((Point2D)proj.getUpperLeft()).getX(), ((Point2D)proj.getLowerRight()).getY(), ((Point2D)proj.getLowerRight()).getX());
    }

    public void setProjection(Projection proj, double lat1, double lon1, double lat2, double lon2) {
        int numFramesNeeded;
        this.ulCoords = new LatLonPoint.Double(lat1, lon1);
        this.lrCoords = new LatLonPoint.Double(lat2, lon2);
        this.firstImageReturned = true;
        this.frameUp = Math.floor(lat1);
        this.frameDown = Math.floor(lat2);
        this.frameLeft = Math.floor(lon1);
        this.frameRight = Math.ceil(lon2);
        if (Debug.debugging("dted")) {
            Debug.output("frameUp = " + this.frameUp + ", frameDown = " + this.frameDown + ", frameLeft = " + this.frameLeft + ", frameRight = " + this.frameRight);
        }
        if (this.frameCacheSize > 0) {
            numFramesNeeded = this.frameCacheSize;
            if (Debug.debugging("dteddetail")) {
                Debug.output("DTEDCacheHandler: frameCacheSize remains at: " + numFramesNeeded);
            }
        } else {
            numFramesNeeded = (int)(Math.abs(this.frameUp - this.frameDown) * Math.abs(this.frameRight - this.frameLeft) * 2.0);
        }
        EqualArc eaProj = null;
        boolean isEqualArcProj = proj instanceof EqualArc;
        eaProj = isEqualArcProj ? (EqualArc)proj : LLXY.convertProjection(proj);
        double xpi = 360.0 / eaProj.getXPixConstant();
        double ypi = 90.0 / eaProj.getYPixConstant();
        if (!MoreMath.approximately_equal(this.xPixInterval, xpi) || !MoreMath.approximately_equal(this.yPixInterval, ypi)) {
            this.xPixInterval = xpi;
            this.yPixInterval = ypi;
            this.dfsi.xPixInterval = this.xPixInterval;
            this.dfsi.yPixInterval = this.yPixInterval;
            if (xpi == 0.0 || ypi == 0.0) {
                this.numXSubframes = 0;
                this.numYSubframes = 0;
                return;
            }
            int frame_width = (int)Math.ceil(1.0 / xpi);
            int frame_height = (int)Math.ceil(1.0 / ypi);
            if (!isEqualArcProj) {
                this.numXSubframes = 1;
                this.numYSubframes = 1;
                this.lastSubframeHeight = frame_height;
                this.lastSubframeWidth = frame_width;
            } else {
                this.numXSubframes = frame_width / 200;
                this.lastSubframeWidth = 200;
                this.numYSubframes = frame_height / 200;
                this.lastSubframeHeight = 200;
                if (frame_width % 200 != 0) {
                    this.lastSubframeWidth = frame_width - this.numXSubframes * 200;
                    ++this.numXSubframes;
                }
                if (frame_height % 200 != 0) {
                    this.lastSubframeHeight = frame_height - this.numYSubframes * 200;
                    ++this.numYSubframes;
                }
            }
            this.currentFrameCacheSize = numFramesNeeded;
            this.frameCache.resizeCache(numFramesNeeded, this.numXSubframes, this.numYSubframes);
            if (Debug.debugging("dteddetail")) {
                Debug.output("DTEDCacheHandler: frameCacheSize set to: " + numFramesNeeded);
            }
            if (Debug.debugging("dted")) {
                Debug.output("***** Screen Parameters Changed! \n Frame width (pix) = " + frame_width + "\n Frame height (pix) = " + frame_height + "\n Num x subframes = " + this.numXSubframes + "\n Num y subframes = " + this.numYSubframes + "\n last sf width = " + this.lastSubframeWidth + "\n last sf height = " + this.lastSubframeHeight + "\n X pix interval = " + xpi + "\n Y pix interval = " + ypi + "\n");
            }
        } else if (Math.abs(numFramesNeeded - this.currentFrameCacheSize) > numFramesNeeded / 2) {
            this.currentFrameCacheSize = numFramesNeeded;
            this.frameCache.resizeCache(numFramesNeeded);
            if (Debug.debugging("dteddetail")) {
                Debug.output("DTEDCacheHandler: frameCacheSize set to: " + numFramesNeeded);
            }
        }
    }

    public OMGraphic getNextImage(Projection proj) {
        OMGraphic subframe = null;
        long sf_width = 200L;
        long sf_height = 200L;
        if (Debug.debugging("dted")) {
            Debug.output("--- DTEDCacheHandler: getNextImage:");
        }
        while (true) {
            if (this.firstImageReturned) {
                this.frameLon = this.frameLeft;
                this.frameLat = this.frameDown;
                this.subx = 0;
                this.suby = 0;
                this.newframe = true;
                this.firstImageReturned = false;
            } else if (this.frame != null && this.subx < this.numXSubframes) {
                if (this.suby < this.numYSubframes - 1) {
                    ++this.suby;
                } else {
                    this.suby = 0;
                    ++this.subx;
                }
            } else if (this.frameLon < this.frameRight) {
                this.subx = 0;
                this.suby = 0;
                if (this.frameLat < this.frameUp) {
                    this.frameLat += 1.0;
                } else {
                    this.frameLat = this.frameDown;
                    this.frameLon += 1.0;
                }
                this.newframe = true;
            } else {
                return null;
            }
            if (this.newframe && this.frameLon < this.frameRight) {
                if (Debug.debugging("dted")) {
                    Debug.output(" gni: Getting new frame Lat = " + this.frameLat + " Lon = " + this.frameLon);
                }
                this.frame = this.frameCache.get(this.frameLat, this.frameLon, this.dfsi.dtedLevel);
            }
            if (this.frame != null) {
                this.newframe = false;
                if (this.subx == this.numXSubframes - 1) {
                    sf_width = this.lastSubframeWidth;
                }
                if (this.suby == this.numYSubframes - 1) {
                    sf_height = this.lastSubframeHeight;
                }
                double sf_width_degrees = (double)sf_width * this.xPixInterval;
                double sf_height_degrees = (double)sf_height * this.yPixInterval;
                double width_degrees = 200.0 * this.xPixInterval;
                double height_degrees = 200.0 * this.yPixInterval;
                double sf_ullat = this.frameLat + 1.0 - (double)this.suby * height_degrees;
                double sf_ullon = this.frameLon + (double)this.subx * width_degrees;
                double sf_lrlat = this.frameLat + 1.0 - (double)this.suby * height_degrees - sf_height_degrees;
                double sf_lrlon = this.frameLon + (double)this.subx * width_degrees + sf_width_degrees;
                if (this.ulCoords.getY() > sf_lrlat && this.lrCoords.getY() < sf_ullat && this.ulCoords.getX() < sf_lrlon && this.lrCoords.getX() > sf_ullon && this.subx < this.numXSubframes) {
                    this.dfsi.height = (int)sf_height;
                    this.dfsi.width = (int)sf_width;
                    this.dfsi.lon = (float)sf_ullon;
                    this.dfsi.lat = (float)sf_ullat;
                    this.dfsi.subx = this.subx;
                    this.dfsi.suby = this.suby;
                    if (Debug.debugging("dteddetail")) {
                        Debug.output(" gni: Looking for Subframe " + this.subx + ", " + this.suby);
                    }
                    if ((subframe = this.frame.getSubframeImage(this.dfsi, this.colortable, proj)) != null) {
                        if (Debug.debugging("dted")) {
                            Debug.output(" gni: Subframe " + this.subx + ", " + this.suby + " found :)");
                        }
                        return subframe;
                    }
                } else if (Debug.debugging("dteddetail")) {
                    Debug.output(" gni: Subframe " + this.subx + ", " + this.suby + " didn't meet screen criteria");
                }
            }
            sf_width = 200L;
            sf_height = 200L;
        }
    }

    public DTEDFrameColorTable getColortable() {
        return this.colortable;
    }

    public void setColortable(DTEDFrameColorTable colorT) {
        this.colortable = colorT == null ? new DTEDFrameColorTable(216, 255, true) : colorT;
    }
}

