/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkGraphicConstants;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.omGraphics.OMEllipse;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LinkEllipse
implements LinkGraphicConstants,
LinkPropertiesConstants {
    public static void write(float latPoint, float lonPoint, float majorAxisSpan, float minorAxisSpan, int units, float rotationAngle, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<E>".getBytes());
        dos.writeByte(11);
        dos.writeByte(1);
        dos.writeFloat(latPoint);
        dos.writeFloat(lonPoint);
        dos.writeFloat(majorAxisSpan);
        dos.writeFloat(minorAxisSpan);
        dos.writeByte(units);
        dos.writeFloat(rotationAngle);
        properties.write(dos);
    }

    public static void write(int x1, int y1, int majorAxisSpan, int minorAxisSpan, float rotateAngle, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<E>".getBytes());
        dos.writeByte(11);
        dos.writeByte(2);
        dos.writeInt(x1);
        dos.writeInt(y1);
        dos.writeInt(majorAxisSpan);
        dos.writeInt(minorAxisSpan);
        dos.writeFloat(rotateAngle);
        properties.write(dos);
    }

    public static void write(float latPoint, float lonPoint, int w, int h, float rotateAngle, LinkProperties properties, DataOutputStream dos) throws IOException {
        LinkEllipse.write(latPoint, lonPoint, 0, 0, w, h, rotateAngle, properties, dos);
    }

    public static void write(float latPoint, float lonPoint, int offset_x1, int offset_y1, int w, int h, float rotateAngle, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<E>".getBytes());
        dos.writeByte(11);
        dos.writeByte(3);
        dos.writeFloat(latPoint);
        dos.writeFloat(lonPoint);
        dos.writeInt(offset_x1);
        dos.writeInt(offset_y1);
        dos.writeInt(w);
        dos.writeInt(h);
        dos.writeFloat(rotateAngle);
        properties.write(dos);
    }

    public static void write(OMEllipse ellipse, Link link, LinkProperties props) throws IOException {
        switch (ellipse.getRenderType()) {
            case 1: {
                LatLonPoint llp = ellipse.getLatLon();
                LinkEllipse.write(llp.getLatitude(), llp.getLongitude(), (float)Length.KM.fromRadians(ellipse.getMajorAxis()), (float)Length.KM.fromRadians(ellipse.getMinorAxis()), 0, (float)ellipse.getRotationAngle(), props, link.dos);
                break;
            }
            case 2: {
                LinkEllipse.write(ellipse.getX(), ellipse.getY(), (int)ellipse.getMajorAxis(), (int)ellipse.getMinorAxis(), (float)ellipse.getRotationAngle(), props, (DataOutputStream)link.dos);
                break;
            }
            case 3: {
                LatLonPoint llp = ellipse.getLatLon();
                LinkEllipse.write(llp.getLatitude(), llp.getLongitude(), ellipse.getOffX(), ellipse.getOffY(), (int)ellipse.getMajorAxis(), (int)ellipse.getMinorAxis(), (float)ellipse.getRotationAngle(), props, link.dos);
                break;
            }
            default: {
                Debug.error("LinkCircle.write: circle rendertype unknown.");
            }
        }
    }

    public static OMEllipse read(DataInputStream dis) throws IOException {
        return LinkEllipse.read(dis, null);
    }

    public static OMEllipse read(DataInputStream dis, LinkProperties propertiesBuffer) throws IOException {
        OMEllipse ellipse = null;
        byte renderType = dis.readByte();
        switch (renderType) {
            case 1: {
                float lat = dis.readFloat();
                float lon = dis.readFloat();
                double majorAxisSpan = dis.readFloat();
                double minorAxisSpan = dis.readFloat();
                byte units = dis.readByte();
                double rotationAngle = dis.readFloat();
                Length unit = Length.DECIMAL_DEGREE;
                switch (units) {
                    case 0: {
                        unit = Length.KM;
                        break;
                    }
                    case 1: {
                        unit = Length.MILE;
                        break;
                    }
                    case 2: {
                        unit = Length.NM;
                        break;
                    }
                }
                ellipse = new OMEllipse(new LatLonPoint.Double(lat, lon), majorAxisSpan, minorAxisSpan, unit, rotationAngle);
                break;
            }
            case 2: {
                int x = dis.readInt();
                int y = dis.readInt();
                int majorAxisSpan = dis.readInt();
                int minorAxisSpan = dis.readInt();
                double rotationAngle = dis.readFloat();
                ellipse = new OMEllipse(x, y, majorAxisSpan, minorAxisSpan, rotationAngle);
                break;
            }
            case 3: {
                float lat = dis.readFloat();
                float lon = dis.readFloat();
                int offsetX = dis.readInt();
                int offsetY = dis.readInt();
                int w = dis.readInt();
                int h = dis.readInt();
                double rotationAngle = dis.readFloat();
                ellipse = new OMEllipse((LatLonPoint)new LatLonPoint.Double(lat, lon), offsetX, offsetY, w, h, rotationAngle);
                break;
            }
            default: {
                Debug.error("LinkEllipse.read: ellipse rendertype unknown.");
            }
        }
        if (ellipse != null) {
            LinkProperties.loadPropertiesIntoOMGraphic(dis, ellipse, propertiesBuffer);
        }
        return ellipse;
    }
}

