/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location;

import com.bbn.openmap.layer.location.AbstractLocationHandler;
import com.bbn.openmap.layer.location.BasicLocation;
import com.bbn.openmap.layer.location.LocationLayer;
import com.bbn.openmap.omGraphics.OMGraphicList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;

public class BasicLocationHandler
extends AbstractLocationHandler {
    protected final OMGraphicList graphicList = new OMGraphicList();
    protected Box box = null;

    public BasicLocationHandler() {
        this.reloadData();
    }

    public void reloadData() {
        Color[] colors = new Color[]{Color.red, Color.green, Color.yellow, Color.blue, Color.black, Color.white, Color.orange, Color.pink};
        this.graphicList.clear();
        for (int i = 0; i < 10; ++i) {
            boolean dir;
            double ran = Math.random() * 10.0;
            boolean bl = dir = Math.random() > 0.5;
            if (!dir) {
                ran *= -1.0;
            }
            BasicLocation location = new BasicLocation(42.0 + ran, -72.0 + ran, "testing" + i, null);
            location.setLocationHandler(this);
            location.getLabel().setLinePaint(colors[i % 8]);
            location.setShowName(true);
            location.setShowLocation(true);
            this.graphicList.add(location);
        }
    }

    public void removed(Container cont) {
    }

    public OMGraphicList get(double nwLat, double nwLon, double seLat, double seLon, OMGraphicList graphicList) {
        graphicList.addAll(this.graphicList);
        return graphicList;
    }

    public Component getGUI() {
        if (this.box == null) {
            JCheckBox showLocationCheck = new JCheckBox("Show Locations", this.isShowLocations());
            showLocationCheck.setActionCommand("showLocations");
            showLocationCheck.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JCheckBox locationCheck = (JCheckBox)ae.getSource();
                    BasicLocationHandler.this.setShowLocations(locationCheck.isSelected());
                    if (AbstractLocationHandler.logger.isLoggable(Level.FINE)) {
                        AbstractLocationHandler.logger.fine("CSVLocationHandler::actionPerformed showLocations is " + BasicLocationHandler.this.isShowLocations());
                    }
                    BasicLocationHandler.this.getLayer().repaint();
                }
            });
            showLocationCheck.setToolTipText("<HTML><BODY>Show location markers on the map.</BODY></HTML>");
            JCheckBox showNameCheck = new JCheckBox("Show Location Names", this.isShowNames());
            showNameCheck.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JCheckBox namesCheck = (JCheckBox)ae.getSource();
                    BasicLocationHandler.this.setShowNames(namesCheck.isSelected());
                    if (AbstractLocationHandler.logger.isLoggable(Level.FINE)) {
                        AbstractLocationHandler.logger.fine("CSVLocationHandler::actionPerformed showNames is " + BasicLocationHandler.this.isShowNames());
                    }
                    LocationLayer ll = BasicLocationHandler.this.getLayer();
                    if (namesCheck.isSelected() && ll.getDeclutterMatrix() != null && ll.getUseDeclutterMatrix()) {
                        ll.doPrepare();
                    } else {
                        ll.repaint();
                    }
                }
            });
            showNameCheck.setToolTipText("<HTML><BODY>Show location names on the map.</BODY></HTML>");
            JButton rereadFilesButton = new JButton("Reload Data From Source");
            rereadFilesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    if (AbstractLocationHandler.logger.isLoggable(Level.FINE)) {
                        AbstractLocationHandler.logger.fine("Re-reading Locations file");
                    }
                    BasicLocationHandler.this.reloadData();
                    BasicLocationHandler.this.getLayer().doPrepare();
                }
            });
            rereadFilesButton.setToolTipText("<HTML><BODY>Reload the data file, and put these settings<br>on the individual map objects.</BODY></HTML>");
            this.box = Box.createVerticalBox();
            this.box.add(showLocationCheck);
            this.box.add(showNameCheck);
            this.box.add(rereadFilesButton);
        }
        return this.box;
    }
}

