/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location.csv;

import com.bbn.openmap.layer.location.AbstractLocationHandler;
import com.bbn.openmap.layer.location.Location;
import com.bbn.openmap.layer.location.LocationCBMenuItem;
import com.bbn.openmap.layer.location.LocationHandler;
import com.bbn.openmap.layer.location.LocationLayer;
import com.bbn.openmap.layer.location.LocationMenuItem;
import com.bbn.openmap.layer.location.URLRasterLocation;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.CSVTokenizer;
import com.bbn.openmap.util.HandleError;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.quadtree.QuadTree;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVLocationHandler
extends AbstractLocationHandler
implements LocationHandler {
    protected String locationFile;
    public static final String LocationFileProperty = "locationFile";
    public static final String csvHeaderProperty = "csvFileHasHeader";
    protected QuadTree<Location> quadtree = null;
    public static final String eastIsNegProperty = "eastIsNeg";
    protected boolean eastIsNeg = false;
    protected boolean csvHasHeader = false;
    protected int nameIndex = -1;
    public static final String NameIndexProperty = "nameIndex";
    public static final String LatIndexProperty = "latIndex";
    public static final String LonIndexProperty = "lonIndex";
    public static final String IconIndexProperty = "iconIndex";
    public static final String DefaultIconURLProperty = "defaultIconURL";
    protected int latIndex = -1;
    protected int lonIndex = -1;
    protected int iconIndex = -1;
    protected String defaultIconURL = null;
    protected Box box = null;

    @Override
    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.locationFile = properties.getProperty(prefix + LocationFileProperty);
        this.latIndex = PropUtils.intFromProperties(properties, prefix + LatIndexProperty, -1);
        this.lonIndex = PropUtils.intFromProperties(properties, prefix + LonIndexProperty, -1);
        this.iconIndex = PropUtils.intFromProperties(properties, prefix + IconIndexProperty, -1);
        this.nameIndex = PropUtils.intFromProperties(properties, prefix + NameIndexProperty, -1);
        this.eastIsNeg = PropUtils.booleanFromProperties(properties, prefix + eastIsNegProperty, false);
        this.defaultIconURL = properties.getProperty(prefix + DefaultIconURLProperty);
        if (this.defaultIconURL != null && this.defaultIconURL.trim().length() == 0) {
            this.defaultIconURL = null;
        }
        this.csvHasHeader = PropUtils.booleanFromProperties(properties, prefix + csvHeaderProperty, false);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("CSVLocationHandler indexes:\n  latIndex = " + this.latIndex + "\n  lonIndex = " + this.lonIndex + "\n  nameIndex = " + this.nameIndex + "\n  has header = " + this.csvHasHeader);
        }
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + "class", this.getClass().getName());
        props.put(prefix + LocationFileProperty, PropUtils.unnull(this.locationFile));
        props.put(prefix + eastIsNegProperty, new Boolean(this.eastIsNeg).toString());
        props.put(prefix + csvHeaderProperty, new Boolean(this.csvHasHeader).toString());
        props.put(prefix + NameIndexProperty, this.nameIndex != -1 ? Integer.toString(this.nameIndex) : "");
        props.put(prefix + LatIndexProperty, this.latIndex != -1 ? Integer.toString(this.latIndex) : "");
        props.put(prefix + LonIndexProperty, this.lonIndex != -1 ? Integer.toString(this.lonIndex) : "");
        props.put(prefix + IconIndexProperty, this.iconIndex != -1 ? Integer.toString(this.iconIndex) : "");
        props.put(prefix + DefaultIconURLProperty, PropUtils.unnull(this.defaultIconURL));
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.put("class.editor", "com.bbn.openmap.util.propertyEditor.NonEditablePropertyEditor");
        list.put(LocationFileProperty, "URL of file containing location information.");
        list.put("locationFile.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        list.put(eastIsNegProperty, "Flag to note that negative latitude are over the eastern hemisphere.");
        list.put("eastIsNeg.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put(NameIndexProperty, "The column index, in the location file, of the location label text.");
        list.put(LatIndexProperty, "The column index, in the location file, of the latitudes.");
        list.put(LonIndexProperty, "The column index, in the location file, of the longitudes.");
        list.put(IconIndexProperty, "The column index, in the location file, of the icon for locations (optional).");
        list.put(DefaultIconURLProperty, "The URL of an image file to use as a default for the location markers (optional).");
        list.put(csvHeaderProperty, "Flag to note that the first line in the csv file is a header line and should be ignored.");
        return list;
    }

    @Override
    public void reloadData() {
        this.quadtree = this.createData();
    }

    protected boolean checkIndexSettings() {
        if (this.latIndex == -1 || this.lonIndex == -1) {
            logger.warning("CSVLocationHandler: createData(): Index properties for Lat/Lon/Name are not set properly! lat index:" + this.latIndex + ", lon index:" + this.lonIndex);
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("CSVLocationHandler: Reading File:" + this.locationFile + " NameIndex: " + this.nameIndex + " latIndex: " + this.latIndex + " lonIndex: " + this.lonIndex + " iconIndex: " + this.iconIndex + " eastIsNeg: " + this.eastIsNeg);
        }
        return true;
    }

    protected QuadTree<Location> createData() {
        QuadTree<Location> qt = new QuadTree<Location>(90.0, -180.0, -90.0, 180.0, 100, 50.0);
        if (!this.checkIndexSettings()) {
            return null;
        }
        int lineCount = 0;
        Object token = null;
        boolean readHeader = !this.csvHasHeader;
        try {
            URL csvURL = PropUtils.getResourceOrFileOrURL(null, this.locationFile);
            if (csvURL != null) {
                BufferedReader streamReader = new BufferedReader(new InputStreamReader(csvURL.openStream()));
                CSVTokenizer csvt = new CSVTokenizer(streamReader);
                token = csvt.token();
                List<Object> recordList = Collections.synchronizedList(new ArrayList(10));
                while (!csvt.isEOF(token)) {
                    int i = 0;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("CSVLocationHandler| Starting a line | have" + (readHeader ? " " : "n't ") + "read header");
                    }
                    recordList.clear();
                    while (!csvt.isNewline(token) && !csvt.isEOF(token)) {
                        if (readHeader) {
                            recordList.add(token);
                        }
                        if (csvt.isEOF(token = csvt.token())) break;
                        ++i;
                    }
                    if (!readHeader) {
                        readHeader = true;
                    } else {
                        ++lineCount;
                        this.createLocation(recordList, qt);
                    }
                    token = csvt.token();
                }
                csvt.close();
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("couldn't figure out file: " + this.locationFile);
            }
        }
        catch (IOException ioe) {
            throw new HandleError(ioe);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new HandleError(aioobe);
        }
        catch (NumberFormatException nfe) {
            throw new HandleError(nfe);
        }
        catch (ClassCastException cce) {
            logger.warning("Problem reading entries in " + this.locationFile + ", check your index settings, first column = 0.");
            throw new HandleError(cce);
        }
        catch (NullPointerException npe) {
            logger.warning("Problem reading location file, check " + this.locationFile);
            throw new HandleError(npe);
        }
        catch (AccessControlException ace) {
            throw new HandleError(ace);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("CSVLocationHandler | Finished File:" + this.locationFile + ", read " + lineCount + " locations");
        }
        if (lineCount == 0 && readHeader) {
            logger.fine("CSVLocationHandler has read file, but didn't find any data.\n  Check file for a header line, and make sure that the\n  properties (csvFileHasHeader) is set properly for this CSVLocationHandler. Trying again without header...");
            this.csvHasHeader = !this.csvHasHeader;
            return this.createData();
        }
        return qt;
    }

    protected void createLocation(List recordList, QuadTree<Location> qt) {
        String name = this.tokenToString(recordList, this.nameIndex, "");
        double lat = this.tokenToDouble(recordList, this.latIndex, 0.0);
        double lon = this.tokenToDouble(recordList, this.lonIndex, 0.0, this.eastIsNeg);
        String iconURL = this.tokenToString(recordList, this.iconIndex, this.defaultIconURL);
        qt.put(lat, lon, this.createLocation(lat, lon, name, iconURL, recordList));
    }

    protected Location createLocation(double lat, double lon, String name, String iconURL, List recordList) {
        URLRasterLocation loc = new URLRasterLocation(lat, lon, name, iconURL);
        loc.setShowName(this.isShowNames());
        loc.setShowLocation(this.isShowLocations());
        loc.setLocationHandler(this);
        this.getLocationDrawingAttributes().setTo(loc.getLocationMarker());
        this.getNameDrawingAttributes().setTo(loc.getLabel());
        loc.setDetails(name + " is at lat: " + lat + ", lon: " + lon);
        if (iconURL != null) {
            loc.setDetails(loc.getDetails() + " icon: " + iconURL);
        }
        logger.fine("CSVLocationHandler " + loc.getDetails());
        return loc;
    }

    protected String tokenToString(List recordList, int index, String def) {
        try {
            Object obj = recordList.get(index);
            if (obj != null) {
                return obj.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    protected double tokenToDouble(List recordList, int index, double def) {
        try {
            Object obj = recordList.get(index);
            if (obj instanceof Double) {
                return (Double)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    protected double tokenToDouble(List recordList, int index, double def, boolean swapSign) {
        Double ret = this.tokenToDouble(recordList, index, def);
        return swapSign ? -1.0 * ret : ret;
    }

    @Override
    public OMGraphicList get(double nwLat, double nwLon, double seLat, double seLon, OMGraphicList graphicList) {
        if (graphicList == null) {
            graphicList = new OMGraphicList();
            graphicList.setTraverseMode(1);
        }
        if (this.quadtree == null) {
            logger.fine("CSVLocationHandler: Figuring out the locations and names! (This is a one-time operation!)");
            this.quadtree = this.createData();
        }
        if (this.quadtree != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("CSVLocationHandler|CSVLocationHandler.get() ul.lon = " + nwLon + " lr.lon = " + seLon + " delta = " + (seLon - nwLon));
            }
            ArrayList hits = new ArrayList();
            this.quadtree.get(nwLat, nwLon, seLat, seLon, hits);
            graphicList.addAll(hits);
        }
        return graphicList;
    }

    @Override
    public List<Component> getItemsForPopupMenu(Location loc) {
        ArrayList<Component> menuItems = new ArrayList<Component>();
        menuItems.add(new LocationCBMenuItem("Always Show Name", loc));
        menuItems.add(new LocationMenuItem("Show Details", loc));
        return menuItems;
    }

    @Override
    public Component getGUI() {
        if (this.box == null) {
            JCheckBox showLocationCheck = new JCheckBox("Show Locations", this.isShowLocations());
            showLocationCheck.setActionCommand("showLocations");
            showLocationCheck.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JCheckBox locationCheck = (JCheckBox)ae.getSource();
                    CSVLocationHandler.this.setShowLocations(locationCheck.isSelected());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("CSVLocationHandler::actionPerformed showLocations is " + CSVLocationHandler.this.isShowLocations());
                    }
                    CSVLocationHandler.this.getLayer().repaint();
                }
            });
            showLocationCheck.setToolTipText("<HTML><BODY>Show location markers on the map.</BODY></HTML>");
            JCheckBox showNameCheck = new JCheckBox("Show Location Names", this.isShowNames());
            showNameCheck.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JCheckBox namesCheck = (JCheckBox)ae.getSource();
                    CSVLocationHandler.this.setShowNames(namesCheck.isSelected());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("CSVLocationHandler::actionPerformed showNames is " + CSVLocationHandler.this.isShowNames());
                    }
                    LocationLayer ll = CSVLocationHandler.this.getLayer();
                    if (namesCheck.isSelected() && ll.getDeclutterMatrix() != null && ll.getUseDeclutterMatrix()) {
                        ll.doPrepare();
                    } else {
                        ll.repaint();
                    }
                }
            });
            showNameCheck.setToolTipText("<HTML><BODY>Show location names on the map.</BODY></HTML>");
            JCheckBox forceGlobalCheck = new JCheckBox("Override Location Settings", this.isForceGlobal());
            forceGlobalCheck.setActionCommand("forceGlobal");
            forceGlobalCheck.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JCheckBox forceGlobalCheck = (JCheckBox)ae.getSource();
                    CSVLocationHandler.this.setForceGlobal(forceGlobalCheck.isSelected());
                    CSVLocationHandler.this.getLayer().repaint();
                }
            });
            forceGlobalCheck.setToolTipText("<HTML><BODY>Make these settings override those set<BR>on the individual map objects.</BODY></HTML>");
            JButton rereadFilesButton = new JButton("Reload Data From Source");
            rereadFilesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Re-reading Locations file");
                    }
                    CSVLocationHandler.this.quadtree = null;
                    CSVLocationHandler.this.getLayer().doPrepare();
                }
            });
            rereadFilesButton.setToolTipText("<HTML><BODY>Reload the data file, and put these settings<br>on the individual map objects.</BODY></HTML>");
            this.box = Box.createVerticalBox();
            this.box.add(showLocationCheck);
            this.box.add(showNameCheck);
            this.box.add(forceGlobalCheck);
            this.box.add(rereadFilesButton);
        }
        return this.box;
    }
}

