/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.mif;

import com.bbn.openmap.layer.mif.MIFException;
import com.bbn.openmap.layer.mif.MIFPoint;
import com.bbn.openmap.layer.mif.MIFText;
import com.bbn.openmap.layer.mif.OMSubtraction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.util.Debug;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class MIFLoader {
    static final int PROCESS_HEADER = 0;
    static final int PROCESS_DATA = 1;
    static final int PROCESS_PLINE = 2;
    static final int PROCESS_POST_PLINE = 3;
    static final int PROCESS_MULTIPLE = 4;
    static final int PROCESS_REGION = 5;
    static final int PROCESS_REGION_HEADER = 6;
    static final int PROCESS_POST_REGION = 7;
    static final int PROCESS_POST_LINE = 8;
    static final String DATA_WORD = "Data";
    static final String VERSION_WORD = "Version";
    static final String DELIMITER_WORD = "Delimiter";
    static final String COORDSYS_WORD = "Coordsys";
    static final String PLINE_WORD = "PLine";
    static final String LINE_WORD = "Line";
    static final String MULTIPLE_WORD = "Multiple";
    static final String PEN_WORD = "Pen";
    static final String SMOOTH_WORD = "Smooth";
    static final String REGION_WORD = "Region";
    static final String BRUSH_WORD = "Brush";
    static final String CENTER_WORD = "Center";
    static final String POINT_WORD = "Point";
    static final String TEXT_WORD = "Text";
    BufferedReader br;
    OMGraphicList list;
    boolean accurate;
    private static final String LATLONG_COORDSYS_DEF = "Earth Projection 1";
    private float pointVisible = -1.0f;
    private float textVisible = -1.0f;

    public MIFLoader(BufferedReader br, boolean accurate, float textVisible, float pointVisible) {
        this.br = br;
        this.accurate = accurate;
        this.pointVisible = pointVisible;
        this.textVisible = textVisible;
    }

    public boolean isLoaded() {
        return this.list != null;
    }

    public OMGraphicList getList() {
        return this.getList(false);
    }

    public OMGraphicList getList(boolean reloadList) {
        try {
            if (reloadList || !this.isLoaded()) {
                if (this.isLoaded()) {
                    this.list.clear();
                }
                this.list = this.loadFile();
            }
            return this.list;
        }
        catch (IOException ioe) {
            this.list = null;
            return null;
        }
    }

    public OMGraphicList loadFile() throws IOException, MIFException {
        double[] ptarray = null;
        double[] latpts = null;
        double[] lonpts = null;
        int action = 0;
        int number = 0;
        int count = 0;
        int multiple = 0;
        int multicnt = 0;
        StringTokenizer st = null;
        String tok = null;
        boolean pushback = false;
        OMPoly omp = null;
        OMLine oml = null;
        MIFPoint ompoint = null;
        MIFText omtext = null;
        boolean ismultiple = false;
        OMGraphicList aList = new OMGraphicList();
        Vector<OMGraphicAdapter> omgs = new Vector<OMGraphicAdapter>();
        block11: while (true) {
            if (!pushback) {
                st = this.getTokens(this.br);
                if (st == null) break;
                tok = st.nextToken();
            } else {
                pushback = false;
            }
            switch (action) {
                case 0: {
                    if (this.isSame(tok, DATA_WORD)) {
                        action = 1;
                        continue block11;
                    }
                    if (this.isSame(tok, VERSION_WORD) || this.isSame(tok, DELIMITER_WORD) || !this.isSame(tok, COORDSYS_WORD)) continue block11;
                    StringBuilder sb = new StringBuilder(COORDSYS_WORD);
                    while (st != null && st.hasMoreElements()) {
                        sb.append(' ').append(st.nextElement());
                    }
                    String coordSysLine = sb.toString();
                    String goodCoordSys = "Coordsys Earth Projection 1";
                    if (goodCoordSys.length() < coordSysLine.length()) {
                        coordSysLine = coordSysLine.substring(0, goodCoordSys.length());
                    } else {
                        goodCoordSys = goodCoordSys.substring(0, coordSysLine.length());
                    }
                    if (this.isSame(coordSysLine, goodCoordSys)) continue block11;
                    Debug.error("MIFLoader file has coordinate system: " + coordSysLine + ", requires " + goodCoordSys);
                    throw new MIFException("File appears to contain objects with an incompatible coordinate system (Must be Lat/Lon).");
                }
                case 1: {
                    omgs.clear();
                    if (st == null) continue block11;
                    if (this.isSame(tok, PLINE_WORD)) {
                        tok = st.nextToken();
                        if (this.isSame(tok, MULTIPLE_WORD)) {
                            multiple = Integer.parseInt(st.nextToken());
                            multicnt = 0;
                            action = 4;
                            ismultiple = true;
                            continue block11;
                        }
                        number = Integer.parseInt(tok);
                        ptarray = new double[number + number];
                        count = 0;
                        action = 2;
                        continue block11;
                    }
                    if (this.isSame(tok, REGION_WORD)) {
                        multiple = Integer.parseInt(st.nextToken());
                        multicnt = 0;
                        action = 6;
                        continue block11;
                    }
                    if (this.isSame(tok, LINE_WORD)) {
                        float lon1 = Float.parseFloat(st.nextToken());
                        float lat1 = Float.parseFloat(st.nextToken());
                        float lon2 = Float.parseFloat(st.nextToken());
                        float lat2 = Float.parseFloat(st.nextToken());
                        oml = new OMLine(lat1, lon1, lat2, lon2, 1);
                        action = 8;
                        continue block11;
                    }
                    if (this.isSame(tok, POINT_WORD)) {
                        float lon1 = Float.parseFloat(st.nextToken());
                        float lat1 = Float.parseFloat(st.nextToken());
                        ompoint = new MIFPoint(lat1, lon1, this.pointVisible);
                        st = this.getTokens(this.br);
                        this.processSymbolWord(st, ompoint);
                        aList.add(ompoint);
                        action = 1;
                        continue block11;
                    }
                    if (!this.isSame(tok, TEXT_WORD)) continue block11;
                    StringBuilder sb = new StringBuilder();
                    if (st.countTokens() < 1) {
                        st = this.getTokens(this.br);
                    }
                    while (st != null && st.hasMoreTokens()) {
                        sb.append(st.nextToken());
                    }
                    String textString = sb.toString();
                    if (textString.length() >= 1) {
                        textString = textString.substring(1, textString.length() - 1);
                    }
                    st = this.getTokens(this.br);
                    float lon1 = Float.parseFloat(st.nextToken());
                    float lat1 = Float.parseFloat(st.nextToken());
                    Float.parseFloat(st.nextToken());
                    Float.parseFloat(st.nextToken());
                    omtext = new MIFText(lat1, lon1, textString, 1, this.textVisible);
                    st = this.getTokens(this.br);
                    this.processFontWord(st, omtext);
                    aList.add(omtext);
                    action = 1;
                    continue block11;
                }
                case 2: {
                    int idx = count + count;
                    if (ptarray == null || st == null) continue block11;
                    ptarray[idx + 1] = Float.parseFloat(tok);
                    ptarray[idx] = Float.parseFloat(st.nextToken());
                    if (++count != number) continue block11;
                    omp = new OMPoly(ptarray, 0, 1);
                    aList.add(omp);
                    if (!ismultiple) {
                        action = 3;
                        continue block11;
                    }
                    omgs.add(omp);
                    action = 4;
                    continue block11;
                }
                case 4: {
                    if (++multicnt > multiple) {
                        pushback = true;
                        multiple = 0;
                        action = 3;
                        continue block11;
                    }
                    number = Integer.parseInt(tok);
                    count = 0;
                    ptarray = new double[number + number];
                    action = 2;
                    continue block11;
                }
                case 3: {
                    if (this.isSame(tok, PEN_WORD)) {
                        if (ismultiple) {
                            this.processPenWord(st, omgs);
                            continue block11;
                        }
                        this.processPenWord(st, omp);
                        continue block11;
                    }
                    if (this.isSame(tok, SMOOTH_WORD)) continue block11;
                    ismultiple = false;
                    pushback = true;
                    action = 1;
                    continue block11;
                }
                case 8: {
                    if (this.isSame(tok, PEN_WORD)) {
                        this.processPenWord(st, oml);
                        aList.add(oml);
                        continue block11;
                    }
                    ismultiple = false;
                    pushback = true;
                    action = 1;
                    continue block11;
                }
                case 6: {
                    if (++multicnt > multiple) {
                        multiple = 0;
                        action = 7;
                        int len = omgs.size();
                        int i = 0;
                        while (true) {
                            if (i >= len) continue block11;
                            aList.add((OMGraphic)omgs.elementAt(i));
                            ++i;
                        }
                    }
                    number = Integer.parseInt(tok);
                    count = 0;
                    ptarray = new double[number + number];
                    latpts = new double[number];
                    lonpts = new double[number];
                    action = 5;
                    continue block11;
                }
                case 5: {
                    int idx = count + count;
                    if (ptarray == null || lonpts == null || latpts == null || st == null) continue block11;
                    double d = Float.parseFloat(tok);
                    ptarray[idx + 1] = d;
                    lonpts[count] = d;
                    latpts[count] = ptarray[idx] = (double)Float.parseFloat(st.nextToken());
                    if (++count != number) continue block11;
                    if (this.accurate) {
                        omgs.add(new OMSubtraction(latpts, lonpts));
                    } else {
                        int end = latpts.length - 1;
                        for (int i = 0; i < end; ++i) {
                            omgs.add(new OMLine(latpts[i], lonpts[i], latpts[i + 1], lonpts[i + 1], 1));
                        }
                        omgs.add(new OMLine(latpts[end], lonpts[end], latpts[0], lonpts[0], 1));
                    }
                    action = 6;
                    continue block11;
                }
                case 7: {
                    if (this.isSame(tok, PEN_WORD)) {
                        this.processPenWord(st, omgs);
                        continue block11;
                    }
                    if (this.isSame(tok, BRUSH_WORD)) {
                        this.processBrushWord(st, omgs);
                        continue block11;
                    }
                    if (this.isSame(tok, CENTER_WORD)) continue block11;
                    pushback = true;
                    action = 1;
                    continue block11;
                }
            }
        }
        this.br.close();
        return aList;
    }

    private void processPenWord(StringTokenizer st, OMGraphic omg) {
        if (omg == null) {
            return;
        }
        int width = Integer.parseInt(st.nextToken());
        omg.setStroke(new BasicStroke(width));
        Integer.parseInt(st.nextToken());
        Color col = this.convertColor(Integer.parseInt(st.nextToken()));
        omg.setLinePaint(col);
    }

    private void processPenWord(StringTokenizer st, Vector vals) {
        int width = Integer.parseInt(st.nextToken());
        Integer.parseInt(st.nextToken());
        Color col = this.convertColor(Integer.parseInt(st.nextToken()));
        int len = vals.size();
        OMGraphic omg = null;
        for (int i = 0; i < len; ++i) {
            omg = (OMGraphic)vals.elementAt(i);
            omg.setLinePaint(col);
            omg.setStroke(new BasicStroke(width));
        }
    }

    private void processBrushWord(StringTokenizer st, Vector vals) {
        int pattern = Integer.parseInt(st.nextToken());
        Color foreground = this.convertColor(Integer.parseInt(st.nextToken()));
        int len = vals.size();
        block4: for (int i = 0; i < len; ++i) {
            OMGraphic omg = (OMGraphic)vals.elementAt(i);
            omg.setLinePaint(foreground);
            switch (pattern) {
                case 1: {
                    continue block4;
                }
                case 2: {
                    omg.setFillPaint(foreground);
                }
            }
        }
    }

    private void processSymbolWord(StringTokenizer st, OMPoint omg) {
        st.nextToken();
        Integer.parseInt(st.nextToken());
        Color color = this.convertColor(Integer.parseInt(st.nextToken()));
        Integer.parseInt(st.nextToken());
        omg.setFillPaint(color);
    }

    private void processFontWord(StringTokenizer st, OMText omTxt) {
        st.nextToken();
        String fontName = st.nextToken();
        int style = Integer.parseInt(st.nextToken());
        Integer.parseInt(st.nextToken());
        Color foreColor = this.convertColor(Integer.parseInt(st.nextToken()));
        int fontStyle = 0;
        switch (style) {
            case 0: {
                fontStyle = 0;
                break;
            }
            case 1: {
                fontStyle = 1;
                break;
            }
            case 2: {
                fontStyle = 2;
                break;
            }
            case 3: {
                fontStyle = 0;
            }
        }
        omTxt.setFillPaint(foreColor);
        omTxt.setFont(new Font(fontName.substring(1, fontName.length() - 1), fontStyle, 10));
    }

    private StringTokenizer getTokens(BufferedReader br) throws IOException {
        String line;
        while ((line = br.readLine()) != null) {
            if (line.length() == 0) continue;
            return new StringTokenizer(line, " \t\n\r\f,()");
        }
        return null;
    }

    private boolean isSame(String str1, String str2) {
        return str1.equalsIgnoreCase(str2);
    }

    private Color convertColor(int val) {
        int red = 0;
        int green = 0;
        int blue = 0;
        int rem = val;
        if (rem >= 65536) {
            red = rem / 65536;
            rem -= red * 65536;
        }
        if (rem >= 255) {
            green = rem / 256;
            rem -= green * 256;
        }
        if (rem > 0) {
            blue = rem;
        }
        return new Color(red, green, blue);
    }
}

