/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.rpf.RpfFileSections;
import com.bbn.openmap.layer.rpf.RpfHeader;
import com.bbn.openmap.util.Debug;
import java.io.FileNotFoundException;
import java.io.IOException;

public class RpfAttributes {
    public String currencyDate;
    public String productionDate;
    public String significantDate;
    public String chartSeriesCode;
    public String mapDesignationCode;
    public String oldHorDatum;
    public String edition;
    public String projectionCode;
    public float projectionA;
    public float projectionB;
    public float projectionC;
    public float projectionD;
    public String vertDatumCode;
    public String horDatumCode;
    public long vertAbsAccuracy;
    public int vertAbsUnits;
    public long horAbsAccuracy;
    public int horAbsUnits;
    public long vertRelAccuracy;
    public int vertRelUnits;
    public long horRelAccuracy;
    public int horRelUnits;
    public String ellipsoidCode;
    public String soundingDatumCode;
    public int navSystemCode;
    public String gridCode;
    public float eMagChange;
    public int eMagChangeUnits;
    public float wMagChange;
    public int wMagChangeUnits;
    public float magAngle;
    public int magAngleUnits;
    public float gridConver;
    public int gridConverUnits;
    public double highElevation;
    public int highElevationUnits;
    public double highLat;
    public double highLon;
    public String legendFileName;
    public String dataSource;
    public long gsd;
    public int dataLevel;

    public boolean read(BinaryFile binFile, long attributeLocation) {
        try {
            long j = 0L;
            AttributeSubheader attributeSubheader = new AttributeSubheader();
            binFile.seek(attributeLocation);
            attributeSubheader.read(binFile);
            if (Debug.debugging("rpfdetail")) {
                System.out.println(attributeSubheader);
            }
            AttributeOffsetRecord[] attributeOffsetRecords = new AttributeOffsetRecord[attributeSubheader.numAttributes];
            int i = attributeSubheader.numAttributes - 1;
            j = 0L;
            for (int attIndex = attributeSubheader.numAttributes; attIndex > 0; --attIndex) {
                i = attIndex - 1;
                long k = attributeLocation + 10L + attributeSubheader.tableOffset + (long)((attributeSubheader.numAttributes - attIndex) * 8);
                binFile.seek(k);
                attributeOffsetRecords[i] = new AttributeOffsetRecord();
                attributeOffsetRecords[i].read(binFile);
                if (!Debug.debugging("rpfdetail")) continue;
                Debug.output(" ##" + ++j + " at " + k + " => attrib ID '" + attributeOffsetRecords[i].attributeId + "'|Param ID '" + attributeOffsetRecords[i].parameterId + "'|offset '" + attributeOffsetRecords[i].offset + "'");
            }
            block29: for (i = attributeOffsetRecords.length - 1; i >= 0; --i) {
                AttributeOffsetRecord attributeOffsetRecord = attributeOffsetRecords[i];
                binFile.seek(attributeLocation + 10L + attributeOffsetRecord.offset);
                switch (attributeOffsetRecord.attributeId) {
                    case 1: {
                        this.currencyDate = binFile.readFixedLengthString(8);
                        continue block29;
                    }
                    case 2: {
                        this.productionDate = binFile.readFixedLengthString(8);
                        continue block29;
                    }
                    case 3: {
                        this.significantDate = binFile.readFixedLengthString(8);
                        continue block29;
                    }
                    case 4: {
                        if (attributeOffsetRecord.parameterId == 1) {
                            this.chartSeriesCode = binFile.readFixedLengthString(10);
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId == 2) {
                            this.mapDesignationCode = binFile.readFixedLengthString(8);
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId == 3) {
                            this.oldHorDatum = binFile.readFixedLengthString(4);
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId != 4) continue block29;
                        this.edition = binFile.readFixedLengthString(7);
                        continue block29;
                    }
                    case 5: {
                        if (attributeOffsetRecord.parameterId == 1) {
                            this.projectionCode = binFile.readFixedLengthString(2);
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId == 2) {
                            this.projectionA = binFile.readFloat();
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId == 3) {
                            this.projectionB = binFile.readFloat();
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId == 4) {
                            this.projectionC = binFile.readFloat();
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId != 5) continue block29;
                        this.projectionD = binFile.readFloat();
                        continue block29;
                    }
                    case 6: {
                        this.vertDatumCode = binFile.readFixedLengthString(4);
                        continue block29;
                    }
                    case 7: {
                        this.horDatumCode = binFile.readFixedLengthString(4);
                        continue block29;
                    }
                    case 8: {
                        if (attributeOffsetRecord.parameterId == 1) {
                            this.vertAbsAccuracy = binFile.readInteger();
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId != 2) continue block29;
                        this.vertAbsUnits = binFile.readShort();
                        continue block29;
                    }
                    case 9: {
                        if (attributeOffsetRecord.parameterId == 1) {
                            this.horAbsAccuracy = binFile.readInteger();
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId != 2) continue block29;
                        this.horAbsUnits = binFile.readShort();
                        continue block29;
                    }
                    case 10: {
                        if (attributeOffsetRecord.parameterId == 1) {
                            this.vertRelAccuracy = binFile.readInteger();
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId != 2) continue block29;
                        this.vertRelUnits = binFile.readShort();
                        continue block29;
                    }
                    case 11: {
                        if (attributeOffsetRecord.parameterId == 1) {
                            this.horRelAccuracy = binFile.readInteger();
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId != 2) continue block29;
                        this.horRelUnits = binFile.readShort();
                        continue block29;
                    }
                    case 12: {
                        this.ellipsoidCode = binFile.readFixedLengthString(3);
                        continue block29;
                    }
                    case 13: {
                        this.soundingDatumCode = binFile.readFixedLengthString(4);
                        continue block29;
                    }
                    case 14: {
                        this.navSystemCode = binFile.readShort();
                        continue block29;
                    }
                    case 15: {
                        this.gridCode = binFile.readFixedLengthString(2);
                        continue block29;
                    }
                    case 16: {
                        if (attributeOffsetRecord.parameterId == 1) {
                            this.eMagChange = binFile.readFloat();
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId != 2) continue block29;
                        this.eMagChangeUnits = binFile.readShort();
                        continue block29;
                    }
                    case 17: {
                        if (attributeOffsetRecord.parameterId == 1) {
                            this.wMagChange = binFile.readFloat();
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId != 2) continue block29;
                        this.wMagChangeUnits = binFile.readShort();
                        continue block29;
                    }
                    case 18: {
                        if (attributeOffsetRecord.parameterId == 1) {
                            this.magAngle = binFile.readFloat();
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId != 2) continue block29;
                        this.magAngleUnits = binFile.readShort();
                        continue block29;
                    }
                    case 19: {
                        if (attributeOffsetRecord.parameterId == 1) {
                            this.gridConver = binFile.readFloat();
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId != 2) continue block29;
                        this.gridConverUnits = binFile.readShort();
                        continue block29;
                    }
                    case 20: {
                        if (attributeOffsetRecord.parameterId == 1) {
                            this.highElevation = binFile.readDouble();
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId == 2) {
                            this.highElevationUnits = binFile.readShort();
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId == 3) {
                            this.highLat = binFile.readDouble();
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId != 4) continue block29;
                        this.highLon = binFile.readDouble();
                        continue block29;
                    }
                    case 21: {
                        this.legendFileName = binFile.readFixedLengthString(12);
                        continue block29;
                    }
                    case 22: {
                        if (attributeOffsetRecord.parameterId == 1) {
                            this.dataSource = binFile.readFixedLengthString(12);
                            continue block29;
                        }
                        if (attributeOffsetRecord.parameterId != 2) continue block29;
                        this.gsd = binFile.readInteger();
                        continue block29;
                    }
                    case 23: {
                        this.dataLevel = binFile.readShort();
                    }
                }
            }
        }
        catch (IOException e) {
            Debug.error("RpfAttributes: read(): File IO Error!\n" + e);
            return false;
        }
        catch (FormatException f) {
            Debug.error("RpfAttributes: read(): File IO Format error!\n" + f);
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Attribute Section:\n");
        s.append(" currency date = ").append(this.currencyDate).append("\n");
        s.append(" production date = ").append(this.productionDate).append("\n");
        s.append(" significant date = ").append(this.significantDate).append("\n");
        s.append(" chart series code = ").append(this.chartSeriesCode).append("\n");
        s.append(" map designation code = ").append(this.mapDesignationCode).append("\n");
        s.append(" old horizontal datum = ").append(this.oldHorDatum).append("\n");
        s.append(" edition = ").append(this.edition).append("\n");
        s.append(" projection code = ").append(this.projectionCode).append("\n");
        s.append(" projection A = ").append(this.projectionA).append("\n");
        s.append(" projection B = ").append(this.projectionB).append("\n");
        s.append(" projection C = ").append(this.projectionC).append("\n");
        s.append(" projection D = ").append(this.projectionD).append("\n");
        s.append(" vertical datum code = ").append(this.vertDatumCode).append("\n");
        s.append(" horizontal datum code = ").append(this.horDatumCode).append("\n");
        s.append(" vertical absolute accuracy = ").append(this.vertAbsAccuracy).append("\n");
        s.append(" vertical absolute units = ").append(this.vertAbsUnits).append("\n");
        s.append(" horizontal absolute accuracy = ").append(this.horAbsAccuracy).append("\n");
        s.append(" horizontal absolute units = ").append(this.horAbsUnits).append("\n");
        s.append(" vertical relative accuracy = ").append(this.vertRelAccuracy).append("\n");
        s.append(" vertical relative units = ").append(this.vertRelUnits).append("\n");
        s.append(" horizontal relative accuracy = ").append(this.horRelAccuracy).append("\n");
        s.append(" horizontal relative units = ").append(this.horRelUnits).append("\n");
        s.append(" ellipsoid code = ").append(this.ellipsoidCode).append("\n");
        s.append(" sounding datum code = ").append(this.soundingDatumCode).append("\n");
        s.append(" nav system code = ").append(this.navSystemCode).append("\n");
        s.append(" grid code = ").append(this.gridCode).append("\n");
        s.append(" east mag change = ").append(this.eMagChange).append("\n");
        s.append(" east mag change units = ").append(this.eMagChangeUnits).append("\n");
        s.append(" west mag change = ").append(this.wMagChange).append("\n");
        s.append(" west mag units = ").append(this.wMagChangeUnits).append("\n");
        s.append(" magnetic angle = ").append(this.magAngle).append("\n");
        s.append(" magnetic angle units = ").append(this.magAngleUnits).append("\n");
        s.append(" grid conversion = ").append(this.gridConver).append("\n");
        s.append(" grid conversion units = ").append(this.gridConverUnits).append("\n");
        s.append(" high elevation = ").append(this.highElevation).append("\n");
        s.append(" high elevation units = ").append(this.highElevationUnits).append("\n");
        s.append(" high latitude = ").append(this.highLat).append("\n");
        s.append(" high longitude = ").append(this.highLon).append("\n");
        s.append(" legend file name = ").append(this.legendFileName).append("\n");
        s.append(" data source = ").append(this.dataSource).append("\n");
        s.append(" gsd = ").append(this.gsd).append("\n");
        s.append(" data level = ").append(this.dataLevel).append("\n");
        return s.toString();
    }

    public static RpfAttributes getAttributes(String filename) throws IOException, FileNotFoundException {
        BinaryBufferedFile binFile = new BinaryBufferedFile(filename);
        RpfHeader head = new RpfHeader();
        head.read(binFile);
        RpfAttributes att = RpfAttributes.getAttributes(binFile);
        binFile.close();
        head = null;
        return att;
    }

    public static RpfAttributes getAttributes(BinaryFile binFile) throws IOException, FileNotFoundException {
        RpfFileSections rfs = new RpfFileSections(binFile);
        RpfAttributes att = rfs.parseAttributes(binFile);
        return att;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java RpfAttributes <path to RPF frame>");
            return;
        }
        Debug.init(System.getProperties());
        try {
            RpfAttributes att = RpfAttributes.getAttributes(args[0]);
            Debug.output(att.toString());
        }
        catch (FileNotFoundException e) {
            Debug.error("RpfAttributes: file " + args[0] + " not found");
        }
        catch (IOException ioe) {
            Debug.error("RpfAttributes: File IO Error while handling attributes: \n" + ioe);
        }
    }

    public static class AttributeOffsetRecord {
        int attributeId;
        int parameterId;
        int sequenceNum;
        long offset;

        public void read(BinaryFile binFile) {
            try {
                this.attributeId = binFile.readShort();
                this.parameterId = binFile.read();
                this.sequenceNum = binFile.read();
                this.offset = binFile.readInteger();
            }
            catch (IOException e) {
                Debug.error("AttributeOffsetRecord: read(): File IO Error!\n" + e);
            }
            catch (FormatException f) {
                Debug.error("AttributeOffsetRecord: read(): File IO Format error!\n" + f);
            }
        }
    }

    public static class AttributeSubheader {
        int numAttributes;
        int numArealRecords;
        long tableOffset;
        int offsetRecordLength;

        public void read(BinaryFile binFile) {
            try {
                this.numAttributes = binFile.readShort();
                this.numArealRecords = binFile.readShort();
                this.tableOffset = binFile.readInteger();
                this.offsetRecordLength = binFile.readShort();
            }
            catch (IOException e) {
                Debug.error("AttributeSubheader: read(): File IO Error!\n" + e);
            }
            catch (FormatException f) {
                Debug.error("AttributeSubheader: read(): File IO Format error!\n" + f);
            }
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("## RPF ATTRIBUTE INFORMATION\n");
            s.append("Number of Attributes - ").append(this.numAttributes).append("\n");
            s.append("Number of Areal Records - ").append(this.numArealRecords).append("\n");
            s.append("Size of offset - ").append(this.tableOffset).append("\n");
            s.append("Record Length - ").append(this.offsetRecordLength).append("\n");
            return s.toString();
        }
    }
}

