/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoordTupleString;
import java.io.EOFException;

public class CoordDoubleString
implements CoordTupleString {
    private final double[][] vals;

    public CoordDoubleString(int tuplecount, int tuplesize, BinaryFile input) throws FormatException {
        try {
            this.vals = new double[tuplecount][tuplesize];
            for (int i = 0; i < tuplecount; ++i) {
                for (int j = 0; j < tuplesize; ++j) {
                    this.vals[i][j] = input.readDouble();
                }
            }
        }
        catch (EOFException e) {
            throw new FormatException("CoordDoubleString EOFException");
        }
    }

    public int maxIndex() {
        return this.vals.length;
    }

    public Number getPrimitiveType() {
        return new Double(0.0);
    }

    public String toString() {
        StringBuffer retval = new StringBuffer("CDS:");
        retval.append(this.vals.length).append("[");
        for (int i = 0; i < this.vals.length; ++i) {
            retval.append("(");
            for (int j = 0; j < this.vals[i].length; ++j) {
                retval.append(this.vals[i][j]).append(", ");
            }
            retval.append(") ");
        }
        retval.append("]");
        return retval.toString();
    }

    public float getXasFloat(int tuple) {
        return (float)this.vals[tuple][0];
    }

    public double getXasDouble(int tuple) {
        return this.vals[tuple][0];
    }

    public float getYasFloat(int tuple) {
        return (float)this.vals[tuple][1];
    }

    public double getYasDouble(int tuple) {
        return this.vals[tuple][1];
    }

    public float getZasFloat(int tuple) {
        if (this.vals[tuple].length >= 3) {
            return (float)this.vals[tuple][2];
        }
        return 0.0f;
    }

    public double getZasDouble(int tuple) {
        if (this.vals[tuple].length >= 3) {
            return this.vals[tuple][2];
        }
        return 0.0;
    }

    public float[] getasFloat(int tuple) {
        int tusize = this.vals[tuple].length;
        float[] rv = new float[tusize];
        for (int i = 0; i < tusize; ++i) {
            rv[i] = (float)this.vals[tuple][i];
        }
        return rv;
    }

    public double[] getasDouble(int tuple) {
        return this.vals[tuple];
    }

    public float getasFloat(int tuple, int val) {
        return (float)this.vals[tuple][val];
    }

    public double getasDouble(int tuple, int val) {
        return this.vals[tuple][val];
    }
}

