/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import java.io.EOFException;
import java.io.IOException;

public class DcwCrossTileID {
    public final int currentTileKey;
    public final int nextTileID;
    public final int nextTileKey;

    public DcwCrossTileID(int currentTileKey, int nextTileID, int nextTileKey) {
        this.currentTileKey = currentTileKey;
        this.nextTileID = nextTileID;
        this.nextTileKey = nextTileKey;
    }

    public DcwCrossTileID(BinaryFile in) throws FormatException, EOFException {
        int format;
        try {
            format = in.read();
        }
        catch (IOException ioe) {
            throw new FormatException(ioe.getMessage());
        }
        if (format == -1) {
            throw new EOFException();
        }
        try {
            this.currentTileKey = this.readIntegerByKey(in, format >> 6);
            this.nextTileID = this.readIntegerByKey(in, format >> 4);
            this.nextTileKey = this.readIntegerByKey(in, format >> 2);
            this.readIntegerByKey(in, format);
        }
        catch (EOFException e) {
            throw new FormatException("DcwCrossTileID: unexpected EOD " + e.getMessage());
        }
    }

    private int readIntegerByKey(BinaryFile in, int key) throws FormatException, EOFException {
        switch (key & 3) {
            case 0: {
                return -1;
            }
            case 1: {
                int byteval;
                try {
                    byteval = in.read();
                }
                catch (IOException ioe) {
                    throw new FormatException(ioe.getMessage());
                }
                if (byteval == -1) {
                    throw new EOFException();
                }
                return byteval;
            }
            case 2: {
                return MoreMath.signedToInt(in.readShort());
            }
            case 3: {
                return in.readInteger();
            }
        }
        throw new FormatException("This can't happen");
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append(this.currentTileKey).append("/");
        if (this.nextTileID != -1 && this.nextTileKey != -1) {
            output.append(this.nextTileID).append(",");
            output.append(this.nextTileKey);
        }
        return output.toString();
    }
}

