/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.layer.vpf.FeatureDrawingAttributes;
import com.bbn.openmap.layer.vpf.VPFFeatureGraphicWarehouse;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import java.awt.Paint;

public abstract class FeatureCacheGraphicList
extends OMGraphicList
implements Cloneable {
    private static final long serialVersionUID = 1L;
    protected String featureName = null;

    public FeatureCacheGraphicList() {
    }

    public FeatureCacheGraphicList(int initSize) {
        super(initSize);
    }

    public void setFeatureName(String name) {
        this.featureName = name;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public synchronized void setTo(DrawingAttributes da) {
        if (da != null) {
            for (OMGraphic omg : this) {
                da.setTo(omg);
            }
        }
    }

    public static FeatureCacheGraphicList createForType(String featureType) {
        int lastCharIndex;
        if (featureType != null && (lastCharIndex = featureType.length() - 1) >= 0) {
            if ("Edge".equals(featureType)) {
                return new EDGE();
            }
            if ("Area".equals(featureType)) {
                return new AREA();
            }
            if ("Text".equals(featureType)) {
                return new TEXT();
            }
            if ("EPoint".equals(featureType) || "CPoint".equals(featureType)) {
                return new POINT();
            }
        }
        return new DEFAULT();
    }

    public synchronized Object clone() {
        try {
            FeatureCacheGraphicList omgl = (FeatureCacheGraphicList)this.getClass().newInstance();
            omgl.setFeatureName(this.getFeatureName());
            for (OMGraphic omg : this) {
                if (omg instanceof OMGraphicList) {
                    omgl.add((OMGraphic)((OMGraphicList)omg).clone());
                    continue;
                }
                omgl.graphics.add(omg);
            }
            return omgl;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return new DEFAULT();
    }

    public abstract void setDrawingAttributes(VPFFeatureGraphicWarehouse var1);

    public static class POINT
    extends DEFAULT {
        private static final long serialVersionUID = 1L;

        public POINT() {
        }

        public POINT(int size) {
            super(size);
        }
    }

    public static class TEXT
    extends DEFAULT {
        private static final long serialVersionUID = 1L;

        public TEXT() {
        }

        public TEXT(int size) {
            super(size);
        }
    }

    public static class DEFAULT
    extends FeatureCacheGraphicList {
        private static final long serialVersionUID = 1L;

        public DEFAULT() {
        }

        public DEFAULT(int size) {
            super(size);
        }

        public synchronized void setDrawingAttributes(VPFFeatureGraphicWarehouse vfgw) {
            this.setTo(vfgw.getAttributesForFeature(this.featureName));
        }
    }

    public static class EDGE
    extends FeatureCacheGraphicList {
        private static final long serialVersionUID = 1L;

        public EDGE() {
        }

        public EDGE(int size) {
            super(size);
        }

        public synchronized void setDrawingAttributes(VPFFeatureGraphicWarehouse vfgw) {
            FeatureDrawingAttributes da = vfgw.getAttributesForFeature(this.featureName);
            da.setFillPaint(OMColor.clear);
            this.setTo(da);
        }
    }

    public static class AREA
    extends FeatureCacheGraphicList {
        private static final long serialVersionUID = 1L;

        public AREA() {
        }

        public AREA(int size) {
            super(size);
        }

        public synchronized void setDrawingAttributes(VPFFeatureGraphicWarehouse vfgw) {
            FeatureDrawingAttributes da = vfgw.getAttributesForFeature(this.featureName);
            Paint fillPaint = da.getFillPaint();
            da.setLinePaint(fillPaint);
            da.setSelectPaint(fillPaint);
            this.setTo(da);
        }
    }
}

