/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.PrimitiveTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFGraphicWarehouse;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTable
extends PrimitiveTable {
    private final int coordColumn;
    private final int firstEdgeColumn;
    private final int containingFaceColumn;
    private final boolean isEntityNode;

    public NodeTable(CoverageTable cov, TileDirectory tile, boolean isEntityNode) throws FormatException {
        super(cov, tile, isEntityNode ? "end" : "cnd");
        this.isEntityNode = isEntityNode;
        this.coordColumn = this.whatColumn("coordinate");
        if (this.coordColumn == -1) {
            throw new FormatException("nodetable couldn't get coordinate column");
        }
        this.firstEdgeColumn = this.whatColumn("first_edge");
        this.containingFaceColumn = this.whatColumn("containing_face");
    }

    public int getFirstEdgeColumn() {
        return this.firstEdgeColumn;
    }

    public int getContainingFaceColumn() {
        return this.containingFaceColumn;
    }

    @Override
    public void drawTile(VPFGraphicWarehouse warehouse, double dpplat, double dpplon, LatLonPoint ll1, LatLonPoint ll2) {
        double ll1lat = ll1.getY();
        double ll1lon = ll1.getX();
        double ll2lat = ll2.getY();
        double ll2lon = ll2.getX();
        try {
            ArrayList<Object> node = new ArrayList<Object>();
            while (this.parseRow(node)) {
                CoordFloatString coords = (CoordFloatString)node.get(this.coordColumn);
                double lat = coords.getYasFloat(0);
                double lon = coords.getXasFloat(0);
                if (!(lat > ll2lat) || !(lat < ll1lat) || !(lon > ll1lon) || !(lon < ll2lon)) continue;
                warehouse.createNode(this.covtable, this, node, lat, lon, this.isEntityNode);
            }
        }
        catch (FormatException f) {
            System.out.println("Exception: " + f.getClass() + " " + f.getMessage());
        }
    }

    @Override
    public OMGraphic drawFeature(VPFFeatureWarehouse warehouse, double dpplat, double dpplon, LatLonPoint ll1, LatLonPoint ll2, List<Object> node, String featureType, int primID) {
        if (warehouse != null) {
            double ll1lat = ll1.getY();
            double ll1lon = ll1.getX();
            double ll2lat = ll2.getY();
            double ll2lon = ll2.getX();
            CoordFloatString coords = (CoordFloatString)node.get(this.coordColumn);
            double lat = coords.getYasFloat(0);
            double lon = coords.getXasFloat(0);
            if (lat > ll2lat && lat < ll1lat && lon > ll1lon && lon < ll2lon) {
                return warehouse.createNode(this.covtable, this, node, lat, lon, this.isEntityNode, featureType, primID);
            }
        }
        return null;
    }
}

