/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class OMPoint
extends OMGraphicAdapter
implements OMGraphic,
Serializable {
    public static final int DEFAULT_RADIUS = 2;
    public static final boolean DEFAULT_ISOVAL = false;
    protected int radius = 2;
    protected int x = 0;
    protected int y = 0;
    protected double lat1 = 0.0;
    protected double lon1 = 0.0;
    protected boolean oval = false;

    public OMPoint() {
    }

    public OMPoint(double lat, double lon) {
        this(lat, lon, 2);
    }

    public OMPoint(double lat, double lon, int radius) {
        this.setRenderType(1);
        this.set(lat, lon);
        this.radius = radius;
    }

    public OMPoint(double lat, double lon, int offsetx, int offsety) {
        this(lat, lon, offsetx, offsety, 2);
    }

    public OMPoint(double lat, double lon, int offsetx, int offsety, int radius) {
        this.setRenderType(3);
        this.set(lat, lon, offsetx, offsety);
        this.radius = radius;
    }

    public OMPoint(int x, int y) {
        this(x, y, 2);
    }

    public OMPoint(int x, int y, int radius) {
        this.setRenderType(2);
        this.set(x, y);
        this.radius = radius;
    }

    public void set(double lat, double lon) {
        this.setLat(lat);
        this.setLon(lon);
    }

    public void set(double lat, double lon, int offsetx, int offsety) {
        this.setLat(lat);
        this.setLon(lon);
        this.set(offsetx, offsety);
    }

    public void set(int x, int y) {
        this.x = x;
        this.y = y;
        this.setNeedToRegenerate(true);
    }

    public void setLat(double lat) {
        this.lat1 = lat;
        this.setNeedToRegenerate(true);
    }

    public double getLat() {
        return this.lat1;
    }

    public void setLon(double lon) {
        this.lon1 = lon;
        this.setNeedToRegenerate(true);
    }

    public double getLon() {
        return this.lon1;
    }

    public void setX(int x) {
        this.x = x;
        this.setNeedToRegenerate(true);
    }

    public int getX() {
        return this.x;
    }

    public void setY(int y) {
        this.y = y;
        this.setNeedToRegenerate(true);
    }

    public int getY() {
        return this.y;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.setNeedToRegenerate(true);
    }

    public int getRadius() {
        return this.radius;
    }

    public void setOval(boolean set) {
        if (this.oval != set) {
            this.setNeedToRegenerate(true);
            this.oval = set;
        }
    }

    public boolean isOval() {
        return this.oval;
    }

    public boolean generate(Projection proj) {
        this.setNeedToRegenerate(true);
        if (proj == null) {
            Debug.message("omgraphic", "OMPoint: null projection in generate!");
            return false;
        }
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        switch (this.renderType) {
            case 2: {
                x1 = this.x - this.radius;
                y1 = this.y - this.radius;
                x2 = this.x + this.radius;
                y2 = this.y + this.radius;
                break;
            }
            case 1: 
            case 3: {
                if (!proj.isPlotable(this.lat1, this.lon1)) {
                    this.setNeedToRegenerate(true);
                    return false;
                }
                Point p1 = (Point)proj.forward(this.lat1, this.lon1, (Point2D)new Point());
                x1 = p1.x + this.x - this.radius;
                y1 = p1.y + this.y - this.radius;
                x2 = p1.x + this.x + this.radius;
                y2 = p1.y + this.y + this.radius;
                break;
            }
            case 0: {
                System.err.println("OMPoint.generate(): invalid RenderType");
                return false;
            }
        }
        if (this.oval) {
            this.setShape(new GeneralPath(new Ellipse2D.Float(Math.min(x2, x1), Math.min(y2, y1), Math.abs(x2 - x1), Math.abs(y2 - y1))));
        } else {
            this.setShape(OMPoint.createBoxShape(Math.min(x2, x1), Math.min(y2, y1), Math.abs(x2 - x1), Math.abs(y2 - y1)));
        }
        this.initLabelingDuringGenerate();
        this.setLabelLocation(new Point(x2, y1), proj);
        this.setNeedToRegenerate(false);
        return true;
    }

    public boolean hasLineTypeChoice() {
        return false;
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMPoint) {
            OMPoint point = (OMPoint)source;
            this.radius = point.radius;
            this.x = point.x;
            this.y = point.y;
            this.lat1 = point.lat1;
            this.lon1 = point.lon1;
            this.oval = point.oval;
        }
    }

    public static class Image
    extends OMPoint {
        protected java.awt.Image image;
        protected boolean useImage = true;
        protected int imageX = 0;
        protected int imageY = 0;

        public Image(double lat, double lon) {
            super(lat, lon);
        }

        public Image(double lat, double lon, int radius) {
            super(lat, lon, radius);
        }

        public Image(double lat, double lon, int offsetx, int offsety) {
            this(lat, lon, offsetx, offsety, 2);
        }

        public Image(double lat, double lon, int offsetx, int offsety, int radius) {
            super(lat, lon, offsetx, offsety, radius);
        }

        public Image(int x, int y) {
            this(x, y, 2);
        }

        public Image(int x, int y, int radius) {
            super(x, y, radius);
        }

        public java.awt.Image getImage() {
            return this.image;
        }

        public void setImage(java.awt.Image image) {
            this.image = image;
        }

        public boolean isUseImage() {
            return this.useImage;
        }

        public void setUseImage(boolean useImage) {
            this.setNeedToRegenerate(this.useImage != useImage);
            this.useImage = useImage;
        }

        public boolean generate(Projection proj) {
            if (!this.isUseImage() || this.image == null) {
                return super.generate(proj);
            }
            if (proj == null) {
                Debug.message("omgraphic", "OMPoint: null projection in generate!");
                this.setNeedToRegenerate(true);
                return false;
            }
            int imageHeight = this.image.getHeight(null);
            int imageWidth = this.image.getWidth(null);
            int imageOffsetX = imageWidth / 2;
            int imageOffsetY = imageHeight / 2;
            switch (this.renderType) {
                case 2: {
                    this.imageX = this.x - imageOffsetX;
                    this.imageY = this.y - imageOffsetY;
                    break;
                }
                case 1: 
                case 3: {
                    if (!proj.isPlotable(this.lat1, this.lon1)) {
                        this.setNeedToRegenerate(true);
                        return false;
                    }
                    Point2D p1 = proj.forward(this.lat1, this.lon1);
                    this.imageX = (int)p1.getX() + this.x - imageOffsetX;
                    this.imageY = (int)p1.getY() + this.y - imageOffsetY;
                    break;
                }
                case 0: {
                    System.err.println("OMPoint.Image.generate(): invalid RenderType");
                    return false;
                }
            }
            this.setShape(Image.createBoxShape(this.imageX, this.imageY, imageWidth, imageHeight));
            this.initLabelingDuringGenerate();
            this.setLabelLocation(new Point(this.imageX + imageWidth, this.imageY + imageOffsetY), proj);
            this.setNeedToRegenerate(false);
            return true;
        }

        public void render(Graphics g) {
            if (!this.isRenderable(this.getShape())) {
                return;
            }
            if (this.isUseImage()) {
                g.drawImage(this.image, this.imageX, this.imageY, null);
                this.renderLabel(g);
            } else {
                super.render(g);
            }
        }

        public boolean shouldRenderFill() {
            return this.isUseImage() || super.shouldRenderFill();
        }

        public void restore(OMGeometry source) {
            super.restore(source);
            if (source instanceof Image) {
                Image pntImage = (Image)source;
                this.image = pntImage.image;
                this.useImage = pntImage.useImage;
                this.imageX = pntImage.imageX;
                this.imageY = pntImage.imageY;
            }
        }
    }
}

