/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.ImageIcon;

public class OMScalingIcon
extends OMScalingRaster
implements Serializable {
    protected float baseScale;
    protected float maxScale = Float.MAX_VALUE;
    protected float minScale = 0.0f;
    protected boolean noScalingRequired = false;

    public OMScalingIcon() {
    }

    public OMScalingIcon(double centerLat, double centerLon, int offsetX, int offsetY, int w, int h, int[] pix, float baseScale) {
        super(centerLat, centerLon, 0.0, 0.0, w, h, pix);
        this.setX(offsetX);
        this.setY(offsetY);
        this.baseScale = baseScale;
    }

    public OMScalingIcon(double centerLat, double centerLon, int offsetX, int offsetY, ImageIcon ii, float baseScale) {
        this(centerLat, centerLon, offsetX, offsetY, ii.getImage(), baseScale);
    }

    public OMScalingIcon(double centerLat, double centerLon, ImageIcon ii) {
        this(centerLat, centerLon, ii.getImage());
    }

    public OMScalingIcon(double centerLat, double centerLon, int offsetX, int offsetY, Image ii, float baseScale) {
        this.setRenderType(1);
        this.setColorModel(2);
        this.lat = centerLat;
        this.lon = centerLon;
        this.setImage(ii);
        this.setX(offsetX);
        this.setY(offsetY);
        this.baseScale = baseScale;
    }

    public OMScalingIcon(double centerLat, double centerLon, Image image) {
        this(centerLat, centerLon, 0, 0, image, 4000000.0f);
        this.setMaxScale(4000000.0f);
        this.setMinScale(4000000.0f);
    }

    public OMScalingIcon(float centerLat, float centerLon, int offsetX, int offsetY, int w, int h, byte[] bytes, Color[] colorTable, int trans, float baseScale) {
        super((double)centerLat, (double)centerLon, 0.0, 0.0, w, h, bytes, colorTable, trans);
        this.setX(offsetX);
        this.setY(offsetY);
        this.baseScale = baseScale;
    }

    protected boolean position(Projection proj) {
        if (proj == null) {
            Debug.error("OMScalingIcon: null projection in position!");
            return false;
        }
        if (this.bitmap == null) {
            return false;
        }
        float shrinkScale = proj.getScale();
        if (shrinkScale > this.maxScale) {
            shrinkScale = this.maxScale;
        }
        if (shrinkScale < this.minScale) {
            shrinkScale = this.minScale;
        }
        this.noScalingRequired = this.baseScale == shrinkScale;
        float scaleFactor = this.baseScale / shrinkScale;
        this.point1 = (Point)proj.forward(this.lat, this.lon, (Point2D)new Point());
        this.point2 = (Point)proj.forward(this.lat, this.lon, (Point2D)new Point());
        int halfImageWidth = this.width / 2;
        int halfImageHeight = this.height / 2;
        int myX = this.getX();
        int myY = this.getY();
        double p1x = this.point1.getX();
        double p1y = this.point1.getY();
        double newP1x = p1x + (double)(scaleFactor * (float)(myX - halfImageWidth));
        double newP1y = p1y + (double)(scaleFactor * (float)(myY - halfImageHeight));
        this.point1.setLocation((int)newP1x, (int)newP1y);
        double p2x = this.point2.getX();
        double p2y = this.point2.getY();
        double newP2x = p2x + (double)(scaleFactor * (float)(myX + halfImageWidth));
        double newP2y = p2y + (double)(scaleFactor * (float)(myY + halfImageHeight));
        this.point2.setLocation((int)newP2x, (int)newP2y);
        this.setNeedToReposition(false);
        return true;
    }

    public boolean isOnMap(Projection proj) {
        this.generate(proj);
        GeneralPath shape = this.getShape();
        if (shape == null) {
            return false;
        }
        Point2D p1 = proj.forward((Point2D)proj.getUpperLeft());
        Point2D p2 = proj.forward((Point2D)proj.getLowerRight());
        int h = (int)(p2.getY() - p1.getY());
        int w = (int)(p2.getX() - p1.getX());
        Rectangle mapRect = new Rectangle((int)p1.getX(), (int)p1.getY(), w, h);
        return mapRect.intersects(shape.getBounds());
    }

    protected void scaleTo(Projection thisProj) {
        if (this.DEBUG) {
            logger.fine("OMScalingRaster: scaleTo()");
        }
        if (this.bitmap == null) {
            if (this.DEBUG) {
                logger.fine("scaleTo() source image is null");
            }
            return;
        }
        if (this.noScalingRequired) {
            return;
        }
        Rectangle projRect = new Rectangle();
        projRect.setLocation(this.point1);
        projRect.setSize(this.point2.x - this.point1.x, this.point2.y - this.point1.y);
        Rectangle sourceRect = new Rectangle();
        sourceRect.width = this.width;
        sourceRect.height = this.height;
        this.clipRect = null;
        if (!projRect.isEmpty() && projRect.width >= 1 && projRect.height >= 1) {
            if (sourceRect.width <= 0) {
                sourceRect.width = 1;
            }
            if (sourceRect.height <= 0) {
                sourceRect.height = 1;
            }
            double widthAdj = (double)projRect.width / (double)sourceRect.width;
            double heightAdj = (double)projRect.height / (double)sourceRect.height;
            AffineTransform xform = new AffineTransform();
            xform.setToScale(widthAdj, heightAdj);
            this.scalingXFormOp = new AffineTransformOp(xform, this.getScaleTransformType());
        }
    }

    protected void renderImage(Graphics g, Image image, Point loc) {
        if (image != null) {
            if (this.DEBUG) {
                logger.fine("drawing icon image at " + loc.x + ", " + loc.y);
            }
            if (this.noScalingRequired) {
                g.drawImage(image, loc.x, loc.y, null);
                return;
            }
            if (g instanceof Graphics2D) {
                if (image instanceof BufferedImage) {
                    ((Graphics2D)g).drawImage((BufferedImage)image, this.scalingXFormOp, loc.x, loc.y);
                } else {
                    int dx1 = loc.x;
                    int dy1 = loc.y;
                    int dx2 = this.point2.x;
                    int dy2 = this.point2.y;
                    ((Graphics2D)g).drawImage(image, dx1, dy1, dx2, dy2, 0, 0, this.width, this.height, this);
                }
            }
        } else if (this.DEBUG) {
            logger.fine("ignoring null bitmap image");
        }
    }

    public void setBaseScale(float bs) {
        this.baseScale = bs;
    }

    public float getBaseScale() {
        return this.baseScale;
    }

    public void setMaxScale(float ms) {
        this.maxScale = ms;
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public void setMinScale(float ms) {
        this.minScale = ms;
    }

    public float getMinScale() {
        return this.minScale;
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        if (source instanceof OMScalingIcon) {
            OMScalingIcon icon = (OMScalingIcon)source;
            this.baseScale = icon.baseScale;
            this.maxScale = icon.maxScale;
            this.minScale = icon.minScale;
        }
    }
}

