/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.geom;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphicConstants;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicGeometry
implements OMGeometry,
Serializable,
OMGraphicConstants {
    protected int lineType = 0;
    protected transient boolean needToRegenerate = true;
    protected Map<Object, Object> attributes;
    protected boolean visible = true;
    protected transient GeneralPath shape = null;

    @Override
    public void setLineType(int value) {
        if (this.lineType == value) {
            return;
        }
        this.setNeedToRegenerate(true);
        this.lineType = value;
    }

    @Override
    public int getLineType() {
        return this.lineType;
    }

    @Override
    public abstract int getRenderType();

    @Override
    public void setNeedToRegenerate(boolean value) {
        this.needToRegenerate = value;
        if (value) {
            this.setShape(null);
        }
    }

    @Override
    public boolean getNeedToRegenerate() {
        return this.needToRegenerate;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void select() {
    }

    @Override
    public void deselect() {
    }

    protected Map<Object, Object> createAttributeMap() {
        return Collections.synchronizedMap(new LinkedHashMap());
    }

    @Override
    public void putAttribute(Object key, Object value) {
        if (key != null) {
            this.getAttributes().put(key, value);
        }
    }

    @Override
    public Object getAttribute(Object key) {
        if (key != null) {
            return this.getAttributes().get(key);
        }
        return null;
    }

    @Override
    public Object removeAttribute(Object key) {
        if (key != null) {
            return this.getAttributes().remove(key);
        }
        return null;
    }

    @Override
    public void clearAttributes() {
        this.getAttributes().clear();
    }

    @Override
    public Map<Object, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.createAttributeMap();
        }
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<Object, Object> atts) {
        this.attributes = atts;
    }

    @Override
    public void setAppObject(Object obj) {
        this.putAttribute("APP_OBJECT", obj);
    }

    @Override
    public Object getAppObject() {
        return this.getAttribute("APP_OBJECT");
    }

    @Override
    public String getDescription() {
        String cname = this.getClass().getName();
        int lastPeriod = cname.lastIndexOf(46);
        if (lastPeriod != -1) {
            cname = cname.substring(lastPeriod + 1);
        }
        return cname;
    }

    @Override
    public abstract boolean generate(Projection var1);

    @Override
    public boolean isRenderable() {
        return this.isRenderable(this.getShape());
    }

    @Override
    public boolean isRenderable(Shape shape) {
        return !this.getNeedToRegenerate() && this.isVisible() && shape != null;
    }

    @Override
    public void fill(Graphics g) {
        this.fill(g, this.getShape());
    }

    @Override
    public void fill(Graphics g, Shape s) {
        if (s != null) {
            ((Graphics2D)g).fill(s);
        }
    }

    @Override
    public void draw(Graphics g, Shape s) {
        if (s != null) {
            ((Graphics2D)g).draw(s);
        }
    }

    @Override
    public void draw(Graphics g) {
        this.draw(g, this.getShape());
    }

    @Override
    public void render(Graphics g) {
        GeneralPath s = this.getShape();
        if (this.isRenderable(s)) {
            this.fill(g, s);
            this.draw(g, s);
        }
    }

    @Override
    public float distanceToEdge(double x, double y) {
        float distance = Float.POSITIVE_INFINITY;
        GeneralPath shape = this.getShape();
        if (!this.getNeedToRegenerate() && shape != null) {
            distance = BasicGeometry.distanceToEdge(x, y, shape);
        }
        return distance;
    }

    public static float distanceToEdge(double x, double y, Shape shape) {
        float distance = Float.POSITIVE_INFINITY;
        if (shape == null) {
            return distance;
        }
        PathIterator pi2 = shape.getPathIterator(null);
        FlatteningPathIterator pathIt = new FlatteningPathIterator(pi2, 0.25);
        double[] coords = new double[6];
        double endPntX = Double.NaN;
        double endPntY = Double.NaN;
        double lastMovedToPntX = Double.NaN;
        double lastMovedToPntY = Double.NaN;
        while (!pathIt.isDone()) {
            float dist;
            double startPntY;
            double startPntX;
            int type = pathIt.currentSegment(coords);
            if (type == 1) {
                startPntX = endPntX;
                startPntY = endPntY;
                dist = (float)Line2D.ptSegDist(startPntX, startPntY, endPntX = coords[0], endPntY = coords[1], x, y);
                if (dist < distance) {
                    distance = dist;
                }
            } else if (type == 0) {
                endPntX = coords[0];
                endPntY = coords[1];
                lastMovedToPntX = coords[0];
                lastMovedToPntY = coords[1];
            } else if (type == 4 && (dist = (float)Line2D.ptSegDist(startPntX = lastMovedToPntX, startPntY = lastMovedToPntY, endPntX = coords[0], endPntY = coords[1], x, y)) < distance) {
                distance = dist;
            }
            pathIt.next();
        }
        return distance;
    }

    @Override
    public float distance(double x, double y) {
        return this._distance(x, y);
    }

    protected float _distance(double x, double y) {
        float distance = Float.POSITIVE_INFINITY;
        GeneralPath shape = this.getShape();
        if (this.getNeedToRegenerate() || shape == null) {
            return distance;
        }
        if (shape.contains(x, y)) {
            return 0.0f;
        }
        return this.distanceToEdge(x, y);
    }

    @Override
    public boolean contains(double x, double y) {
        GeneralPath shape = this.getShape();
        boolean ret = false;
        if (shape != null) {
            ret = shape.contains(x, y);
        }
        return ret;
    }

    @Override
    public boolean regenerate(Projection proj) {
        if (proj == null) {
            return false;
        }
        if (this.getNeedToRegenerate()) {
            return this.generate(proj);
        }
        return false;
    }

    @Override
    public synchronized GeneralPath getShape() {
        return this.shape;
    }

    @Override
    public synchronized void setShape(GeneralPath gp) {
        this.shape = gp;
    }

    public static GeneralPath createShape(float[] xpoints, float[] ypoints, boolean isPolygon) {
        return BasicGeometry.createShape(xpoints, ypoints, 0, xpoints.length, isPolygon);
    }

    public static GeneralPath createShape(float[] xpoints, float[] ypoints, int startIndex, int length, boolean isPolygon) {
        if (xpoints == null || ypoints == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (length > xpoints.length - startIndex) {
            length = xpoints.length - startIndex - 1;
        }
        GeneralPath path = new GeneralPath(0, length);
        if (length > startIndex) {
            path.moveTo(xpoints[startIndex], ypoints[startIndex]);
            for (int j = startIndex + 1; j < length; ++j) {
                path.lineTo(xpoints[j], ypoints[j]);
            }
            if (isPolygon) {
                path.closePath();
            }
        }
        return path;
    }

    public static void describeShapeDetail(Shape shape) {
        BasicGeometry.describeShapeDetail(shape, 0.25);
    }

    public static void describeShapeDetail(Shape shape, double flattening) {
        PathIterator pi2 = shape.getPathIterator(null);
        FlatteningPathIterator pi = new FlatteningPathIterator(pi2, flattening);
        double[] coords = new double[6];
        int pointCount = 0;
        Debug.output(" -- start describeShapeDetail with flattening[" + flattening + "]");
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            Debug.output(" Shape point [" + type + "] (" + pointCount++ + ") " + coords[0] + ", " + coords[1]);
            pi.next();
        }
        Debug.output(" -- end (" + pointCount + ")");
    }

    public static GeneralPath appendShapeEdge(GeneralPath toShape, float[] xpoints, float[] ypoints) {
        return BasicGeometry.appendShapeEdge(toShape, xpoints, ypoints, 0, xpoints.length);
    }

    public static GeneralPath appendShapeEdge(GeneralPath toShape, float[] xpoints, float[] ypoints, int startIndex, int length) {
        return BasicGeometry.appendShapeEdge(toShape, BasicGeometry.createShape(xpoints, ypoints, startIndex, length, false));
    }

    public static GeneralPath appendShapeEdge(GeneralPath toShape, GeneralPath addShape) {
        return BasicGeometry.appendShapeEdge(toShape, addShape, true);
    }

    public static GeneralPath appendShapeEdge(GeneralPath toShape, GeneralPath addShape, boolean lineTo) {
        boolean DEBUG = Debug.debugging("arealist");
        boolean pointCount = false;
        if (addShape == null) {
            return toShape;
        }
        if (toShape == null) {
            return addShape;
        }
        toShape.append(addShape, lineTo);
        return toShape;
    }

    public static GeneralPath createBoxShape(float x, float y, int width, int height) {
        float[] xs = new float[4];
        float[] ys = new float[4];
        xs[0] = x;
        ys[0] = y;
        xs[1] = x + (float)width;
        ys[1] = y;
        xs[2] = x + (float)width;
        ys[2] = y + (float)height;
        xs[3] = x;
        ys[3] = y + (float)height;
        return BasicGeometry.createShape(xs, ys, true);
    }

    @Override
    public void restore(OMGeometry source) {
        this.lineType = source.getLineType();
        this.visible = source.isVisible();
        this.attributes = source.getAttributes();
        this.needToRegenerate = true;
    }
}

