/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Azimuth
extends GeoProj {
    static final float ACCEPTABLE_AZ = ProjMath.degToRad(5.0f);
    protected transient Point world;
    protected boolean clockwise = true;
    protected Color spaceColor = Color.black;

    public Azimuth(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height);
    }

    @Override
    public String toString() {
        return " world(" + this.world.x + "," + this.world.y + ") " + super.toString();
    }

    @Override
    protected void init() {
        super.init();
        this.minscale = Math.ceil(2.0 * this.planetPixelRadius / 2.147483647E9);
        if (this.minscale < 1.0) {
            this.minscale = 1.0;
        }
    }

    @Override
    protected void computeParameters() {
        if (this.scale < this.minscale) {
            this.scale = this.minscale;
        }
        double d = this.maxscale = this.width < this.height ? this.planetPixelRadius * 2.0 / (double)this.width : this.planetPixelRadius * 2.0 / (double)this.height;
        if (this.maxscale < this.minscale) {
            this.maxscale = this.minscale;
        }
        if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        this.scaled_radius = this.planetPixelRadius / this.scale;
        if (this.world == null) {
            this.world = new Point(0, 0);
        }
        this.world.x = (int)(this.planetPixelRadius * 2.0 / this.scale);
        this.XSCALE_THRESHOLD = (int)(this.planetPixelRadius * 2.0 / 64000.0);
        if (Debug.debugging("proj")) {
            Debug.output("Azimuth.computeParameters(): world.x = " + this.world.x + " XSCALE_THRESHOLD = " + this.XSCALE_THRESHOLD);
        }
    }

    public void setClockwiseTraversal(boolean value) {
        this.clockwise = value;
    }

    public boolean isClockwiseTraversal() {
        return this.clockwise;
    }

    @Override
    public final Point2D forward(double lat, double lon, Point2D pt, boolean isRadian) {
        if (!isRadian) {
            lat = Math.toRadians(lat);
            lon = Math.toRadians(lon);
        }
        return this._forward(this.normalizeLatitude(lat), Azimuth.wrapLongitude(lon), pt, null);
    }

    protected abstract Point2D _forward(double var1, double var3, Point2D var5, AzimuthVar var6);

    public void pan(float Az) {
        if (MoreMath.approximately_equal(Math.abs(Az), 180.0f, 0.01f)) {
            this._panS();
        } else if (MoreMath.approximately_equal(Az, -135.0f, 0.01f)) {
            this._panSW();
        } else if (MoreMath.approximately_equal(Az, -90.0f, 0.01f)) {
            this._panW();
        } else if (MoreMath.approximately_equal(Az, -45.0f, 0.01f)) {
            this._panNW();
        } else if (MoreMath.approximately_equal(Az, 0.0f, 0.01f)) {
            this._panN();
        } else if (MoreMath.approximately_equal(Az, 45.0f, 0.01f)) {
            this._panNE();
        } else if (MoreMath.approximately_equal(Az, 90.0f, 0.01f)) {
            this._panE();
        } else if (MoreMath.approximately_equal(Az, 135.0f, 0.01f)) {
            this._panSE();
        } else {
            super.pan(Az);
        }
    }

    protected void _panNW() {
        if (this.overNorthPole()) {
            this.setCenter(1.5707963705062866, this.centerX - 0.7853981633974483, true);
        } else {
            LatLonPoint to = new LatLonPoint.Double();
            this.inverse(this.width / 2, 0.0, to);
            double lat = ((LatLonPoint)to).getRadLat();
            this.inverse(0.0, 0.0, to);
            ((LatLonPoint)to).setLatitude(ProjMath.radToDeg(lat));
            if (MoreMath.approximately_equal(((LatLonPoint)to).getRadLon(), this.centerX, (double)1.0E-4f)) {
                to = GreatCircle.sphericalBetween(this.centerY, this.centerX, 1.5707963267948966, -0.7853981633974483);
            }
            this.setCenter(to);
        }
    }

    protected void _panN() {
        if (this.overNorthPole()) {
            this.setCenter(1.5707963705062866, this.centerX, true);
        } else {
            LatLonPoint to = this.inverse(this.width / 2, 0.0);
            if (MoreMath.approximately_equal(to.getRadLat(), this.centerY, (double)1.0E-4f)) {
                to = GreatCircle.sphericalBetween(this.centerY, this.centerX, 1.5707963267948966, 0.0);
            }
            this.setCenter(to);
        }
    }

    protected void _panNE() {
        if (this.overNorthPole()) {
            this.setCenter(1.5707963705062866, this.centerX + 0.7853981633974483, true);
        } else {
            LatLonPoint to = new LatLonPoint.Double();
            this.inverse(this.width / 2, 0.0, to);
            double lat = ((LatLonPoint)to).getRadLat();
            this.inverse(this.width - 1, 0.0, to);
            ((LatLonPoint)to).setLatitude(ProjMath.radToDeg(lat));
            if (MoreMath.approximately_equal(((LatLonPoint)to).getRadLon(), this.centerX, (double)1.0E-4f)) {
                to = GreatCircle.sphericalBetween(this.centerY, this.centerX, 1.5707963267948966, 0.7853981633974483);
            }
            this.setCenter(to);
        }
    }

    protected void _panE() {
        if (this.overNorthPole() || this.overSouthPole()) {
            this.setCenter(this.centerY, this.centerX + 0.7853981633974483, true);
        } else {
            LatLonPoint to = this.inverse(new Point(this.width - 1, this.height / 2));
            to.setLatitude(ProjMath.radToDeg(this.centerY));
            if (MoreMath.approximately_equal(to.getRadLon(), this.centerX, (double)1.0E-4f)) {
                to = GreatCircle.sphericalBetween(this.centerY, this.centerX, 1.5707963267948966, 1.5707963267948966);
            }
            this.setCenter(to);
        }
    }

    protected void _panSE() {
        if (this.overSouthPole()) {
            this.setCenter(-1.5707963705062866, this.centerX + 0.7853981633974483, true);
        } else {
            LatLonPoint to = new LatLonPoint.Double();
            this.inverse(this.width / 2, this.height - 1, to);
            double lat = ((LatLonPoint)to).getRadLat();
            this.inverse(this.width - 1, this.height - 1, to);
            ((LatLonPoint)to).setLatitude(ProjMath.radToDeg(lat));
            if (MoreMath.approximately_equal(((LatLonPoint)to).getRadLon(), this.centerX, (double)1.0E-4f)) {
                to = GreatCircle.sphericalBetween(this.centerY, this.centerX, 1.5707963267948966, 2.356194490192345);
            }
            this.setCenter(to);
        }
    }

    protected void _panS() {
        if (this.overSouthPole()) {
            this.setCenter(-1.5707963705062866, this.centerX, true);
        } else {
            LatLonPoint to = this.inverse(this.width / 2, this.height);
            if (MoreMath.approximately_equal(to.getRadLat(), this.centerY, (double)1.0E-4f)) {
                to = GreatCircle.sphericalBetween(this.centerY, this.centerX, 1.5707963267948966, Math.PI);
            }
            this.setCenter(to);
        }
    }

    protected void _panSW() {
        if (this.overSouthPole()) {
            this.setCenter(-1.5707963705062866, this.centerX - 0.7853981633974483, true);
        } else {
            LatLonPoint to = new LatLonPoint.Double();
            this.inverse(this.width / 2, this.height - 1, to);
            double lat = ((LatLonPoint)to).getRadLat();
            this.inverse(0.0, this.height - 1, to);
            ((LatLonPoint)to).setLatitude(ProjMath.radToDeg(lat));
            if (MoreMath.approximately_equal(((LatLonPoint)to).getRadLon(), this.centerX, (double)1.0E-4f)) {
                to = GreatCircle.sphericalBetween(this.centerY, this.centerX, 1.5707963267948966, -2.356194490192345);
            }
            this.setCenter(to);
        }
    }

    protected void _panW() {
        if (this.overNorthPole() || this.overSouthPole()) {
            this.setCenter(this.centerY, this.centerX - 0.7853981633974483, true);
        } else {
            LatLonPoint to = this.inverse(new Point(0, this.height / 2));
            to.setLatitude(ProjMath.radToDeg(this.centerY));
            if (MoreMath.approximately_equal(to.getRadLon(), this.centerX, (double)1.0E-4f)) {
                to = GreatCircle.sphericalBetween(this.centerY, this.centerX, 1.5707963267948966, -1.5707963267948966);
            }
            this.setCenter(to);
        }
    }

    public boolean overNorthPole() {
        return this.overPoint(1.5707964f, 0.0f);
    }

    public boolean overSouthPole() {
        return this.overPoint(-1.5707964f, 0.0f);
    }

    public boolean overPoint(float lat, float lon) {
        AzimuthVar azVar = new AzimuthVar();
        Point2D pt = this._forward(lat, lon, new Point2D.Float(), azVar);
        if (azVar.invalid_forward) {
            return false;
        }
        return !(pt.getX() < 0.0 || pt.getX() > (double)this.width || pt.getY() < 0.0) && !(pt.getY() > (double)this.height);
    }

    @Override
    protected ArrayList<float[]> _forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        float[] y_;
        float[] x_;
        boolean DEBUG = Debug.debugging("proj");
        int len = rawllpts.length >>> 1;
        if (len < 2) {
            return new ArrayList<float[]>(0);
        }
        if (this.isComplicatedLineType(ltype)) {
            return this.doPolyDispatch(rawllpts, ltype, nsegs, isFilled);
        }
        int invalid_count = 0;
        boolean prev_invalid = false;
        Point temp = new Point();
        AzimuthVar az_first = null;
        AzimuthVar az_save = null;
        AzimuthVar azVar = new AzimuthVar();
        ArrayList<AzimuthVar> sections = new ArrayList<AzimuthVar>(128);
        float[] xs = new float[len];
        float[] ys = new float[len];
        this._forward(rawllpts[0], rawllpts[1], temp, azVar);
        xs[0] = temp.x;
        ys[0] = temp.y;
        prev_invalid = azVar.invalid_forward;
        if (prev_invalid) {
            ++invalid_count;
        } else {
            azVar.index = 0;
            azVar.current_azimuth = GreatCircle.sphericalAzimuth((float)this.centerY, (float)this.centerX, rawllpts[0], rawllpts[1]);
            if (!isFilled) {
                sections.add(azVar);
            } else {
                az_first = azVar;
            }
            azVar = new AzimuthVar();
        }
        int i = 0;
        int j = 0;
        i = 1;
        j = 2;
        while (i < len) {
            azVar.invalid_forward = false;
            this._forward(rawllpts[j], rawllpts[j + 1], temp, azVar);
            boolean curr_invalid = azVar.invalid_forward;
            xs[i] = temp.x;
            ys[i] = temp.y;
            if (!curr_invalid && prev_invalid) {
                azVar.index = i - 1;
                azVar.current_azimuth = GreatCircle.sphericalAzimuth((float)this.centerY, (float)this.centerX, rawllpts[j - 2], rawllpts[j - 1]);
                sections.add(azVar);
                azVar = new AzimuthVar();
            } else if (curr_invalid) {
                if (!prev_invalid) {
                    azVar.index = i;
                    if (isFilled && invalid_count == 0) {
                        az_save = azVar;
                    } else {
                        sections.add(azVar);
                    }
                    azVar = new AzimuthVar();
                }
                ++invalid_count;
            }
            prev_invalid = curr_invalid;
            ++i;
            j += 2;
        }
        if (invalid_count == 0) {
            ArrayList<float[]> ret_val = new ArrayList<float[]>(2);
            ret_val.add(xs);
            ret_val.add(ys);
            return ret_val;
        }
        if (invalid_count == len) {
            return new ArrayList<float[]>(0);
        }
        if (!prev_invalid) {
            if (isFilled && az_save != null) {
                int l = az_save.index;
                x_ = new float[len + l];
                y_ = new float[len + l];
                System.arraycopy(xs, 0, x_, 0, len);
                System.arraycopy(ys, 0, y_, 0, len);
                System.arraycopy(xs, 0, x_, len, l);
                System.arraycopy(ys, 0, y_, len, l);
                az_save.index = len + l;
                sections.add(az_save);
                xs = x_;
                ys = y_;
            } else {
                if (DEBUG && isFilled && az_save == null) {
                    Debug.output("AA, filled, no-wrap!");
                }
                azVar.index = i;
                j = rawllpts.length;
                azVar.current_azimuth = GreatCircle.sphericalAzimuth((float)this.centerY, (float)this.centerX, rawllpts[j - 2], rawllpts[j - 1]);
                sections.add(azVar);
            }
        } else if (az_save != null) {
            if (DEBUG) {
                Debug.output("DD, filled!");
            }
            sections.add(az_first);
            sections.add(az_save);
        }
        int size = sections.size();
        ArrayList<float[]> ret_val = new ArrayList<float[]>(size);
        if (isFilled && len > 2) {
            this.generateFilledPoly(xs, ys, sections, ret_val);
            return ret_val;
        }
        for (j = 0; j < size; j += 2) {
            AzimuthVar az1 = (AzimuthVar)sections.get(j);
            AzimuthVar az2 = sections.get(j + 1);
            int off1 = az1.index;
            int off2 = az2.index;
            int l = off2 - off1;
            x_ = new float[l];
            y_ = new float[l];
            System.arraycopy(xs, off1, x_, 0, l);
            System.arraycopy(ys, off1, y_, 0, l);
            ret_val.add(x_);
            ret_val.add(y_);
        }
        return ret_val;
    }

    @Override
    protected ArrayList<float[]> _forwardPoly(double[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        float[] y_;
        float[] x_;
        boolean DEBUG = Debug.debugging("proj");
        int len = rawllpts.length >>> 1;
        if (len < 2) {
            return new ArrayList<float[]>(0);
        }
        if (this.isComplicatedLineType(ltype)) {
            return this.doPolyDispatch(rawllpts, ltype, nsegs, isFilled);
        }
        int invalid_count = 0;
        boolean prev_invalid = false;
        Point temp = new Point();
        AzimuthVar az_first = null;
        AzimuthVar az_save = null;
        AzimuthVar azVar = new AzimuthVar();
        ArrayList<AzimuthVar> sections = new ArrayList<AzimuthVar>(128);
        float[] xs = new float[len];
        float[] ys = new float[len];
        this._forward(rawllpts[0], rawllpts[1], temp, azVar);
        xs[0] = temp.x;
        ys[0] = temp.y;
        prev_invalid = azVar.invalid_forward;
        if (prev_invalid) {
            ++invalid_count;
        } else {
            azVar.index = 0;
            azVar.current_azimuth = (float)GreatCircle.sphericalAzimuth(this.centerY, this.centerX, rawllpts[0], rawllpts[1]);
            if (!isFilled) {
                sections.add(azVar);
            } else {
                az_first = azVar;
            }
            azVar = new AzimuthVar();
        }
        int i = 0;
        int j = 0;
        i = 1;
        j = 2;
        while (i < len) {
            azVar.invalid_forward = false;
            this._forward(rawllpts[j], rawllpts[j + 1], temp, azVar);
            boolean curr_invalid = azVar.invalid_forward;
            xs[i] = temp.x;
            ys[i] = temp.y;
            if (!curr_invalid && prev_invalid) {
                azVar.index = i - 1;
                azVar.current_azimuth = (float)GreatCircle.sphericalAzimuth(this.centerY, this.centerX, rawllpts[j - 2], rawllpts[j - 1]);
                sections.add(azVar);
                azVar = new AzimuthVar();
            } else if (curr_invalid) {
                if (!prev_invalid) {
                    azVar.index = i;
                    if (isFilled && invalid_count == 0) {
                        az_save = azVar;
                    } else {
                        sections.add(azVar);
                    }
                    azVar = new AzimuthVar();
                }
                ++invalid_count;
            }
            prev_invalid = curr_invalid;
            ++i;
            j += 2;
        }
        if (invalid_count == 0) {
            ArrayList<float[]> ret_val = new ArrayList<float[]>(2);
            ret_val.add(xs);
            ret_val.add(ys);
            return ret_val;
        }
        if (invalid_count == len) {
            return new ArrayList<float[]>(0);
        }
        if (!prev_invalid) {
            if (isFilled && az_save != null) {
                int l = az_save.index;
                x_ = new float[len + l];
                y_ = new float[len + l];
                System.arraycopy(xs, 0, x_, 0, len);
                System.arraycopy(ys, 0, y_, 0, len);
                System.arraycopy(xs, 0, x_, len, l);
                System.arraycopy(ys, 0, y_, len, l);
                az_save.index = len + l;
                sections.add(az_save);
                xs = x_;
                ys = y_;
            } else {
                if (DEBUG && isFilled && az_save == null) {
                    Debug.output("AA, filled, no-wrap!");
                }
                azVar.index = i;
                j = rawllpts.length;
                azVar.current_azimuth = (float)GreatCircle.sphericalAzimuth(this.centerY, this.centerX, rawllpts[j - 2], rawllpts[j - 1]);
                sections.add(azVar);
            }
        } else if (az_save != null) {
            if (DEBUG) {
                Debug.output("DD, filled!");
            }
            sections.add(az_first);
            sections.add(az_save);
        }
        int size = sections.size();
        ArrayList<float[]> ret_val = new ArrayList<float[]>(size);
        if (isFilled && len > 2) {
            this.generateFilledPoly(xs, ys, sections, ret_val);
            return ret_val;
        }
        for (j = 0; j < size; j += 2) {
            AzimuthVar az1 = (AzimuthVar)sections.get(j);
            AzimuthVar az2 = sections.get(j + 1);
            int off1 = az1.index;
            int off2 = az2.index;
            int l = off2 - off1;
            x_ = new float[l];
            y_ = new float[l];
            System.arraycopy(xs, off1, x_, 0, l);
            System.arraycopy(ys, off1, y_, 0, l);
            ret_val.add(x_);
            ret_val.add(y_);
        }
        return ret_val;
    }

    private void generateFilledPoly(float[] xs, float[] ys, ArrayList<AzimuthVar> sections, ArrayList<float[]> ret_vec) {
        ArrayList<Object> merged = null;
        ArrayList<Serializable> masterList = new ArrayList<Serializable>();
        double[] edgePoints = null;
        int bg = 0;
        int io = 1;
        int vertexCount = 0;
        while (!sections.isEmpty()) {
            AzimuthVar beginAz = sections.get(bg);
            AzimuthVar ioAz = sections.get(io);
            int oi = this.findClosestAzimuth(sections, ioAz.current_azimuth, this.clockwise);
            AzimuthVar oiAz = sections.get(oi);
            int en = oi + 1;
            if (oi == bg) {
                if (merged != null) {
                    edgePoints = this.getHemisphereEdge(oiAz.current_azimuth, ioAz.current_azimuth);
                    merged.add(edgePoints);
                    masterList.add(new Integer(vertexCount += edgePoints.length >>> 1));
                    merged = null;
                    vertexCount = 0;
                } else {
                    this.hemisphereClip(xs, ys, oiAz, ioAz, ret_vec);
                }
                sections.remove(io);
                sections.remove(bg);
                bg = 0;
                io = 1;
                continue;
            }
            if (merged == null) {
                merged = new ArrayList<Object>();
                masterList.add(merged);
                merged.add(beginAz);
                merged.add(ioAz);
                vertexCount += ioAz.index - beginAz.index;
            }
            edgePoints = this.getHemisphereEdge(oiAz.current_azimuth, ioAz.current_azimuth);
            vertexCount += edgePoints.length >>> 1;
            merged.add(edgePoints);
            AzimuthVar endAz = sections.get(en);
            merged.add(oiAz);
            merged.add(endAz);
            vertexCount += endAz.index - oiAz.index;
            sections.set(io, endAz);
            sections.remove(en);
            sections.remove(oi);
        }
        Point temp = new Point();
        int masterSize = masterList.size();
        for (int i = 0; i < masterSize; i += 2) {
            merged = (ArrayList<Object>)masterList.get(i);
            vertexCount = (Integer)masterList.get(i + 1);
            float[] x_ = new float[vertexCount];
            float[] y_ = new float[vertexCount];
            int off = 0;
            int size = merged.size();
            for (int j = 0; j < size; j += 3) {
                int off1 = ((AzimuthVar)merged.get((int)j)).index;
                int off2 = ((AzimuthVar)merged.get((int)(j + 1))).index;
                int l = off2 - off1;
                System.arraycopy(xs, off1, x_, off, l);
                System.arraycopy(ys, off1, y_, off, l);
                off += l;
                edgePoints = (double[])merged.get(j + 2);
                int edgelen = edgePoints.length;
                for (int k = 0; k < edgelen; k += 2) {
                    this._forward(edgePoints[k], edgePoints[k + 1], temp, null);
                    x_[off] = temp.x;
                    y_[off] = temp.y;
                    ++off;
                }
            }
            ret_vec.add(x_);
            ret_vec.add(y_);
        }
    }

    private int findClosestAzimuth(ArrayList<AzimuthVar> sections, double az, boolean clockwise) {
        double closest = clockwise ? Math.PI * -2 : Math.PI * 2;
        int id = -1;
        for (int k = sections.size() - 2; k >= 0; k -= 2) {
            AzimuthVar oiAz = sections.get(k);
            double delta = az - oiAz.current_azimuth;
            if (delta > Math.PI) {
                delta = Math.PI * -2 + delta;
            } else if (delta < -Math.PI) {
                delta = Math.PI * 2 + delta;
            }
            if (clockwise) {
                if (delta > 0.0) {
                    delta = Math.PI * -2 + delta;
                }
                if (!(closest <= delta)) continue;
                closest = delta;
                id = k;
                continue;
            }
            if (delta < 0.0) {
                delta = Math.PI * 2 + delta;
            }
            if (!(closest >= delta)) continue;
            closest = delta;
            id = k;
        }
        return id;
    }

    private double[] getHemisphereEdge(double oiAz, double ioAz) {
        double delta = oiAz - ioAz;
        if (delta > Math.PI) {
            delta = Math.PI * -2 + delta;
        } else if (delta < -Math.PI) {
            delta = Math.PI * 2 + delta;
        }
        delta = Math.abs(delta);
        LatLonPoint ll1 = GreatCircle.sphericalBetween(this.centerY, this.centerX, 1.5707963267948966, ioAz);
        LatLonPoint ll2 = GreatCircle.sphericalBetween(this.centerY, this.centerX, 1.5707963267948966, oiAz);
        int npts = (int)(Math.abs(delta) / (double)ACCEPTABLE_AZ);
        if (npts == 0) {
            ++npts;
        }
        double[] radpts = GreatCircle.greatCircle(ll1.getRadLat(), ll1.getRadLon(), ll2.getRadLat(), ll2.getRadLon(), npts, true);
        return radpts;
    }

    private void hemisphereClip(float[] xs, float[] ys, AzimuthVar oiAz, AzimuthVar ioAz, ArrayList<float[]> ret_vec) {
        double[] radpts = this.getHemisphereEdge(oiAz.current_azimuth, ioAz.current_azimuth);
        int len = radpts.length;
        int m = len >>> 1;
        int off1 = oiAz.index;
        int off2 = ioAz.index;
        int l = off2 - off1;
        float[] x_ = new float[l + m];
        float[] y_ = new float[l + m];
        System.arraycopy(xs, off1, x_, 0, l);
        System.arraycopy(ys, off1, y_, 0, l);
        Point temp = new Point();
        int i = l;
        for (int j = 0; j < len; j += 2) {
            this._forward(radpts[j], radpts[j + 1], temp, null);
            x_[i] = temp.x;
            y_[i] = temp.y;
            ++i;
        }
        ret_vec.add(x_);
        ret_vec.add(y_);
    }

    @Override
    public boolean forwardRaw(float[] rawllpts, int rawoff, float[] xcoords, float[] ycoords, boolean[] visible, int copyoff, int copylen) {
        Point temp = new Point();
        AzimuthVar azVar = new AzimuthVar();
        boolean ok = true;
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            this._forward(rawllpts[j], rawllpts[j + 1], temp, azVar);
            xcoords[i] = temp.x;
            ycoords[i] = temp.y;
            visible[i] = ok = !azVar.invalid_forward;
            ++i;
            j += 2;
        }
        return ok;
    }

    @Override
    public boolean forwardRaw(double[] rawllpts, int rawoff, float[] xcoords, float[] ycoords, boolean[] visible, int copyoff, int copylen) {
        Point temp = new Point();
        AzimuthVar azVar = new AzimuthVar();
        boolean ok = true;
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            this._forward(rawllpts[j], rawllpts[j + 1], temp, azVar);
            xcoords[i] = temp.x;
            ycoords[i] = temp.y;
            visible[i] = ok = !azVar.invalid_forward;
            ++i;
            j += 2;
        }
        return ok;
    }

    @Override
    public void drawBackground(Graphics g) {
        if (this.scale <= 2.0E7) {
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        Paint oldPaint = null;
        oldPaint = g instanceof Graphics2D ? ((Graphics2D)g).getPaint() : g.getColor();
        g.setColor(this.spaceColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int s = this.world.x;
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setPaint(oldPaint);
        } else {
            g.setColor((Color)oldPaint);
        }
        g.fillArc(this.width / 2 - s / 2, this.height / 2 - s / 2, s, s, 0, 360);
    }

    @Override
    public String getName() {
        return "Azimuth";
    }

    public Color getSpaceColor() {
        return this.spaceColor;
    }

    public void setSpaceColor(Color spaceColor) {
        this.spaceColor = spaceColor;
    }

    protected static class AzimuthVar {
        boolean invalid_forward = false;
        double current_azimuth = Double.NaN;
        int index;

        protected AzimuthVar() {
        }
    }
}

