/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Length {
    MILE("mile", "miles", 24901.460807187756),
    FEET("feet", "ft", 1.3147971306195135E8),
    YARD("yards", "yd", 4.3826571020650454E7),
    METER("meter", "m", 4.007501668557849E7),
    KM("kilometer", "km", 40075.016685578485),
    NM("nautical mile", "nm", 21638.777907979744),
    DECIMAL_DEGREE("decimal degree", "deg", 360.0),
    DM("datamile", "dm", 21913.285510325226),
    RADIAN("radian", "rad", Math.PI * 2){

        public float toRadians(float numUnits) {
            return numUnits;
        }

        public double toRadians(double numUnits) {
            return numUnits;
        }

        public float fromRadians(float numRadians) {
            return numRadians;
        }

        public double fromRadians(double numRadians) {
            return numRadians;
        }
    };

    protected final double constant;
    protected final String name;
    protected final String abbr;
    protected double unitEquatorCircumference;
    protected transient I18n i18n = Environment.getI18n();

    private Length(String name, String abbr, double unitEquatorCircumference) {
        this.name = this.i18n.get((Object)this, abbr + ".name", name).toLowerCase().intern();
        this.unitEquatorCircumference = unitEquatorCircumference;
        this.constant = unitEquatorCircumference / (Math.PI * 2);
        this.abbr = abbr.toLowerCase().intern();
    }

    public float toRadians(float numUnits) {
        Length.getLogger().fine("Translating " + this.name + " from radians");
        return numUnits / (float)this.constant;
    }

    public double toRadians(double numUnits) {
        Length.getLogger().fine("Translating " + this.name + " from radians");
        return numUnits / this.constant;
    }

    public float fromRadians(float numRadians) {
        Length.getLogger().fine("Translating radians from " + this.name);
        return numRadians * (float)this.constant;
    }

    public double fromRadians(double numRadians) {
        Length.getLogger().fine("Translating radians from " + this.name);
        return numRadians * this.constant;
    }

    public String toString() {
        return this.name;
    }

    public String getAbbr() {
        return this.abbr;
    }

    public static Length get(String name) {
        if (name != null) {
            for (Length length : Length.values()) {
                if (!length.name.equalsIgnoreCase(name) && !length.abbr.equalsIgnoreCase(name)) continue;
                return length;
            }
        }
        return null;
    }

    private static Logger getLogger() {
        return LoggerHolder.LOGGER;
    }

    private static final class LoggerHolder {
        private static final Logger LOGGER = Logger.getLogger(Length.class.getName());

        private LoggerHolder() {
            throw new AssertionError((Object)"This should never be instantiated");
        }
    }
}

