/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.drawing;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.tools.drawing.EditClassWrapper;
import com.bbn.openmap.tools.drawing.EditToolLoader;
import com.bbn.openmap.util.Debug;
import java.util.HashMap;
import javax.swing.ImageIcon;

public abstract class AbstractToolLoader
implements EditToolLoader {
    protected HashMap graphicInfo;
    protected I18n i18n = Environment.getI18n();

    public abstract void init();

    public void addEditClassWrapper(EditClassWrapper ecw) {
        if (this.graphicInfo == null) {
            this.graphicInfo = new HashMap();
        }
        if (ecw != null) {
            this.graphicInfo.put(ecw.getClassName().intern(), ecw);
        }
    }

    public void removeEditClassWrapper(EditClassWrapper ecw) {
        if (this.graphicInfo != null && ecw != null) {
            this.graphicInfo.remove(ecw.getClassName().intern());
        }
    }

    public String[] getEditableClasses() {
        String[] strings = null;
        if (this.graphicInfo != null) {
            Object[] keys = this.graphicInfo.keySet().toArray();
            strings = new String[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                strings[i] = (String)keys[i];
            }
        }
        return strings;
    }

    public EditableOMGraphic getEditableGraphic(String classname) {
        EditClassWrapper ecw;
        EditableOMGraphic eomg = null;
        if (this.graphicInfo != null && (ecw = (EditClassWrapper)this.graphicInfo.get(classname.intern())) != null) {
            String ecn = ecw.getEditableClassName();
            try {
                Object obj = Class.forName(ecn).newInstance();
                if (obj instanceof EditableOMGraphic) {
                    eomg = (EditableOMGraphic)obj;
                }
            }
            catch (ClassNotFoundException cnfe) {
                Debug.error("AbstractToolLoader can't get editable graphic for " + classname + "\n    ClassNotFoundException caught.");
            }
            catch (InstantiationException ie) {
                Debug.error("AbstractToolLoader can't get editable graphic for " + classname + "\n    InstantiationException caught.");
            }
            catch (IllegalAccessException iae) {
                Debug.error("AbstractToolLoader can't get editable graphic for " + classname + "\n    IllegalAccessException caught.");
            }
        }
        return eomg;
    }

    public EditableOMGraphic getEditableGraphic(String classname, GraphicAttributes ga) {
        EditableOMGraphic eomg = this.getEditableGraphic(classname);
        if (eomg != null && ga != null) {
            eomg.createGraphic(ga);
        }
        return eomg;
    }

    public abstract EditableOMGraphic getEditableGraphic(OMGraphic var1);

    public ImageIcon getIcon(String classname) {
        EditClassWrapper ecw;
        if (this.graphicInfo != null && (ecw = (EditClassWrapper)this.graphicInfo.get(classname.intern())) != null) {
            return ecw.getIcon();
        }
        return null;
    }

    public String getPrettyName(String classname) {
        EditClassWrapper ecw;
        if (this.graphicInfo != null && (ecw = (EditClassWrapper)this.graphicInfo.get(classname.intern())) != null) {
            return ecw.getPrettyName();
        }
        return null;
    }
}

