/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.drawing;

import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.tools.drawing.OMDrawingTool;
import com.bbn.openmap.util.Debug;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public class OMDrawingToolMouseMode
extends CoordMouseMode {
    private static final long serialVersionUID = 1L;
    public static final transient String modeID = "Drawing";
    protected OMDrawingTool drawingTool = null;

    public OMDrawingToolMouseMode() {
        super(modeID, true);
    }

    public OMDrawingToolMouseMode(OMDrawingTool omdt) {
        this();
        this.drawingTool = omdt;
        this.setModeCursor(Cursor.getPredefinedCursor(0));
    }

    protected void setDrawingTool(OMDrawingTool omdt) {
        this.drawingTool = omdt;
    }

    protected OMDrawingTool getDrawingTool() {
        return this.drawingTool;
    }

    protected EditableOMGraphic getCurrentGraphic() {
        if (this.drawingTool == null) {
            return null;
        }
        return this.drawingTool.getCurrentEditable();
    }

    public void mousePressed(MouseEvent e) {
        Debug.message("drawingtooldetail", "DrawingTool.mousePressed");
        EditableOMGraphic graphic = this.getCurrentGraphic();
        if (graphic != null) {
            graphic.mousePressed(e);
        }
        this.fireMouseLocation(e);
    }

    public void mouseReleased(MouseEvent e) {
        Debug.message("drawingtooldetail", "DrawingTool.mousePressed");
        EditableOMGraphic graphic = this.getCurrentGraphic();
        if (graphic != null) {
            graphic.mouseReleased(e);
        }
        this.fireMouseLocation(e);
        if (this.drawingTool != null && this.drawingTool.isMask(32)) {
            this.drawingTool.deactivate();
        }
    }

    public void mouseClicked(MouseEvent e) {
        Debug.message("drawingtooldetail", "DrawingTool.mouseClicked");
        EditableOMGraphic graphic = this.getCurrentGraphic();
        if (graphic != null) {
            graphic.mouseClicked(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
        Debug.message("drawingtooldetail", "DrawingTool.mouseEntered");
        EditableOMGraphic graphic = this.getCurrentGraphic();
        if (graphic != null) {
            graphic.mouseEntered(e);
        }
    }

    public void mouseExited(MouseEvent e) {
        Debug.message("drawingtooldetail", "DrawingTool.mouseExited");
        EditableOMGraphic graphic = this.getCurrentGraphic();
        if (graphic != null) {
            graphic.mouseExited(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        Debug.message("drawingtooldetail", "DrawingTool.mouseDragged");
        EditableOMGraphic graphic = this.getCurrentGraphic();
        if (graphic != null) {
            graphic.mouseDragged(e);
        }
        this.fireMouseLocation(e);
    }

    public void mouseMoved(MouseEvent e) {
        Debug.message("drawingtooldetail", "DrawingTool.mouseMoved");
        EditableOMGraphic graphic = this.getCurrentGraphic();
        if (graphic != null) {
            graphic.mouseMoved(e);
        }
        this.fireMouseLocation(e);
    }
}

