/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist;

import com.bbn.openmap.corba.CSpecialist.EComp;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.GF_update;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.PolyPackage.CoordMode;
import com.bbn.openmap.corba.CSpecialist.PolyPackage.EPoly;
import com.bbn.openmap.corba.CSpecialist.PolyPackage.PF_update;
import com.bbn.openmap.corba.CSpecialist.XYPoint;
import com.bbn.openmap.layer.specialist.JGraphic;
import com.bbn.openmap.layer.specialist.JObjectHolder;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.ProjMath;
import java.awt.Color;
import java.io.Serializable;

public class JPoly
extends OMPoly
implements Serializable,
JObjectHolder {
    protected transient EComp object = null;

    public JPoly(EPoly epoly) {
        int i;
        JGraphic.fillOMGraphicParams((OMGraphic)this, epoly.egraphic);
        Color fc = JGraphic.getColor(epoly.egraphic.fillColor);
        this.setIsPolygon(fc != null);
        this.units = 1;
        this.lat = ProjMath.degToRad((float)epoly.ll1.lat);
        this.lon = ProjMath.degToRad((float)epoly.ll1.lon);
        int npts = epoly.xypoints.length;
        if (npts > 0) {
            this.xs = new int[npts];
            this.ys = new int[npts];
            for (i = 0; i < npts; ++i) {
                this.xs[i] = epoly.xypoints[i].x;
                this.ys[i] = epoly.xypoints[i].y;
            }
        }
        if ((npts = epoly.llpoints.length) > 0) {
            this.rawllpts = this.isPolygon ? new double[npts * 2 + 2] : new double[npts * 2];
            i = 0;
            int j = 0;
            while (i < npts) {
                this.rawllpts[j] = ProjMath.degToRad((float)epoly.llpoints[i].lat);
                this.rawllpts[j + 1] = ProjMath.degToRad((float)epoly.llpoints[i].lon);
                ++i;
                j += 2;
            }
            if (this.isPolygon) {
                this.rawllpts[j] = this.rawllpts[0];
                this.rawllpts[j + 1] = this.rawllpts[1];
            }
        }
        this.coordMode = JPoly.getCoordMode(epoly.cMode);
    }

    public static int getCoordMode(CoordMode cMode) {
        int cm;
        switch (cMode.value()) {
            case 1: {
                cm = 1;
                break;
            }
            default: {
                cm = 0;
            }
        }
        return cm;
    }

    public void setObject(EComp aObject) {
        this.object = aObject;
    }

    public EComp getObject() {
        return this.object;
    }

    public void update(GF_update update) {
        JGraphic.update(this, update);
    }

    public void update(PF_update update) {
        switch (update.discriminator().value()) {
            case 0: {
                LLPoint ll = update.ll1();
                this.lat = ll.lat;
                this.lon = ll.lon;
                this.setNeedToRegenerate(true);
                break;
            }
            case 1: {
                int newMode = JPoly.getCoordMode(update.cMode());
                if (newMode == this.coordMode) break;
                this.coordMode = newMode;
                this.setNeedToRegenerate(true);
                break;
            }
            case 2: {
                XYPoint[] xypoints = update.xypoints();
                int npts = xypoints.length;
                if (npts > 0) {
                    this.xs = new int[npts];
                    this.ys = new int[npts];
                    for (int i = 0; i < npts; ++i) {
                        this.xs[i] = xypoints[i].x;
                        this.ys[i] = xypoints[i].y;
                    }
                }
                if (this.renderType == 1) break;
                this.setNeedToRegenerate(true);
                break;
            }
            case 3: {
                LLPoint[] llpoints = update.llpoints();
                int npts = llpoints.length;
                if (npts > 0) {
                    this.rawllpts = new double[npts * 2];
                    for (int i = 0; i < npts; i += 2) {
                        this.rawllpts[i] = llpoints[i].lat;
                        this.rawllpts[i + 1] = llpoints[i].lon;
                    }
                }
                if (this.renderType != 1) break;
                this.setNeedToRegenerate(true);
                break;
            }
            default: {
                System.err.println("JPoly.update: invalid poly update");
            }
        }
    }
}

