/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.pilot;

import com.bbn.openmap.MapHandler;
import com.bbn.openmap.graphicLoader.MMLGraphicLoader;
import com.bbn.openmap.omGraphics.BasicStrokeEditor;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicHandler;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.plugin.pilot.Pilot;
import com.bbn.openmap.plugin.pilot.PilotPath;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.tools.drawing.OMDrawingTool;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class PilotLoader
extends MMLGraphicLoader
implements ActionListener,
DrawingToolRequestor {
    protected OMDrawingTool dt = null;
    public static final String AddNodeCmd = "AddNodeCommand";
    public static final String AddPathCmd = "AddPathCommand";
    HashMap points = new HashMap();
    JCheckBox timerButton = null;
    JButton addPathButton = null;
    public static int pointCount = 1;

    public PilotLoader() {
    }

    public PilotLoader(OMGraphicHandler receiver) {
        this();
        this.receiver = receiver;
    }

    public void manageGraphics() {
        OMGraphicList list = new OMGraphicList();
        for (Pilot mp : this.points.values()) {
            mp.move(40.0f);
            mp.resetConnected();
            list.add((OMGraphic)mp);
        }
        if (this.receiver != null) {
            Debug.message((String)"pilotloader", (String)"PilotLoader.manageGraphics: Updating graphics.");
            this.receiver.setList(list);
        } else {
            Debug.message((String)"pilotloader", (String)"PilotLoader.manageGraphics: no receiver to notify.");
        }
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd == "TimerCommand") {
            JCheckBox check = (JCheckBox)ae.getSource();
            if (check.isSelected()) {
                this.timer.restart();
            } else {
                this.timer.stop();
            }
        } else if (cmd == AddNodeCmd) {
            if (this.dt != null) {
                GraphicAttributes ga = new GraphicAttributes();
                ga.setRenderType(1);
                OMPoint pt = (OMPoint)this.dt.create("com.bbn.openmap.omGraphics.OMPoint", ga, (DrawingToolRequestor)this, false);
                if (pt != null) {
                    this.getTimer().stop();
                    pt.setRadius(5);
                    pt.setOval(true);
                    pt.setFillPaint((Paint)Color.red);
                    this.addPathButton.setEnabled(false);
                }
            }
        } else if (cmd == AddPathCmd && this.dt != null) {
            GraphicAttributes ga = new GraphicAttributes();
            ga.setRenderType(1);
            ga.setLineType(3);
            OMPoly poly = (OMPoly)this.dt.create("com.bbn.openmap.omGraphics.OMPoly", ga, (DrawingToolRequestor)this, true);
            if (poly != null) {
                this.getTimer().stop();
                BasicStrokeEditor bse = new BasicStrokeEditor();
                bse.setDash(new float[]{5.0f, 5.0f});
                ga.setStroke((Stroke)bse.getBasicStroke());
                ga.setLinePaint((Paint)Color.yellow);
                this.addPathButton.setEnabled(false);
            }
        }
        this.manageGraphics();
    }

    public void findAndInit(Object obj) {
        if (obj instanceof OMDrawingTool) {
            Debug.message((String)"graphicloader", (String)"LOSGraphicLoader: found OMDrawingTool");
            this.setDrawingTool((OMDrawingTool)obj);
        }
    }

    public void findAndUndo(Object obj) {
        if (obj instanceof OMDrawingTool) {
            Debug.message((String)"graphicloader", (String)"LOSGraphicLoader: removing OMDrawingTool");
            OMDrawingTool odt = this.getDrawingTool();
            if (odt == obj) {
                this.setDrawingTool(null);
            }
        }
    }

    public void setDrawingTool(OMDrawingTool drawingTool) {
        this.dt = drawingTool;
        if (this.addPathButton != null) {
            this.addPathButton.setEnabled(drawingTool != null);
        }
    }

    public OMDrawingTool getDrawingTool() {
        return this.dt;
    }

    public Component getGUI() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        if (this.addPathButton == null) {
            this.addPathButton = new JButton("Add Path for Pilot");
            this.addPathButton.addActionListener(this);
            this.addPathButton.setActionCommand(AddPathCmd);
        }
        if (this.getDrawingTool() == null) {
            this.addPathButton.setEnabled(false);
            this.addPathButton.setToolTipText("Drawing Tool not connected, can't create Pilot path.");
        } else {
            this.addPathButton.setToolTipText("Click to use Drawing Tool to create Pilot path.");
        }
        panel.add(this.addPathButton);
        if (this.timerButton == null) {
            this.timerButton = new JCheckBox("Run Timer", this.getTimer().isRunning());
            this.timerButton.addActionListener(this);
            this.timerButton.setActionCommand("TimerCommand");
        }
        panel.add(this.timerButton);
        return panel;
    }

    public void drawingComplete(OMGraphic omg, OMAction action) {
        if (this.timerButton.isSelected()) {
            this.timer.restart();
        }
        if (omg instanceof OMPoint) {
            OMPoint p = (OMPoint)omg;
            Pilot mp = new Pilot(p.getLat(), p.getLon(), p.getRadius(), true);
            mp.setName("Added Node " + pointCount++);
            mp.setStationary(true);
            mp.showPalette();
            this.points.put(mp.getName(), mp);
            this.manageGraphics();
        } else if (omg instanceof OMPoly) {
            OMPoly poly = (OMPoly)omg;
            PilotPath pmp = new PilotPath(poly, 5, true);
            pmp.setName("Added Node " + pointCount++);
            pmp.setStationary(true);
            pmp.showPalette();
            this.points.put(pmp.getName(), pmp);
            pmp.setMapHandler((MapHandler)this.getBeanContext());
            this.manageGraphics();
        }
        this.addPathButton.setEnabled(true);
    }

    public String getName() {
        return "";
    }
}

